/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.Statement;

class DoWhileFactory {
    DoWhileFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, DoStatement doStmt) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)doStmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)doStmt);
        Node bodyNode = DelegatingNodeFactory.createOrHelper(astpp, "body", (ControlFlowElement)doStmt, (ControlFlowElement)doStmt.getStatement());
        Node conditionNode = DelegatingNodeFactory.createOrHelper(astpp, "condition", (ControlFlowElement)doStmt, (ControlFlowElement)doStmt.getExpression());
        HelperNode conditionForkNode = new HelperNode("conditionFork", astpp.pos(), (ControlFlowElement)doStmt);
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)doStmt);
        cNode.addNode(entryNode);
        cNode.addNode(bodyNode);
        cNode.addNode(conditionNode);
        cNode.addNode(conditionForkNode);
        cNode.addNode(exitNode);
        cNode.connectInternalSucc(entryNode, bodyNode, conditionNode, conditionForkNode);
        cNode.connectInternalSucc(ControlFlowType.LoopReenter, conditionForkNode, bodyNode);
        cNode.connectInternalSucc(ControlFlowType.LoopExit, conditionForkNode, exitNode);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        bodyNode.addCatchToken(new CatchToken(ControlFlowType.IfTrue, ControlFlowType.LoopReenter));
        exitNode.addCatchToken(new CatchToken(ControlFlowType.IfFalse, ControlFlowType.LoopExit));
        LabelledStatement lblStmt = ASTUtils.getLabelledStatement((Statement)doStmt);
        exitNode.addCatchToken(new CatchToken(ControlFlowType.Break, lblStmt));
        conditionNode.addCatchToken(new CatchToken(ControlFlowType.Continue, lblStmt));
        return cNode;
    }
}

