/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSClassifierValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    @Extension
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkWildcardInExtendsImplements(N4ClassifierDefinition n4ClassifierDef) {
        Object _switchResult = null;
        boolean _matched = false;
        if (n4ClassifierDef instanceof N4ClassDefinition) {
            _matched = true;
            ParameterizedTypeRef _superClassRef = ((N4ClassDefinition)n4ClassifierDef).getSuperClassRef();
            EList _implementedInterfaceRefs = ((N4ClassDefinition)n4ClassifierDef).getImplementedInterfaceRefs();
            _switchResult = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ParameterizedTypeRef[]{_superClassRef})), (Iterable)_implementedInterfaceRefs);
        }
        if (!_matched && n4ClassifierDef instanceof N4InterfaceDeclaration) {
            _matched = true;
            _switchResult = ((N4InterfaceDeclaration)n4ClassifierDef).getSuperInterfaceRefs();
        }
        Iterable superTypeRefs = IterableExtensions.filterNull(_switchResult);
        for (ParameterizedTypeRef typeRef : superTypeRefs) {
            EList _typeArgs = typeRef.getTypeArgs();
            for (TypeArgument typeArg : _typeArgs) {
                if (!(typeArg instanceof Wildcard)) continue;
                this.addIssue(IssueCodes.getMessageForCLF_IMPLEMENT_EXTEND_WITH_WILDCARD(), (EObject)typeArg, "CLF_IMPLEMENT_EXTEND_WITH_WILDCARD");
            }
        }
    }

    @Check
    public void checkConsumingRoles(N4ClassifierDefinition n4ClassifierDefinition) {
        Type _definedType = n4ClassifierDefinition.getDefinedType();
        TClassifier tClassifier = (TClassifier)_definedType;
        if (tClassifier == null) {
            return;
        }
        this.internalCheckDuplicatedConsumedInterfaces(tClassifier);
    }

    private void internalCheckDuplicatedConsumedInterfaces(TClassifier classifier) {
        Functions.Function1 _function;
        boolean _matched = false;
        if (classifier instanceof TClass) {
            _matched = true;
            _function = it -> {
                Type _declaredType = it.getDeclaredType();
                QualifiedName _fullyQualifiedName = null;
                if (_declaredType != null) {
                    _fullyQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)_declaredType);
                }
                return _fullyQualifiedName;
            };
            this.doInternalCheckDuplicatedConsumedRoles(IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)((TClass)classifier).getImplementedInterfaceRefs(), (Functions.Function1)_function))), (SyntaxRelatedTElement)classifier, N4JSPackage.Literals.N4_CLASS_DEFINITION__IMPLEMENTED_INTERFACE_REFS);
        }
        if (!_matched && classifier instanceof TInterface) {
            _matched = true;
            _function = it -> {
                Type _declaredType = it.getDeclaredType();
                QualifiedName _fullyQualifiedName = null;
                if (_declaredType != null) {
                    _fullyQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)_declaredType);
                }
                return _fullyQualifiedName;
            };
            this.doInternalCheckDuplicatedConsumedRoles(IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)((TInterface)classifier).getSuperInterfaceRefs(), (Functions.Function1)_function))), (SyntaxRelatedTElement)classifier, N4JSPackage.Literals.N4_INTERFACE_DECLARATION__SUPER_INTERFACE_REFS);
        }
        if (!_matched) {
            return;
        }
    }

    private void doInternalCheckDuplicatedConsumedRoles(List<QualifiedName> names, SyntaxRelatedTElement source, EReference eref) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(names);
        if (_isNullOrEmpty) {
            return;
        }
        Functions.Function1 _function = it -> this.qualifiedNameConverter.toString(it);
        Functions.Function1 _function_1 = it -> {
            Integer _value = (Integer)it.getValue();
            return _value > 1;
        };
        Iterable duplicates = IterableExtensions.filter(N4JSClassifierValidator.computeStringOccurance(ListExtensions.map(names, (Functions.Function1)_function)), (Functions.Function1)_function_1);
        for (Pair dupe : duplicates) {
            String message = IssueCodes.getMessageForCLF_MULTIPLE_ROLE_CONSUME(dupe.getKey());
            this.addIssue(message, source.getAstElement(), (EStructuralFeature)eref, "CLF_MULTIPLE_ROLE_CONSUME", new String[0]);
        }
    }

    private static Iterable<Pair<String, Integer>> computeStringOccurance(Collection<String> collection) {
        HashMap<String, Integer> acc = new HashMap<String, Integer>();
        for (String entry : collection) {
            boolean _containsKey = acc.containsKey(entry);
            if (_containsKey) {
                int _intValue = (Integer)acc.get(entry);
                int _plus = _intValue + 1;
                acc.put(entry, _plus);
                continue;
            }
            acc.put(entry, 1);
        }
        HashMap<String, Integer> finalAcc = acc;
        Functions.Function1 _function = it -> {
            Integer _get = (Integer)finalAcc.get(it);
            return Pair.of((Object)it, (Object)_get);
        };
        return IterableExtensions.map(acc.keySet(), (Functions.Function1)_function);
    }

    @Check
    public void checkUniqueOwenedMemberNames(N4ClassifierDefinition n4ClassifierDefinition) {
        boolean _not;
        Type _definedType = n4ClassifierDefinition.getDefinedType();
        boolean bl = _not = !(_definedType instanceof TClassifier);
        if (_not) {
            return;
        }
        Type _definedType_1 = n4ClassifierDefinition.getDefinedType();
        TClassifier tClassifier = (TClassifier)_definedType_1;
        Function _function = it -> Tuples.pair((Object)it.getName(), (Object)it.isStatic());
        ImmutableMap ownedMembersByNameAndStatic = Multimaps.index((Iterable)tClassifier.getOwnedMembers(), (Function)_function).asMap();
        Consumer<Collection> _function_1 = it -> {
            boolean _greaterThan;
            int _size = it.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.createErrorsForDuplicateOwnedMembers((Iterable<? extends TMember>)it);
                TMember _head = (TMember)IterableExtensions.head((Iterable)it);
                if (_head instanceof TGetter) {
                    this.createErrorsForDuplicateOwnedMembers(Iterables.filter((Iterable)it, TSetter.class));
                } else {
                    TMember _head_1 = (TMember)IterableExtensions.head((Iterable)it);
                    if (_head_1 instanceof TSetter) {
                        this.createErrorsForDuplicateOwnedMembers(Iterables.filter((Iterable)it, TGetter.class));
                    }
                }
            }
        };
        ownedMembersByNameAndStatic.values().forEach(_function_1);
    }

    private void createErrorsForDuplicateOwnedMembers(Iterable<? extends TMember> members) {
        TMember firstDup = (TMember)IterableExtensions.head(members);
        boolean createErrorForFirst = true;
        Iterable _tail = IterableExtensions.tail(members);
        for (TMember otherDup : _tail) {
            boolean _not;
            boolean _isFieldAccessorPair = this.isFieldAccessorPair(firstDup, otherDup);
            boolean bl = _not = !_isFieldAccessorPair;
            if (!_not) continue;
            boolean _isConstructor = firstDup.isConstructor();
            if (_isConstructor) {
                if (createErrorForFirst) {
                    String message = IssueCodes.getMessageForCLF_DUP_CTOR(NodeModelUtils.getNode((EObject)firstDup.getAstElement()).getStartLine(), NodeModelUtils.getNode((EObject)otherDup.getAstElement()).getStartLine());
                    this.addIssue(message, firstDup.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_DUP_CTOR", new String[0]);
                    createErrorForFirst = false;
                }
                String message_1 = IssueCodes.getMessageForCLF_DUP_CTOR(NodeModelUtils.getNode((EObject)otherDup.getAstElement()).getStartLine(), NodeModelUtils.getNode((EObject)firstDup.getAstElement()).getStartLine());
                this.addIssue(message_1, otherDup.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_DUP_CTOR", new String[0]);
                continue;
            }
            if (createErrorForFirst) {
                String message_2 = IssueCodes.getMessageForCLF_DUP_MEMBER(this.validatorMessageHelper.descriptionWithLine(firstDup), this.validatorMessageHelper.descriptionWithLine(otherDup));
                this.addIssue(message_2, firstDup.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_DUP_MEMBER", new String[0]);
                createErrorForFirst = false;
            }
            String message_3 = IssueCodes.getMessageForCLF_DUP_MEMBER(this.validatorMessageHelper.descriptionWithLine(otherDup), this.validatorMessageHelper.descriptionWithLine(firstDup));
            this.addIssue(message_3, otherDup.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_DUP_MEMBER", new String[0]);
        }
    }

    @Check
    public void checkUseOfDefinitionSiteVariance(TypeVariable typeVar) {
        if (!(!typeVar.isDeclaredCovariant() && !typeVar.isDeclaredContravariant() || typeVar.eContainer() instanceof N4ClassifierDeclaration && typeVar.eContainmentFeature() == N4JSPackage.eINSTANCE.getGenericDeclaration_TypeVars())) {
            String message = IssueCodes.getMessageForCLF_DEF_SITE_VARIANCE_ONLY_IN_CLASSIFIER();
            EAttribute _xifexpression = null;
            boolean _isDeclaredCovariant = typeVar.isDeclaredCovariant();
            _xifexpression = _isDeclaredCovariant ? TypesPackage.eINSTANCE.getTypeVariable_DeclaredCovariant() : TypesPackage.eINSTANCE.getTypeVariable_DeclaredContravariant();
            EAttribute feature = _xifexpression;
            this.addIssue(message, (EObject)typeVar, (EStructuralFeature)feature, "CLF_DEF_SITE_VARIANCE_ONLY_IN_CLASSIFIER", new String[0]);
        }
    }

    @Check
    public void checkTypeVariableVariance(ParameterizedTypeRef typeRefInAST) {
        Variance varianceOfPos;
        Variance variance;
        Type tv = typeRefInAST.getDeclaredType();
        if (tv instanceof TypeVariable && (variance = ((TypeVariable)tv).getVariance()) != Variance.INV && (varianceOfPos = N4JSLanguageUtils.getVarianceOfPosition((TypeRef)typeRefInAST)) != null && variance != varianceOfPos) {
            String msg = IssueCodes.getMessageForCLF_TYPE_VARIABLE_AT_INVALID_POSITION(variance.getDescriptiveString(true), varianceOfPos.getDescriptiveString(false));
            this.addIssue(msg, (EObject)typeRefInAST, "CLF_TYPE_VARIABLE_AT_INVALID_POSITION");
        }
    }
}

