/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.imports;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.documentation.N4JSDocumentationProvider;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.ts.services.TypeExpressionsGrammarAccess;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ImportRegionHelper {
    @Inject
    private N4JSDocumentationProvider documentationProvider;
    @Inject
    private TypeExpressionsGrammarAccess typeExpressionGrammmarAccess;

    public int findInsertionOffset(Script script) {
        int result = 0;
        EList scriptElements = script.getScriptElements();
        int i = 0;
        int size = scriptElements.size();
        while (i < size) {
            ScriptElement element = (ScriptElement)scriptElements.get(i);
            if (!(element instanceof ImportDeclaration)) break;
            ICompositeNode importNode = NodeModelUtils.findActualNodeFor((EObject)element);
            if (importNode != null) {
                result = importNode.getTotalOffset() + ImportRegionHelper.getLengthWithoutAutomaticSemicolon((INode)importNode);
            }
            ++i;
        }
        if (result != 0) {
            return result;
        }
        return this.getImportRegion((Script)script).offset;
    }

    private static int getLengthWithoutAutomaticSemicolon(INode node) {
        if (node instanceof ILeafNode) {
            return node.getLength();
        }
        int length = 0;
        for (INode leafNode : ((ICompositeNode)node).getLeafNodes()) {
            if (UtilN4.isIgnoredSyntaxErrorNode((INode)leafNode, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"})) continue;
            length += leafNode.getLength();
        }
        return length;
    }

    private InsertionPoint getImportRegion(Script script) {
        InsertionPoint insertionPoint = new InsertionPoint();
        int begin = -1;
        if (script != null) {
            begin = 0;
            List scriptAnnos = NodeModelUtils.findNodesForFeature((EObject)script, (EStructuralFeature)N4JSPackage.Literals.SCRIPT__ANNOTATIONS);
            if (!scriptAnnos.isEmpty()) {
                INode lastAnno = (INode)scriptAnnos.get(scriptAnnos.size() - 1);
                insertionPoint.notBeforeTotalOffset = begin = lastAnno.getTotalEndOffset();
            }
            EList elements = script.getScriptElements();
            int lastSeenDirective = -1;
            int idxNondirectiveStatemnt = -1;
            int i = 0;
            while (i < elements.size() && idxNondirectiveStatemnt == -1) {
                ScriptElement curr = (ScriptElement)elements.get(i);
                if (N4JSASTUtils.isStringLiteralExpression((ScriptElement)curr)) {
                    lastSeenDirective = i;
                } else if (!(curr instanceof ImportDeclaration)) {
                    idxNondirectiveStatemnt = i;
                }
                ++i;
            }
            if (idxNondirectiveStatemnt != -1) {
                ScriptElement realScriptElement = (ScriptElement)elements.get(idxNondirectiveStatemnt);
                ICompositeNode realScriptElementNode = NodeModelUtils.findActualNodeFor((EObject)realScriptElement);
                List docuNodes = this.documentationProvider.getDocumentationNodes((EObject)realScriptElement);
                if (!docuNodes.isEmpty()) {
                    INode docuNode;
                    INode previousNode = docuNode = (INode)docuNodes.get(0);
                    INode lastEOL = null;
                    boolean cont = true;
                    while (cont && previousNode.hasPreviousSibling() && previousNode.getPreviousSibling() instanceof HiddenLeafNode) {
                        EObject grammar = previousNode.getPreviousSibling().getGrammarElement();
                        if (grammar == this.typeExpressionGrammmarAccess.getWSRule()) {
                            previousNode = previousNode.getPreviousSibling();
                            continue;
                        }
                        if (grammar == this.typeExpressionGrammmarAccess.getEOLRule()) {
                            lastEOL = previousNode = previousNode.getPreviousSibling();
                            continue;
                        }
                        cont = false;
                    }
                    begin = lastEOL != null ? lastEOL.getEndOffset() : docuNode.getTotalOffset();
                    insertionPoint.isBeforeJsdocDocumentation = true;
                } else {
                    ArrayList listLeafNodes = Lists.newArrayList((Iterable)realScriptElementNode.getLeafNodes());
                    Iterator iterLeaves = listLeafNodes.iterator();
                    ILeafNode curr = null;
                    ILeafNode firstEOL = null;
                    ILeafNode afterFirstEOL = null;
                    boolean sawComment = false;
                    ILeafNode lastComment = null;
                    while (iterLeaves.hasNext() && (curr = (ILeafNode)iterLeaves.next()).isHidden()) {
                        if (!(curr.getGrammarElement() instanceof TerminalRule)) continue;
                        if (curr.getGrammarElement() == this.typeExpressionGrammmarAccess.getML_COMMENTRule()) {
                            firstEOL = null;
                            afterFirstEOL = null;
                            sawComment = true;
                            lastComment = curr;
                            continue;
                        }
                        if (curr.getGrammarElement() == this.typeExpressionGrammmarAccess.getSL_COMMENTRule()) {
                            firstEOL = null;
                            afterFirstEOL = null;
                            sawComment = true;
                            lastComment = curr;
                            continue;
                        }
                        if (curr.getGrammarElement() == this.typeExpressionGrammmarAccess.getEOLRule()) {
                            if (firstEOL == null) {
                                firstEOL = curr;
                                continue;
                            }
                            if (afterFirstEOL != null) continue;
                            afterFirstEOL = curr;
                            continue;
                        }
                        if (curr.getGrammarElement() == this.typeExpressionGrammmarAccess.getWSRule()) {
                            if (firstEOL == null || afterFirstEOL != null) continue;
                            afterFirstEOL = curr;
                            continue;
                        }
                        firstEOL = null;
                        afterFirstEOL = null;
                    }
                    if (curr == null || curr.isHidden()) {
                        throw new RuntimeException("Expected at least one non-hidden element.");
                    }
                    insertionPoint.notAfterTotalOffset = curr.getTotalOffset();
                    int begin2 = afterFirstEOL != null && sawComment ? afterFirstEOL.getTotalOffset() : (this.hasNoCommentUpTo(curr) ? 0 : (sawComment && lastComment != null ? lastComment.getEndOffset() : ((ILeafNode)listLeafNodes.get(0)).getTotalOffset()));
                    begin = Math.max(begin, begin2);
                    if (lastSeenDirective > -1) {
                        ICompositeNode lastDirectiveNode = NodeModelUtils.findActualNodeFor((EObject)((EObject)elements.get(lastSeenDirective)));
                        int lastDirectiveEndOffset = lastDirectiveNode.getTotalEndOffset();
                        insertionPoint.notBeforeTotalOffset = Math.max(lastDirectiveEndOffset, insertionPoint.notBeforeTotalOffset);
                        begin = Math.max(begin, lastDirectiveEndOffset);
                    }
                }
            } else if (lastSeenDirective > -1) {
                ICompositeNode lastDirectiveNode = NodeModelUtils.findActualNodeFor((EObject)((EObject)elements.get(lastSeenDirective)));
                begin = lastDirectiveNode.getTotalEndOffset();
                insertionPoint.notBeforeTotalOffset = Math.max(begin, insertionPoint.notBeforeTotalOffset);
            }
            insertionPoint.offset = begin;
        }
        return insertionPoint;
    }

    private boolean hasNoCommentUpTo(ILeafNode node) {
        if (node == null) {
            return true;
        }
        for (INode curr : node.getRootNode().getAsTreeIterable()) {
            if (curr == node) {
                return true;
            }
            if (!(curr instanceof LeafNode) || !((LeafNode)curr).isHidden() && !UtilN4.isIgnoredSyntaxErrorNode((INode)curr, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"}) || curr.getText().trim().isEmpty()) continue;
            return false;
        }
        throw new IllegalStateException("Iteration over-stepped the passed in node.");
    }

    private static class InsertionPoint {
        int offset = -1;
        boolean isBeforeJsdocDocumentation = false;
        int notBeforeTotalOffset = 0;
        int notAfterTotalOffset = Integer.MAX_VALUE;

        private InsertionPoint() {
        }
    }
}

