/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.common;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.xpect.ui.common.EngineOutput;

public class XpectOutputConfigRunner {
    @Inject
    private RunnerFrontEnd runnerFrontEnd;
    private static final String NL = "\n";

    public String executeWithConfig(RunConfiguration runConfig, boolean decorateStdStreams) {
        String executionResult;
        ArrayList<String> combinedOutput = new ArrayList<String>();
        try {
            Process process = this.runnerFrontEnd.run(runConfig, this.executor());
            EngineOutput eo = this.captureOutput(process);
            if (decorateStdStreams) {
                combinedOutput.add("<==");
                combinedOutput.add("stdout:");
            }
            combinedOutput.addAll(eo.getStdOut());
            if (decorateStdStreams) {
                combinedOutput.add("stderr:");
            }
            combinedOutput.addAll(eo.getErrOut());
            if (decorateStdStreams) {
                combinedOutput.add("==>");
            }
            executionResult = Joiner.on((String)NL).join(combinedOutput);
        }
        catch (Exception e) {
            executionResult = e.getMessage();
            System.out.println("Error in N4js execution " + e);
            e.printStackTrace();
        }
        return executionResult;
    }

    private EngineOutput captureOutput(Process process) throws IOException {
        ArrayList<String> err;
        ArrayList<String> out;
        block13: {
            out = new ArrayList<String>();
            err = new ArrayList<String>();
            BufferedReader bri = null;
            BufferedReader bre = null;
            try {
                try {
                    String errLine;
                    String outLine;
                    bri = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((outLine = bri.readLine()) != null) {
                        out.add(outLine);
                    }
                    bre = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((errLine = bre.readLine()) != null) {
                        err.add(errLine);
                        System.err.println(errLine);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception in Engine.captureOutput: " + e.getMessage());
                    if (bri != null) {
                        bri.close();
                    }
                    if (bre != null) {
                        bre.close();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (bri != null) {
                    bri.close();
                }
                if (bre != null) {
                    bre.close();
                }
                throw throwable;
            }
            if (bri != null) {
                bri.close();
            }
            if (bre != null) {
                bre.close();
            }
        }
        return new EngineOutput(out, err);
    }

    private IExecutor executor() {
        return new IExecutor(){

            public Process exec(String[] cmdLine, File workingDirectory, Map<String, String> envp) throws ExecutionException {
                ProcessBuilder pb = new ProcessBuilder(cmdLine);
                pb.environment().putAll(envp);
                pb.directory(workingDirectory);
                try {
                    return pb.start();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }
}

