/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building.instructions;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ui.building.instructions.AbstractBuildParticipantInstruction;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.ui.util.ResourceUtil;

public class CleanInstruction
extends AbstractBuildParticipantInstruction {
    public CleanInstruction(IProject project, Map<String, OutputConfiguration> outputConfigurations, IDerivedResourceMarkers derivedResourceMarkers) {
        super(project, outputConfigurations, derivedResourceMarkers);
        this.project = project;
        this.outputConfigurations = outputConfigurations;
        this.derivedResourceMarkers = derivedResourceMarkers;
    }

    @Override
    public void finish(List<IResourceDescription.Delta> deltas, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor cleanMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.outputConfigurations.size());
        for (OutputConfiguration config : this.outputConfigurations.values()) {
            this.cleanOutput(this.project, config, (IProgressMonitor)cleanMonitor.newChild(1));
        }
    }

    private void cleanOutput(IProject aProject, OutputConfiguration config, IProgressMonitor monitor) throws CoreException {
        block4: {
            IContainer container;
            block3: {
                container = ResourceUtil.getContainer((IProject)aProject, (String)config.getOutputDirectory());
                if (!container.exists()) {
                    return;
                }
                if (!config.isCanClearOutputDirectory()) break block3;
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    resource.delete(2, monitor);
                    ++n2;
                }
                break block4;
            }
            if (!config.isCleanUpDerivedResources()) break block4;
            List resources = this.derivedResourceMarkers.findDerivedResources(container, null);
            for (IFile iFile : resources) {
                iFile.delete(2, monitor);
            }
        }
    }

    @Override
    public void process(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor progressMonitor) throws CoreException {
    }
}

