/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ide.imports.ImportHelper;
import org.eclipse.n4js.ide.imports.ReferenceDescriptor;
import org.eclipse.n4js.ide.imports.ReferenceResolution;
import org.eclipse.n4js.ide.imports.ReferenceResolutionFinder;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.ReplaceRegion;

public class ImportsAwareReferenceProposalCreator {
    @Inject
    private ImportHelper importHelper;
    @Inject
    private ReferenceResolutionFinder referenceResolutionFinder;
    @Inject
    private IProposalConflictHelper conflictHelper;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    public void lookupCrossReference(EObject model, EReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        if (model == null) {
            return;
        }
        Resource resource = model.eResource();
        if (!(resource instanceof N4JSResource)) {
            return;
        }
        N4JSResource resourceCasted = (N4JSResource)resource;
        ReferenceDescriptor referenceDesc = new ReferenceDescriptor(context.getPrefix(), model, reference, context.getCurrentNode());
        Predicate conflictChecker = proposalToCheck -> this.conflictHelper.existsConflict(proposalToCheck, context);
        this.referenceResolutionFinder.findResolutions(referenceDesc, false, false, (Predicate<String>)conflictChecker, filter, new ResolutionToContentProposalAcceptor(resourceCasted, context, acceptor));
    }

    private ContentAssistEntry convertResolutionToContentAssistEntry(ReferenceResolution resolution, N4JSResource resource, ContentAssistContext context) {
        ContentAssistEntry cae = new ContentAssistEntry();
        cae.setPrefix(context.getPrefix());
        cae.setProposal(resolution.proposal);
        cae.setLabel(resolution.label);
        cae.setDescription(resolution.description);
        if (resolution.importToBeAdded != null) {
            ReplaceRegion textReplacement = this.importHelper.getReplacementForImport(resource.getScript(), resolution.importToBeAdded);
            cae.getTextReplacements().add(textReplacement);
        }
        cae.setSource((Object)resolution.referencedElement);
        cae.setKind(ImportsAwareReferenceProposalCreator.getKind(resolution));
        return cae;
    }

    private static String getKind(ReferenceResolution resolution) {
        EClass eClass = resolution.referencedElement.getEClass();
        if (TypesPackage.eINSTANCE.getTClass() == eClass) {
            return "CLASS";
        }
        if (TypesPackage.eINSTANCE.getTInterface() == eClass) {
            return "INTERFACE";
        }
        if (TypesPackage.eINSTANCE.getTField() == eClass) {
            return "FIELD";
        }
        if (TypesPackage.eINSTANCE.getTEnum() == eClass) {
            return "ENUM";
        }
        if (TypesPackage.eINSTANCE.getTFunction() == eClass) {
            return "FUNCTION";
        }
        if (TypesPackage.eINSTANCE.getTVariable() == eClass) {
            return "VARIABLE";
        }
        if (N4JSPackage.eINSTANCE.getVariableDeclaration() == eClass) {
            return "VARIABLE";
        }
        if (TypesPackage.eINSTANCE.getModuleNamespaceVirtualType() == eClass) {
            return "COLOR";
        }
        return "TEXT";
    }

    private class ResolutionToContentProposalAcceptor
    implements ReferenceResolutionFinder.IResolutionAcceptor {
        private final N4JSResource resource;
        private final ContentAssistContext context;
        private final IIdeContentProposalAcceptor contentProposalAcceptor;

        ResolutionToContentProposalAcceptor(N4JSResource resource, ContentAssistContext context, IIdeContentProposalAcceptor contentProposalAcceptor) {
            this.resource = resource;
            this.context = context;
            this.contentProposalAcceptor = contentProposalAcceptor;
        }

        @Override
        public void accept(ReferenceResolution resolution) {
            ContentAssistEntry entry = ImportsAwareReferenceProposalCreator.this.convertResolutionToContentAssistEntry(resolution, this.resource, this.context);
            int priority = ImportsAwareReferenceProposalCreator.this.proposalPriorities.getCrossRefPriority(resolution.referencedElement, entry);
            this.contentProposalAcceptor.accept(entry, priority);
        }

        @Override
        public boolean canAcceptMoreProposals() {
            return this.contentProposalAcceptor.canAcceptMoreProposals();
        }
    }
}

