/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.helper;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.nio.file.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;

public class FolderContainmentHelper {
    @Inject
    private IN4JSCore n4jsCore;

    public boolean isContainedInOutputFolder(URI uri) {
        SafeURI<?> absoluteOutputLocation;
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        return project != null && (absoluteOutputLocation = FolderContainmentHelper.getOutputURI(project)) != null && this.isContained(this.n4jsCore.toProjectLocation(uri), absoluteOutputLocation);
    }

    public boolean isContainedInSourceContainer(SafeURI<?> location) {
        Optional<? extends IN4JSSourceContainer> container = this.n4jsCore.findN4JSSourceContainer(location.toURI());
        return container.isPresent();
    }

    public boolean isOutputContainedInSourceContainer(IN4JSProject project) {
        SafeURI<?> absoluteOutputLocation = FolderContainmentHelper.getOutputURI(project);
        if (absoluteOutputLocation != null) {
            return this.isContainedInSourceContainer(absoluteOutputLocation);
        }
        return false;
    }

    public boolean isContained(SafeURI<?> uri, SafeURI<?> container) {
        Path path = uri.toFileSystemPath();
        Path containerPath = container.toFileSystemPath();
        return path.startsWith(containerPath);
    }

    private static SafeURI<?> getOutputURI(IN4JSProject project) {
        String outputPathName = project.getOutputPath();
        if (outputPathName != null) {
            return project.getLocation().resolve(outputPathName);
        }
        return null;
    }
}

