/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import java.util.function.Consumer;

final class ProcessTerminationListener
extends Thread {
    private final Process process;
    private final Consumer<Integer> listener;

    public static void register(Process p, Consumer<Integer> listener) {
        if (p.isAlive()) {
            new ProcessTerminationListener(p, listener).start();
        } else {
            listener.accept(p.exitValue());
        }
    }

    private ProcessTerminationListener(Process process, Consumer<Integer> listener) {
        this.listener = listener;
        this.process = process;
    }

    @Override
    public void run() {
        int exitCode = -1;
        try {
            exitCode = this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.listener.accept(exitCode);
    }
}

