/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.util;

import java.io.IOException;
import java.net.URI;
import org.eclipse.userstorage.internal.util.StringUtil;

public class ProtocolException
extends IOException {
    private static final long serialVersionUID = 1L;
    private String method;
    private URI uri;
    private String protocolVersion;
    private int statusCode;
    private String reasonPhrase;

    public ProtocolException() {
    }

    public ProtocolException(String method, URI uri, String protocolVersion, int statusCode, String reasonPhrase) {
        super(String.valueOf(method) + " " + uri + " " + protocolVersion + " " + statusCode + (StringUtil.isEmpty(reasonPhrase) ? "" : " " + reasonPhrase));
        this.method = method;
        this.uri = uri;
        this.protocolVersion = protocolVersion;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public final String getMethod() {
        return this.method;
    }

    public final URI getURI() {
        return this.uri;
    }

    public final String getProtocolVersion() {
        return this.protocolVersion;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }
}

