/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.assistants;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedTypeRef_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.ConcreteMembersOrderedForTranspiler;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeAssistant
extends TransformationAssistant {
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void assertClassifierPreConditions() {
    }

    public SymbolTableEntryOriginal getSuperClassSTE(N4ClassDeclaration classDecl) {
        SymbolTableEntry superClassSTE;
        ParameterizedTypeRef superClassRef = classDecl.getSuperClassRef();
        if (superClassRef instanceof ParameterizedTypeRef_IM && (superClassSTE = ((ParameterizedTypeRef_IM)superClassRef).getDeclaredType_IM()) instanceof SymbolTableEntryOriginal) {
            return (SymbolTableEntryOriginal)superClassSTE;
        }
        return this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.n4ObjectType((RuleEnvironment)this.getState().G), true);
    }

    public List<SymbolTableEntryOriginal> getSuperInterfacesSTEs(N4ClassifierDeclaration classifierDecl) {
        EList _switchResult = null;
        boolean _matched = false;
        if (classifierDecl instanceof N4ClassDeclaration) {
            _matched = true;
            _switchResult = ((N4ClassDeclaration)classifierDecl).getImplementedInterfaceRefs();
        }
        if (!_matched && classifierDecl instanceof N4InterfaceDeclaration) {
            _matched = true;
            _switchResult = ((N4InterfaceDeclaration)classifierDecl).getSuperInterfaceRefs();
        }
        if (!_matched) {
            String _name = null;
            if (classifierDecl != null) {
                _name = classifierDecl.getName();
            }
            String _plus = "unsupported subclass of N4ClassifierDeclaration: " + _name;
            throw new IllegalStateException(_plus);
        }
        EList superIfcRefs = _switchResult;
        Functions.Function1 _function = superIfcRef -> {
            SymbolTableEntry _xifexpression = null;
            if (superIfcRef instanceof ParameterizedTypeRef_IM) {
                _xifexpression = ((ParameterizedTypeRef_IM)superIfcRef).getDeclaredType_IM();
            }
            return _xifexpression;
        };
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)superIfcRefs, (Functions.Function1)_function), SymbolTableEntryOriginal.class));
    }

    public boolean isTopLevel(TypeDefiningElement typeDef) {
        EObject parent = typeDef.eContainer();
        while (parent instanceof ExportDeclaration || parent instanceof AnnotationList) {
            parent = parent.eContainer();
        }
        return parent instanceof Script;
    }

    public boolean inN4JSD(Type type) {
        return this.jsVariantHelper.isExternalMode((EObject)type);
    }

    public ParameterizedPropertyAccessExpression_IM getMemberNameAsSymbol(String memberName) {
        boolean _not;
        boolean _startsWith = memberName.startsWith("#");
        boolean bl = _not = !_startsWith;
        if (_not) {
            throw new IllegalArgumentException("given member name does not denote a symbol");
        }
        return TranspilerBuilderBlocks._PropertyAccessExpr(this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.symbolObjectType((RuleEnvironment)this.getState().G), true), this.getSymbolTableEntryInternal(memberName.substring(1), true));
    }

    public ConcreteMembersOrderedForTranspiler getOrCreateCMOFT(TClassifier classifier) {
        ConcreteMembersOrderedForTranspiler cachedCMOFT = this.getState().info.getCachedCMOFT(classifier);
        if (cachedCMOFT != null) {
            return cachedCMOFT;
        }
        ConcreteMembersOrderedForTranspiler newCMOFT = ConcreteMembersOrderedForTranspiler.create(this.containerTypesHelper, classifier, this.getState().resource.getScript());
        this.getState().info.cacheCMOFT(classifier, newCMOFT);
        return newCMOFT;
    }
}

