/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.WildcardPathFilterHelper;

public class NodeModulesDiscoveryHelper {
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;

    public NodeModulesFolder getNodeModulesFolder(Path projectLocation) {
        HashMap<Path, ProjectDescription> pdCache = new HashMap<Path, ProjectDescription>();
        return this.getNodeModulesFolder(projectLocation, pdCache);
    }

    public NodeModulesFolder getNodeModulesFolder(Path projectLocation, Map<Path, ProjectDescription> pdCache) {
        File projectLocationAsFile = projectLocation.toFile();
        if (this.isYarnWorkspaceRoot(projectLocationAsFile, (Optional<File>)Optional.absent(), pdCache)) {
            File workspaceNMF = new File(projectLocationAsFile, "node_modules");
            return new NodeModulesFolder(null, workspaceNMF);
        }
        Optional<File> workspaceRoot = this.getYarnWorkspaceRoot(projectLocationAsFile, pdCache);
        if (workspaceRoot.isPresent()) {
            File workspaceNMF = new File((File)workspaceRoot.get(), "node_modules");
            File localNMF = new File(projectLocationAsFile, "node_modules");
            localNMF = localNMF.exists() ? localNMF : null;
            return new NodeModulesFolder(localNMF, workspaceNMF);
        }
        Path packgeJsonPath = projectLocation.resolve("package.json");
        if (packgeJsonPath.toFile().isFile()) {
            Path nodeModulesPath = projectLocation.resolve("node_modules");
            return new NodeModulesFolder(nodeModulesPath.toFile(), null);
        }
        return null;
    }

    public List<Path> findNodeModulesFolders(Collection<Path> n4jsProjects) {
        HashMap<Path, ProjectDescription> pdCache = new HashMap<Path, ProjectDescription>();
        return this.findNodeModulesFolders(n4jsProjects, pdCache);
    }

    public List<Path> findNodeModulesFolders(Collection<Path> n4jsProjects, Map<Path, ProjectDescription> pdCache) {
        ArrayList<Path> result = new ArrayList<Path>();
        LinkedHashSet<File> matchingWorkspaceRoots = new LinkedHashSet<File>();
        for (Path projectFolderPath : n4jsProjects) {
            File projectFolder = (projectFolderPath = projectFolderPath.toAbsolutePath()).toFile();
            if (!projectFolder.isDirectory()) continue;
            Path nodeModulesPath = projectFolderPath.resolve("node_modules");
            result.add(nodeModulesPath);
            Optional<File> workspaceRoot = this.getYarnWorkspaceRoot(projectFolder, pdCache);
            if (!workspaceRoot.isPresent()) continue;
            matchingWorkspaceRoots.add((File)workspaceRoot.get());
        }
        for (File workspaceRoot : matchingWorkspaceRoots) {
            Path globalNodeModulesFolderPath = workspaceRoot.toPath().resolve("node_modules");
            result.add(globalNodeModulesFolderPath);
        }
        return result;
    }

    private Optional<File> getYarnWorkspaceRoot(File n4jsProjectFolder, Map<Path, ProjectDescription> pdCache) {
        File candidate = n4jsProjectFolder.getParentFile();
        while (candidate != null) {
            if (this.isYarnWorkspaceRoot(candidate, (Optional<File>)Optional.of((Object)n4jsProjectFolder), pdCache)) {
                return Optional.of((Object)candidate);
            }
            candidate = candidate.getParentFile();
        }
        return Optional.absent();
    }

    public boolean isYarnWorkspaceRoot(File folder) {
        return this.isYarnWorkspaceRoot(folder, new HashMap<Path, ProjectDescription>());
    }

    public boolean isYarnWorkspaceRoot(File folder, Map<Path, ProjectDescription> pdCache) {
        return this.isYarnWorkspaceRoot(folder, (Optional<File>)Optional.absent(), pdCache);
    }

    public boolean isYarnWorkspaceRoot(File folder, Optional<File> projectFolder, Map<Path, ProjectDescription> pdCache) {
        EList workspaces;
        if (!folder.isDirectory()) {
            return false;
        }
        ProjectDescription prjDescr = pdCache.computeIfAbsent(folder.toPath(), p -> {
            ProjectDescription pd = this.projectDescriptionLoader.loadProjectDescriptionAtLocation(new FileURI(folder));
            return pd;
        });
        EList eList = workspaces = prjDescr != null && prjDescr.isYarnWorkspaceRoot() ? prjDescr.getWorkspaces() : null;
        if (workspaces == null) {
            return false;
        }
        if (projectFolder.isPresent()) {
            for (String relativePath : workspaces) {
                if (!this.isPointingTo(folder, relativePath, (File)projectFolder.get())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isPointingTo(File base, String relativePath, File target) {
        String pattern = String.valueOf(base.getAbsolutePath()) + File.separator + relativePath;
        PathMatcher matcher = WildcardPathFilterHelper.createPathMatcher(pattern);
        return matcher.matches(target.toPath());
    }

    public static class NodeModulesFolder {
        public final File localNodeModulesFolder;
        public final File workspaceNodeModulesFolder;

        public NodeModulesFolder(File localNodeModulesFolder, File workspaceNodeModulesFolder) {
            this.localNodeModulesFolder = localNodeModulesFolder;
            this.workspaceNodeModulesFolder = workspaceNodeModulesFolder;
        }

        public List<File> getNodeModulesFolders() {
            ArrayList nmfList = Lists.newArrayList((Object[])new File[]{this.workspaceNodeModulesFolder, this.localNodeModulesFolder});
            nmfList.removeAll(Collections.singleton(null));
            return Collections.unmodifiableList(nmfList);
        }

        public boolean isYarnWorkspace() {
            return this.workspaceNodeModulesFolder != null;
        }
    }
}

