/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataPoint;
import org.eclipse.n4js.smith.Measurement;

class SerializingDataCollector
extends DataCollector {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final DataCollector delegate;

    SerializingDataCollector(DataCollector delegate) {
        this.delegate = delegate;
    }

    private Measurement getMeasurement(Supplier<Measurement> supplier) {
        if (!this.isPaused()) {
            return new LockedMeasurement(supplier);
        }
        return (Measurement)supplier.get();
    }

    @Override
    public Measurement getMeasurement() {
        return this.getMeasurement((Supplier<Measurement>)((Supplier)() -> this.delegate.getMeasurement()));
    }

    @Override
    public Measurement getMeasurementIfInactive() {
        return this.getMeasurement((Supplier<Measurement>)((Supplier)() -> this.delegate.getMeasurementIfInactive()));
    }

    @Override
    public Measurement getMeasurementIfInactive(String name) {
        return this.getMeasurement((Supplier<Measurement>)((Supplier)() -> this.delegate.getMeasurementIfInactive(name)));
    }

    @Override
    public Measurement getMeasurement(String name) {
        return this.getMeasurement((Supplier<Measurement>)((Supplier)() -> this.delegate.getMeasurement(name)));
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public Collection<DataCollector> getChildren() {
        return this.delegate.getChildren();
    }

    @Override
    public boolean isPaused() {
        return this.delegate.isPaused();
    }

    @Override
    public boolean hasActiveMeasurement() {
        return this.delegate.hasActiveMeasurement();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public List<DataPoint> getData() {
        return this.delegate.getData();
    }

    @Override
    public void setPaused(boolean paused) {
        this.delegate.setPaused(paused);
    }

    @Override
    public void purgeData() {
        this.delegate.purgeData();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void resetData() {
        this.delegate.resetData();
    }

    @Override
    DataCollector getChild(String id) {
        return this.delegate.getChild(id);
    }

    @Override
    void addChild(DataCollector child) {
        this.delegate.addChild(child);
    }

    @Override
    Collection<String> childrenKeys() {
        return this.delegate.childrenKeys();
    }

    class LockedMeasurement
    implements Measurement {
        private final Measurement m;

        LockedMeasurement(Supplier<Measurement> supplier) {
            SerializingDataCollector.this.lock.lock();
            this.m = (Measurement)supplier.get();
        }

        @Override
        public void close() {
            try {
                this.m.close();
            }
            finally {
                SerializingDataCollector.this.lock.unlock();
            }
        }
    }
}

