/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

class ComputeProjectOrder {
    private ComputeProjectOrder() {
    }

    static <T> VertexOrder<T> computeVertexOrder(SortedSet<? extends T> vertexes, List<? extends T[]> references) {
        Object[][] knots;
        Digraph g1 = new Digraph();
        Iterator<Object> it = vertexes.iterator();
        while (it.hasNext()) {
            g1.addVertex(it.next());
        }
        for (Object[] objectArray : references) {
            Object p = objectArray[0];
            Object object = objectArray[1];
            g1.addEdge(object, p);
        }
        g1.freeze();
        Digraph g2 = new Digraph();
        List<Object> list = g1.idsByDFSFinishTime(false);
        Iterator<Object> it2 = list.iterator();
        while (it2.hasNext()) {
            g2.addVertex(it2.next());
        }
        for (T[] TArray : references) {
            T p = TArray[0];
            T q = TArray[1];
            g2.addEdge(p, q);
        }
        g2.freeze();
        List<Object> sortedVertexList = g2.idsByDFSFinishTime(true);
        Object[] objectArray = new Object[sortedVertexList.size()];
        sortedVertexList.toArray(objectArray);
        boolean hasCycles = g2.containsCycles();
        if (hasCycles) {
            List<Object[]> knotList = g2.nonTrivialComponents();
            knots = new Object[knotList.size()][];
            knotList.toArray((T[])knots);
        } else {
            knots = new Object[][]{};
        }
        return new VertexOrder<Object>(objectArray, hasCycles, knots);
    }

    static <U> VertexOrder<U> castVertexOrder(VertexOrder<Object> order, Class<U> clazz) {
        VertexCaster<U> caster = new VertexCaster<U>(clazz);
        return ComputeProjectOrder.mapVertexOrder(order, caster);
    }

    static <T, U> VertexOrder<U> mapVertexOrder(VertexOrder<T> order, VertexMapper<T, U> mapper) {
        Object[] mappedVertexes = (Object[])Array.newInstance(mapper.getTargetClass(), order.vertexes.length);
        int i = 0;
        while (i < order.vertexes.length) {
            mappedVertexes[i] = mapper.get(order.vertexes[i]);
            ++i;
        }
        Object[][] mappedKnots = (Object[][])Array.newInstance(mapper.getTargetClass(), order.knots.length, 0);
        int i2 = 0;
        while (i2 < order.knots.length) {
            T[] knot = order.knots[i2];
            Object[] knotList = (Object[])Array.newInstance(mapper.getTargetClass(), knot.length);
            int j = 0;
            while (j < knot.length) {
                U vertex = mapper.get(knot[j]);
                knotList[j] = vertex;
                ++j;
            }
            mappedKnots[i2] = knotList;
            ++i2;
        }
        return new VertexOrder<Object>(mappedVertexes, order.hasCycles, mappedKnots);
    }

    static <T> VertexOrder<T> filterVertexOrder(VertexOrder<T> order, VertexFilter<T> filter) {
        int filteredCount = 0;
        boolean[] filterMatches = new boolean[order.vertexes.length];
        int i = 0;
        while (i < order.vertexes.length) {
            filterMatches[i] = filter.matches(order.vertexes[i]);
            if (filterMatches[i]) {
                ++filteredCount;
            }
            ++i;
        }
        if (filteredCount == 0) {
            return order;
        }
        Object[] reducedVertexes = new Object[order.vertexes.length - filteredCount];
        int i2 = 0;
        int j = 0;
        while (i2 < order.vertexes.length) {
            if (!filterMatches[i2]) {
                reducedVertexes[j] = order.vertexes[i2];
                ++j;
            }
            ++i2;
        }
        ArrayList<Object[]> reducedKnots = new ArrayList<Object[]>(order.knots.length);
        int i3 = 0;
        while (i3 < order.knots.length) {
            T[] knot = order.knots[i3];
            ArrayList knotList = new ArrayList(knot.length);
            int j2 = 0;
            while (j2 < knot.length) {
                Object vertex = knot[j2];
                if (!filter.matches(vertex)) {
                    knotList.add(vertex);
                }
                ++j2;
            }
            if (knotList.size() > 1) {
                reducedKnots.add(knotList.toArray());
            }
            ++i3;
        }
        return new VertexOrder<Object>(reducedVertexes, reducedKnots.size() > 0, (Object[][])reducedKnots.toArray((T[])new Object[reducedKnots.size()][]));
    }

    private static class Digraph {
        private final List<Vertex> vertexList = new ArrayList<Vertex>(100);
        private final Map<Object, Vertex> vertexMap = new HashMap<Object, Vertex>(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(Object id) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = new Vertex(id);
            Vertex existing = this.vertexMap.put(id, vertex);
            if (existing != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(Object fromId, Object toId) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex fromVertex = this.vertexMap.get(fromId);
            Vertex toVertex = this.vertexMap.get(toId);
            if (fromVertex == null) {
                throw new IllegalArgumentException();
            }
            if (toVertex == null) {
                throw new IllegalArgumentException();
            }
            fromVertex.adjacent.add(toVertex);
        }

        public List<Object> idsByDFSFinishTime(boolean increasing) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int len = this.vertexList.size();
            Object[] r = new Object[len];
            for (Vertex vertex : this.vertexList) {
                int f = vertex.finishTime;
                if (increasing) {
                    r[f - 1] = vertex.id;
                    continue;
                }
                r[len - f] = vertex.id;
            }
            return Arrays.asList(r);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List<Object[]> nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap<Vertex, ArrayList<Object>> components = new HashMap<Vertex, ArrayList<Object>>();
            for (Vertex vertex : this.vertexList) {
                if (vertex.predecessor == null) continue;
                Vertex root = vertex;
                while (root.predecessor != null) {
                    root = root.predecessor;
                }
                ArrayList<Object> component = (ArrayList<Object>)components.get(root);
                if (component == null) {
                    component = new ArrayList<Object>(2);
                    component.add(root.id);
                    components.put(root, component);
                }
                component.add(vertex.id);
            }
            ArrayList<Object[]> result = new ArrayList<Object[]>(components.size());
            for (List component : components.values()) {
                if (component.size() <= 1) continue;
                result.add(component.toArray());
            }
            return result;
        }

        private void DFS() {
            boolean NEXT_VERTEX = true;
            int START_DFS_VISIT = 2;
            int NEXT_ADJACENT = 3;
            int AFTER_NEXTED_DFS_VISIT = 4;
            Integer NEXT_VERTEX_OBJECT = 1;
            Integer AFTER_NEXTED_DFS_VISIT_OBJECT = 4;
            this.time = 0;
            ArrayList<Object> stack = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator allAdjacent = null;
            Vertex vertex = null;
            Iterator<Vertex> allV = this.vertexList.iterator();
            int state = 1;
            block6: while (true) {
                switch (state) {
                    case 1: {
                        if (!allV.hasNext()) break block6;
                        Vertex nextVertex = allV.next();
                        if (nextVertex.color == "white") {
                            stack.add(NEXT_VERTEX_OBJECT);
                            vertex = nextVertex;
                            state = 2;
                            continue block6;
                        }
                        state = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        allAdjacent = vertex.adjacent.iterator();
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        if (allAdjacent.hasNext()) {
                            Vertex adjVertex = (Vertex)allAdjacent.next();
                            if (adjVertex.color == "white") {
                                adjVertex.predecessor = vertex;
                                stack.add(allAdjacent);
                                stack.add(vertex);
                                stack.add(AFTER_NEXTED_DFS_VISIT_OBJECT);
                                vertex = adjVertex;
                                state = 2;
                                continue block6;
                            }
                            if (adjVertex.color == "grey") {
                                this.cycles = true;
                            }
                            state = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        state = (Integer)stack.remove(stack.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)stack.remove(stack.size() - 1);
                        allAdjacent = (Iterator)stack.remove(stack.size() - 1);
                        state = 3;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public static class Vertex {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex predecessor = null;
            public int finishTime;
            public Object id;
            public List<Vertex> adjacent = new ArrayList<Vertex>(3);

            public Vertex(Object id) {
                this.id = id;
            }
        }
    }

    static class VertexCaster<B>
    implements VertexMapper<Object, B> {
        private final Class<B> clazz;

        VertexCaster(Class<B> clazz) {
            this.clazz = clazz;
        }

        @Override
        public B get(Object object) {
            return (B)object;
        }

        @Override
        public Class<B> getTargetClass() {
            return this.clazz;
        }
    }

    static interface VertexFilter<T> {
        public boolean matches(T var1);
    }

    static interface VertexMapper<A, B> {
        public B get(A var1);

        public Class<B> getTargetClass();
    }

    static final class VertexOrder<T> {
        public T[] vertexes;
        public boolean hasCycles;
        public T[][] knots;

        public VertexOrder(T[] vertexes, boolean hasCycles, T[][] knots) {
            this.vertexes = vertexes;
            this.hasCycles = hasCycles;
            this.knots = knots;
        }
    }
}

