/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.ISingleLineExpectationRegion;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.expectation.StringDiffExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.expectation.impl.ExpectationRegionProvider;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.CharSequences;
import org.eclipse.xpect.text.ITextDifferencer;
import org.eclipse.xpect.text.StringEndsSimilarityFunction;
import org.eclipse.xpect.text.TextDiffToString;
import org.eclipse.xpect.text.TextDifferencer;
import org.eclipse.xpect.util.IDifferencer;
import org.eclipse.xtext.util.internal.FormattingMigrator;
import org.junit.ComparisonFailure;

@XpectSetupFactory
@XpectImport(value={ExpectationRegionProvider.class})
public class StringDiffExpectationImpl
extends AbstractExpectation
implements IStringDiffExpectation {
    private final StringDiffExpectation annotation;

    public StringDiffExpectationImpl(XpectArgument argument, TargetSyntaxSupport targetSyntax) {
        super(argument, targetSyntax);
        this.annotation = argument.getAnnotationOrDefault(StringDiffExpectation.class);
    }

    @Override
    public <T extends IStringDiffExpectation.IToken<? super T>> void assertDiffEquals(Iterable<T> leftTokens, Iterable<T> rightTokens) {
        ImmutableList left = ImmutableList.copyOf(leftTokens);
        ImmutableList right = ImmutableList.copyOf(rightTokens);
        ITextDifferencer.ITextDiffConfig<T> config = this.createDiffConfig((List<T>)left, (List<T>)right);
        this.assertDiffEquals((List<T>)left, (List<T>)right, config);
    }

    @Override
    public <T> void assertDiffEquals(Iterable<T> leftTokens, Iterable<T> rightTokens, IStringDiffExpectation.ITokenAdapter<T> adapter) {
        Preconditions.checkNotNull(adapter);
        ImmutableList left = ImmutableList.copyOf(leftTokens);
        ImmutableList right = ImmutableList.copyOf(rightTokens);
        ITextDifferencer.ITextDiffConfig<T> config = this.createDiffConfig((List<T>)left, (List<T>)right, adapter);
        this.assertDiffEquals((List<T>)left, (List<T>)right, config);
    }

    protected <T> void assertDiffEquals(List<T> left, List<T> right, ITextDifferencer.ITextDiffConfig<T> config) throws ComparisonFailure {
        String migratedExpectation;
        ITextDifferencer differencer = this.createDifferencer();
        ITextDifferencer.ITextDiff diff = differencer.diff(left, right, config);
        String actual = (String)this.createDiffToString().apply((Object)diff);
        String escapedActual = this.getTargetSyntaxLiteral().escape(actual);
        String originalExpectation = this.getExpectation();
        if (!this.annotation.whitespaceSensitive()) {
            FormattingMigrator migrator = new FormattingMigrator();
            migratedExpectation = migrator.migrate(escapedActual, originalExpectation);
        } else {
            migratedExpectation = originalExpectation;
        }
        if (!migratedExpectation.equals(escapedActual)) {
            String expDoc = this.replaceInDocument(migratedExpectation);
            String actDoc = this.replaceInDocument(escapedActual);
            throw new ComparisonFailure("", expDoc, actDoc);
        }
    }

    @Override
    public void assertDiffEquals(String left, String right) {
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        Function<String, ? extends Iterable<String>> tokenizer = this.createTokenizer();
        ImmutableList leftTokens = ImmutableList.copyOf((Iterable)((Iterable)tokenizer.apply((Object)left)));
        ImmutableList rightTokens = ImmutableList.copyOf((Iterable)((Iterable)tokenizer.apply((Object)right)));
        ITextDifferencer.ITextDiffConfig<String> config = this.createDiffConfig();
        this.assertDiffEquals((List)leftTokens, (List)rightTokens, config);
    }

    protected ITextDifferencer.ITextDiffConfig<String> createDiffConfig() {
        return new StringTextDiffConfig(new StringEndsSimilarityFunction(), this.annotation.whitespaceSensitive());
    }

    protected <T extends IStringDiffExpectation.IToken<? super T>> ITextDifferencer.ITextDiffConfig<T> createDiffConfig(List<T> left, List<T> right) {
        return new TokenTextDiffConfig<T>(left, right);
    }

    protected <T> ITextDifferencer.ITextDiffConfig<T> createDiffConfig(List<T> left, List<T> right, IStringDiffExpectation.ITokenAdapter<T> adapter) {
        return new GenericTextDiffConfig<T>(left, right, adapter);
    }

    protected ITextDifferencer createDifferencer() {
        return new TextDifferencer();
    }

    protected Function<? super ITextDifferencer.ITextDiff, String> createDiffToString() {
        TextDiffToString toString = new TextDiffToString();
        toString.setAllowSingleLineDiff(this.annotation.allowSingleLineDiff());
        toString.setAllowSingleSegmentDiff(this.annotation.allowSingleSegmentDiff() && this.getRegion() instanceof ISingleLineExpectationRegion);
        toString.setLinesBeforeDiff(this.annotation.linesBeforeDiff());
        toString.setLinesAfterDiff(this.annotation.linesAfterDiff());
        return toString;
    }

    protected Function<String, ? extends Iterable<String>> createTokenizer() {
        try {
            return this.annotation.tokenizer().newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error instantiating " + this.annotation.tokenizer(), e);
        }
    }

    public StringDiffExpectation getAnnotation() {
        return this.annotation;
    }

    @Creates
    public IStringDiffExpectation create() {
        return this;
    }

    public static class GenericTextDiffConfig<T>
    implements ITextDifferencer.ITextDiffConfig<T> {
        private final IStringDiffExpectation.ITokenAdapter<T> delegate;
        private final List<T> left;
        private final List<T> right;

        public GenericTextDiffConfig(List<T> left, List<T> right, IStringDiffExpectation.ITokenAdapter<T> delegate) {
            this.delegate = delegate;
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isHidden(T token, String segment) {
            return this.delegate.isHidden(token, segment);
        }

        @Override
        public float similarity(ITextDifferencer.ISegment object1, ITextDifferencer.ISegment object2) {
            T token1 = this.left.get(object1.getTokenIndex());
            T token2 = this.right.get(object2.getTokenIndex());
            return this.delegate.similarity(token1, object1.toString(), token2, object2.toString());
        }

        @Override
        public Iterable<String> toSegments(T token) {
            return this.delegate.splitIntoSegments(token);
        }
    }

    public static class StringTextDiffConfig
    implements ITextDifferencer.ITextDiffConfig<String> {
        private final IDifferencer.ISimilarityFunction<String> similarityFunction;
        private final boolean whitespaceSensitive;

        public StringTextDiffConfig(IDifferencer.ISimilarityFunction<String> similarityFunction, boolean whitespaceSensitive) {
            this.similarityFunction = similarityFunction;
            this.whitespaceSensitive = whitespaceSensitive;
        }

        @Override
        public boolean isHidden(String token, String segment) {
            if (this.whitespaceSensitive) {
                return false;
            }
            return CharSequences.isWhitespace(segment);
        }

        @Override
        public float similarity(ITextDifferencer.ISegment object1, ITextDifferencer.ISegment object2) {
            return this.similarityFunction.similarity(object1.toString(), object2.toString());
        }

        @Override
        public Iterable<String> toSegments(String token) {
            return Collections.singleton(token);
        }
    }

    public static class TokenTextDiffConfig<T extends IStringDiffExpectation.IToken<? super T>>
    implements ITextDifferencer.ITextDiffConfig<T> {
        private final List<T> left;
        private final List<T> right;

        public TokenTextDiffConfig(List<T> left, List<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isHidden(T token, String segment) {
            return token.isHidden(segment);
        }

        @Override
        public float similarity(ITextDifferencer.ISegment object1, ITextDifferencer.ISegment object2) {
            IStringDiffExpectation.IToken l = (IStringDiffExpectation.IToken)this.left.get(object1.getTokenIndex());
            IStringDiffExpectation.IToken r = (IStringDiffExpectation.IToken)this.right.get(object2.getTokenIndex());
            return l.similarity(object1.toString(), r, object2.toString());
        }

        @Override
        public Iterable<String> toSegments(T token) {
            return token.splitIntoSegments();
        }
    }
}

