/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4FieldAccessor;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.transpiler.TranspilerComponent;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.xbase.lib.Pair;

public class ReflectionBuilder {
    final TranspilerComponent transpilerComponent;
    final TranspilerState state;
    final ResourceNameComputer resourceNameComputer;

    ReflectionBuilder(TranspilerComponent transpilerComponent, TranspilerState state, ResourceNameComputer resourceNameComputer) {
        this.transpilerComponent = transpilerComponent;
        this.state = state;
        this.resourceNameComputer = resourceNameComputer;
    }

    JsonElement createReflectionInfo(N4TypeDeclaration typeDecl, SymbolTableEntry typeSTE) {
        Type type = this.state.info.getOriginalDefinedType(typeDecl);
        EList allMembers = typeDecl instanceof N4ClassifierDeclaration ? ((N4ClassifierDeclaration)typeDecl).getOwnedMembers() : Collections.emptyList();
        String origin = this.resourceNameComputer.generateProjectDescriptor(this.state.resource.getURI());
        String fqn = this.resourceNameComputer.getFullyQualifiedTypeName(type);
        String modulePath = fqn.substring(0, fqn.length() - typeSTE.getName().length() - 1);
        List<JsonElement> members = this.createAllMembers(typeDecl, (Iterable<N4MemberDeclaration>)allMembers);
        List<Pair<String, JsonElement>> memberAnnotations = this.createMemberAnnotations((Iterable<N4MemberDeclaration>)allMembers);
        List<JsonElement> annotations = this.createRuntimeAnnotations((AnnotableElement)typeDecl);
        JsonArray optAnnotations = annotations == null || annotations.isEmpty() ? null : this.array(annotations);
        JsonElement optMemberAnnotations = optAnnotations == null && memberAnnotations.isEmpty() ? null : this.object(memberAnnotations);
        JsonArray optMembers = optMemberAnnotations == null && members.isEmpty() ? null : this.array(members);
        JsonArray reflectInfo = this.array(new JsonElement[]{this.primitive(typeSTE.getName()), this.primitive(modulePath), this.primitive(origin), optMembers, optMemberAnnotations, optAnnotations});
        return reflectInfo;
    }

    private JsonArray array(JsonElement ... elements) {
        return this.array(Arrays.asList(elements));
    }

    private JsonArray array(List<JsonElement> elements) {
        JsonArray array = new JsonArray();
        for (JsonElement elem : elements) {
            if (elem == null) continue;
            array.add(elem);
        }
        return array;
    }

    private JsonElement arrayOrSelf(JsonElement ... elements) {
        if (elements.length == 1) {
            return elements[0];
        }
        return this.array(elements);
    }

    private JsonElement object(List<Pair<String, JsonElement>> pairs) {
        JsonObject object = new JsonObject();
        for (Pair<String, JsonElement> elem : pairs) {
            if (elem == null) continue;
            object.add((String)elem.getKey(), (JsonElement)elem.getValue());
        }
        return object;
    }

    private JsonElement primitive(String value) {
        value = value.replaceAll("\"", "\\\\\"");
        return new JsonPrimitive(value);
    }

    private List<JsonElement> createAllMembers(N4TypeDeclaration typeDecl, Iterable<N4MemberDeclaration> allMembers) {
        if (typeDecl instanceof N4ClassDeclaration) {
            return this.createClassMembers(allMembers);
        }
        if (typeDecl instanceof N4InterfaceDeclaration) {
            return this.createInterfaceMembers(allMembers);
        }
        if (typeDecl instanceof N4EnumDeclaration) {
            return Collections.emptyList();
        }
        throw new RuntimeException("Unknown type to create members");
    }

    private List<JsonElement> createClassMembers(Iterable<N4MemberDeclaration> allMembers) {
        ArrayList<JsonElement> memberStrings = new ArrayList<JsonElement>();
        for (N4MemberDeclaration member : allMembers) {
            if (this.state.info.isHiddenFromReflection(member)) continue;
            boolean serialize = false;
            serialize |= !member.isStatic() && member instanceof N4FieldDeclaration;
            serialize |= this.state.info.isConsumedFromInterface(member);
            if (!(serialize |= member.getName().startsWith("#"))) continue;
            memberStrings.add(this.primitive(this.createMemberString(member)));
        }
        return memberStrings;
    }

    private List<JsonElement> createInterfaceMembers(Iterable<N4MemberDeclaration> allMembers) {
        ArrayList<JsonElement> memberStrings = new ArrayList<JsonElement>();
        for (N4MemberDeclaration member : allMembers) {
            boolean serialize = true;
            serialize &= !this.hasDefault(member);
            serialize &= !member.getName().equals("#hasInstance");
            if (!(serialize &= !(member instanceof N4FieldDeclaration))) continue;
            memberStrings.add(this.primitive(this.createMemberString(member)));
        }
        return memberStrings;
    }

    private boolean hasDefault(N4MemberDeclaration member) {
        if (member instanceof N4FieldDeclaration) {
            return ((N4FieldDeclaration)member).getExpression() != null;
        }
        if (member instanceof N4MethodDeclaration) {
            return ((N4MethodDeclaration)member).getBody() != null;
        }
        if (member instanceof N4FieldAccessor) {
            return ((N4FieldAccessor)member).getBody() != null;
        }
        return false;
    }

    private List<Pair<String, JsonElement>> createMemberAnnotations(Iterable<N4MemberDeclaration> allMembers) {
        ArrayList<Pair<String, JsonElement>> memberAnnotationPairs = new ArrayList<Pair<String, JsonElement>>();
        for (N4MemberDeclaration member : allMembers) {
            TAnnotableElement tAnnotableElem = this.getTAnnotableElement((AnnotableElement)member);
            List<JsonElement> annotations = this.createRuntimeAnnotations2(tAnnotableElem);
            if (annotations == null || annotations.isEmpty()) continue;
            String memberString = this.createMemberString(member);
            memberAnnotationPairs.add((Pair<String, JsonElement>)Pair.of((Object)memberString, (Object)this.array(annotations)));
        }
        return memberAnnotationPairs;
    }

    private String createMemberString(N4MemberDeclaration member) {
        String kindLC = null;
        if (member instanceof N4FieldDeclaration) {
            kindLC = "f";
        } else if (member instanceof N4MethodDeclaration) {
            kindLC = "m";
        } else if (member instanceof N4GetterDeclaration) {
            kindLC = "g";
        } else if (member instanceof N4SetterDeclaration) {
            kindLC = "s";
        } else {
            throw new RuntimeException("Unknown member type");
        }
        String kind = member.isStatic() ? kindLC.toUpperCase() : kindLC;
        String consumed = this.state.info.isConsumedFromInterface(member) ? ":" : ".";
        return String.valueOf(kind) + consumed + member.getName();
    }

    private List<JsonElement> createRuntimeAnnotations(AnnotableElement annElem) {
        TAnnotableElement tAnnElem = this.getTAnnotableElement(annElem);
        return this.createRuntimeAnnotations2(tAnnElem);
    }

    private TAnnotableElement getTAnnotableElement(AnnotableElement annElem) {
        EObject original;
        if (annElem instanceof DelegatingMember) {
            return (TAnnotableElement)((DelegatingMember)annElem).getDelegationTarget().getOriginalTarget();
        }
        if (annElem instanceof N4TypeDeclaration) {
            return this.state.info.getOriginalDefinedType((N4TypeDeclaration)annElem);
        }
        if (annElem instanceof N4MemberDeclaration) {
            return this.state.info.getOriginalDefinedMember((N4MemberDeclaration)annElem);
        }
        if (annElem instanceof TypeDefiningElement && (original = this.state.tracer.getOriginalASTNode((EObject)annElem)) instanceof TypeDefiningElement) {
            return ((TypeDefiningElement)original).getDefinedType();
        }
        return null;
    }

    private List<JsonElement> createRuntimeAnnotations2(TAnnotableElement tAnnElem) {
        if (tAnnElem == null) {
            return null;
        }
        ArrayList<JsonElement> runtimeAnnotations = new ArrayList<JsonElement>();
        for (TAnnotation annotation : tAnnElem.getAnnotations()) {
            AnnotationDefinition.RetentionPolicy retention = AnnotationDefinition.find((String)annotation.getName()).retention;
            if (retention != AnnotationDefinition.RetentionPolicy.RUNTIME && retention != AnnotationDefinition.RetentionPolicy.RUNTIME_TYPEFIELD) continue;
            runtimeAnnotations.add(this.createRuntimeAnnotation2(annotation));
        }
        if (runtimeAnnotations.isEmpty()) {
            return null;
        }
        return runtimeAnnotations;
    }

    private JsonElement createRuntimeAnnotation2(TAnnotation ann) {
        List<JsonElement> args = ann.getArgs().stream().map(arg -> this.primitive(arg.getArgAsString())).collect(Collectors.toList());
        if (args.isEmpty()) {
            return this.primitive(ann.getName());
        }
        return this.arrayOrSelf(new JsonElement[]{this.primitive(ann.getName()), this.array(args)});
    }
}

