/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.AnnotablePropertyAssignment;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.MultiplicativeOperator;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ClassifierAssistant;
import org.eclipse.n4js.transpiler.es.assistants.DelegationAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ReflectionAssistant;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class InterfaceDeclarationTransformation
extends Transformation {
    @Inject
    private ClassifierAssistant classifierAssistant;
    @Inject
    private ReflectionAssistant reflectionAssistant;
    @Inject
    private DelegationAssistant delegationAssistant;
    @Inject
    private TypeAssistant typeAssistant;
    @Inject
    private ResourceNameComputer resourceNameComputer;

    public void assertPreConditions() {
        this.typeAssistant.assertClassifierPreConditions();
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4InterfaceDeclaration> _function = it -> this.transformInterfaceDecl((N4InterfaceDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4InterfaceDeclaration.class, false).forEach(_function);
    }

    private void transformInterfaceDecl(N4InterfaceDeclaration ifcDecl) {
        SymbolTableEntry ifcSTE = this.findSymbolTableEntryForElement((NamedElement)ifcDecl, true);
        EList _ownedMembersRaw = ifcDecl.getOwnedMembersRaw();
        N4MethodDeclaration _createHasInstanceMethod = this.createHasInstanceMethod(ifcDecl, ifcSTE);
        _ownedMembersRaw.add((Object)_createHasInstanceMethod);
        this.reflectionAssistant.addN4TypeGetter((N4TypeDeclaration)ifcDecl, (N4ClassifierDeclaration)ifcDecl);
        ArrayList belowIfcDecl = CollectionLiterals.newArrayList();
        List<Statement> _createStaticFieldInitializations = this.createStaticFieldInitializations(ifcDecl, ifcSTE);
        Iterables.addAll((Collection)belowIfcDecl, _createStaticFieldInitializations);
        this.insertAfter(TranspilerUtils.orContainingExportDeclaration((EObject)ifcDecl), (EObject[])Conversions.unwrapArray((Object)belowIfcDecl, EObject.class));
        Predicate<N4MemberDeclaration> _function = it -> it.isStatic() && it instanceof N4FieldDeclaration;
        ifcDecl.getOwnedMembersRaw().removeIf(_function);
        this.delegationAssistant.replaceDelegatingMembersByOrdinaryMembers((N4ClassifierDeclaration)ifcDecl);
        ObjectLiteral ifcObjLit = this.createInterfaceObject(ifcDecl, ifcSTE);
        VariableDeclaration varDecl = TranspilerBuilderBlocks._VariableDeclaration((String)ifcDecl.getName(), (Expression)ifcObjLit);
        this.getState().tracer.copyTrace((EObject)ifcDecl, new EObject[]{varDecl});
        this.replace(ifcDecl, varDecl);
    }

    private ObjectLiteral createInterfaceObject(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        boolean _not;
        ArrayList props = CollectionLiterals.newArrayList();
        ArrayLiteral extendedInterfaces = this.createDirectlyImplementedOrExtendedInterfacesArgument((N4ClassifierDeclaration)ifcDecl);
        boolean _isEmpty = extendedInterfaces.getElements().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String $extends = this.steFor_$extendsInterfaces().getName();
            PropertyGetterDeclaration __PropertyGetterDecl = TranspilerBuilderBlocks._PropertyGetterDecl((String)$extends, (Statement[])new Statement[]{TranspilerBuilderBlocks._ReturnStmnt((Expression)extendedInterfaces)});
            props.add(__PropertyGetterDecl);
        }
        PropertyNameValuePair[] _createInstanceFieldDefaultsProperty = this.createInstanceFieldDefaultsProperty(ifcDecl, ifcSTE);
        Iterables.addAll((Collection)props, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createInstanceFieldDefaultsProperty)));
        PropertyNameValuePair[] _createInstanceMemberPropertiesExceptFields = this.createInstanceMemberPropertiesExceptFields(ifcDecl, ifcSTE);
        Iterables.addAll((Collection)props, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createInstanceMemberPropertiesExceptFields)));
        PropertyAssignment[] _createStaticMemberPropertiesExceptFields = this.createStaticMemberPropertiesExceptFields(ifcDecl, ifcSTE);
        Iterables.addAll((Collection)props, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createStaticMemberPropertiesExceptFields)));
        return TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)props, PropertyAssignment.class)));
    }

    private ArrayLiteral createDirectlyImplementedOrExtendedInterfacesArgument(N4ClassifierDeclaration typeDecl) {
        List interfaces = this.typeAssistant.getSuperInterfacesSTEs(typeDecl);
        Functions.Function1 _function = ifcSTE -> {
            IdentifiableElement tIfc = ifcSTE.getOriginalTarget();
            if (tIfc instanceof TInterface) {
                return !TypeUtils.isBuiltIn((Type)((Type)tIfc)) && (!this.typeAssistant.inN4JSD((Type)tIfc) || AnnotationDefinition.N4JS.hasAnnotation((TAnnotableElement)tIfc));
            }
            return false;
        };
        Iterable directlyImplementedInterfacesFiltered = IterableExtensions.filter((Iterable)interfaces, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)it);
        return TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)directlyImplementedInterfacesFiltered, (Functions.Function1)_function_1), Expression.class)));
    }

    private PropertyNameValuePair[] createInstanceFieldDefaultsProperty(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        Functions.Function1 _function = it -> !it.isStatic() && it.getName() != null;
        List instanceFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ifcDecl.getOwnedFields(), (Functions.Function1)_function));
        boolean _isEmpty = instanceFields.isEmpty();
        if (_isEmpty) {
            return new PropertyNameValuePair[0];
        }
        Functions.Function1 _function_1 = field -> {
            String _name = field.getName();
            IdentifierRef_IM _xifexpression = null;
            boolean _hasNonTrivialInitExpression = this.hasNonTrivialInitExpression((N4FieldDeclaration)field);
            if (_hasNonTrivialInitExpression) {
                Object _xifexpression_1 = null;
                boolean _canSkipFunctionWrapping = this.canSkipFunctionWrapping(field.getExpression());
                _xifexpression_1 = _canSkipFunctionWrapping ? field.getExpression() : TranspilerBuilderBlocks._ArrowFunc((boolean)false, (FormalParameter[])new FormalParameter[0], (Expression)this.wrapInParenthesesIfNeeded(field.getExpression()));
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = this.undefinedRef();
            }
            return Pair.of((Object)_name, (Object)_xifexpression);
        };
        PropertyNameValuePair __PropertyNameValuePair = TranspilerBuilderBlocks._PropertyNameValuePair((String)this.steFor_$fieldInits().getName(), (Expression)TranspilerBuilderBlocks._ObjLit((Pair[])((Pair[])Conversions.unwrapArray((Object)ListExtensions.map((List)instanceFields, (Functions.Function1)_function_1), Pair.class))));
        return new PropertyNameValuePair[]{__PropertyNameValuePair};
    }

    private PropertyNameValuePair[] createInstanceMemberPropertiesExceptFields(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        Functions.Function1 _function = it -> !it.isStatic() && !it.isAbstract() && it.getName() != null;
        Functions.Function1 _function_1 = it -> !(it instanceof N4FieldDeclaration);
        List instanceMembersExceptFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)ifcDecl.getOwnedMembers(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isEmpty = instanceMembersExceptFields.isEmpty();
        if (_isEmpty) {
            return new PropertyNameValuePair[0];
        }
        Functions.Function1 _function_2 = it -> this.convertMemberToProperty((N4MemberDeclaration)it);
        PropertyNameValuePair __PropertyNameValuePair = TranspilerBuilderBlocks._PropertyNameValuePair((String)this.steFor_$defaultMembers().getName(), (Expression)TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)ListExtensions.map((List)instanceMembersExceptFields, (Functions.Function1)_function_2), PropertyAssignment.class))));
        return new PropertyNameValuePair[]{__PropertyNameValuePair};
    }

    private PropertyAssignment[] createStaticMemberPropertiesExceptFields(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        Functions.Function1 _function = it -> it.isStatic() && !it.isAbstract() && it.getName() != null;
        Functions.Function1 _function_1 = it -> !(it instanceof N4FieldDeclaration);
        List staticMembersExceptFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)ifcDecl.getOwnedMembers(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isEmpty = staticMembersExceptFields.isEmpty();
        if (_isEmpty) {
            return new PropertyAssignment[0];
        }
        Functions.Function1 _function_2 = it -> this.convertMemberToProperty((N4MemberDeclaration)it);
        return (PropertyAssignment[])Conversions.unwrapArray((Object)ListExtensions.map((List)staticMembersExceptFields, (Functions.Function1)_function_2), PropertyAssignment.class);
    }

    private PropertyAssignment convertMemberToProperty(N4MemberDeclaration memberDecl) {
        boolean _not;
        Procedures.Procedure1 _function;
        if (memberDecl instanceof N4FieldDeclaration) {
            LiteralOrComputedPropertyName _declaredName = ((N4FieldDeclaration)memberDecl).getDeclaredName();
            Expression _elvis = null;
            Expression _expression = ((N4FieldDeclaration)memberDecl).getExpression();
            if (_expression != null) {
                _elvis = _expression;
            } else {
                IdentifierRef_IM _undefinedRef = this.undefinedRef();
                _elvis = _undefinedRef;
            }
            return TranspilerBuilderBlocks._PropertyNameValuePair((LiteralOrComputedPropertyName)_declaredName, (Expression)_elvis);
        }
        PropertyGetterDeclaration _switchResult = null;
        boolean _matched = false;
        if (memberDecl instanceof GetterDeclaration) {
            _matched = true;
            _switchResult = N4JSFactory.eINSTANCE.createPropertyGetterDeclaration();
        }
        if (!_matched && memberDecl instanceof SetterDeclaration) {
            _matched = true;
            PropertySetterDeclaration _createPropertySetterDeclaration = N4JSFactory.eINSTANCE.createPropertySetterDeclaration();
            _function = it -> it.setFpar(((SetterDeclaration)memberDecl).getFpar());
            _switchResult = (EObject)ObjectExtensions.operator_doubleArrow((Object)_createPropertySetterDeclaration, (Procedures.Procedure1)_function);
        }
        if (!_matched && memberDecl instanceof FunctionDefinition) {
            _matched = true;
            PropertyMethodDeclaration _createPropertyMethodDeclaration = N4JSFactory.eINSTANCE.createPropertyMethodDeclaration();
            _function = it -> {
                EList _fpars = it.getFpars();
                EList _fpars_1 = ((FunctionDefinition)memberDecl).getFpars();
                Iterables.addAll((Collection)_fpars, (Iterable)_fpars_1);
                it.setGenerator(((FunctionDefinition)memberDecl).isGenerator());
                it.setDeclaredAsync(((FunctionDefinition)memberDecl).isAsync());
            };
            _switchResult = (EObject)ObjectExtensions.operator_doubleArrow((Object)_createPropertyMethodDeclaration, (Procedures.Procedure1)_function);
        }
        if (!_matched) {
            throw new IllegalArgumentException("not a getter, setter, or method declaration");
        }
        PropertyGetterDeclaration result = _switchResult;
        ((AnnotablePropertyAssignment)result).setDeclaredName(((PropertyNameOwner)memberDecl).getDeclaredName());
        ((FunctionOrFieldAccessor)result).set_lok(((FunctionOrFieldAccessor)memberDecl).get_lok());
        ((FunctionOrFieldAccessor)result).setBody(((FunctionOrFieldAccessor)memberDecl).getBody());
        boolean _isEmpty = memberDecl.getAnnotations().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ((AnnotablePropertyAssignment)result).setAnnotationList(TranspilerBuilderBlocks._PropertyAssignmentAnnotationList((Annotation[])((Annotation[])Conversions.unwrapArray((Object)memberDecl.getAnnotations(), Annotation.class))));
        }
        return (AnnotablePropertyAssignment)result;
    }

    private Expression wrapInParenthesesIfNeeded(Expression expr) {
        if (expr instanceof CommaExpression || expr instanceof ObjectLiteral || expr instanceof AwaitExpression || expr instanceof YieldExpression || expr instanceof PromisifyExpression) {
            return TranspilerBuilderBlocks._Parenthesis((Expression)expr);
        }
        return expr;
    }

    private boolean canSkipFunctionWrapping(Expression initExpression) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (initExpression instanceof BooleanLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof NullLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof NumericLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof StringLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof UnaryExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            UnaryOperator _op = ((UnaryExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case INC: {
                        _switchResult_1 = false;
                        break;
                    }
                    case DEC: {
                        _switchResult_1 = false;
                        break;
                    }
                    case DELETE: {
                        _switchResult_1 = false;
                        break;
                    }
                    case POS: {
                        _switchResult_1 = true;
                        break;
                    }
                    case NEG: {
                        _switchResult_1 = true;
                        break;
                    }
                    case INV: {
                        _switchResult_1 = true;
                        break;
                    }
                    case NOT: {
                        _switchResult_1 = true;
                        break;
                    }
                    case TYPEOF: {
                        _switchResult_1 = true;
                        break;
                    }
                    case VOID: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((UnaryExpression)initExpression).getExpression());
        }
        if (!_matched && initExpression instanceof AdditiveExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            AdditiveOperator _op = ((AdditiveExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case ADD: {
                        _switchResult_1 = true;
                        break;
                    }
                    case SUB: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((AdditiveExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((AdditiveExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof MultiplicativeExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            MultiplicativeOperator _op = ((MultiplicativeExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case TIMES: {
                        _switchResult_1 = true;
                        break;
                    }
                    case DIV: {
                        _switchResult_1 = true;
                        break;
                    }
                    case MOD: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((MultiplicativeExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((MultiplicativeExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof BinaryBitwiseExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            BinaryBitwiseOperator _op = ((BinaryBitwiseExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case OR: {
                        _switchResult_1 = true;
                        break;
                    }
                    case XOR: {
                        _switchResult_1 = true;
                        break;
                    }
                    case AND: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((BinaryBitwiseExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((BinaryBitwiseExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof BinaryLogicalExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            BinaryLogicalOperator _op = ((BinaryLogicalExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case OR: {
                        _switchResult_1 = true;
                        break;
                    }
                    case AND: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((BinaryLogicalExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((BinaryLogicalExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof CastExpression) {
            _matched = true;
            _switchResult = this.canSkipFunctionWrapping(((CastExpression)initExpression).getExpression());
        }
        if (!_matched && initExpression instanceof ParenExpression) {
            _matched = true;
            _switchResult = this.canSkipFunctionWrapping(((ParenExpression)initExpression).getExpression());
        }
        if (!_matched && initExpression instanceof IdentifierRef) {
            TField _fieldUndefined;
            _matched = true;
            IdentifiableElement _id = ((IdentifierRef)initExpression).getId();
            return _id == (_fieldUndefined = RuleEnvironmentExtensions.getGlobalObjectScope((RuleEnvironment)this.getState().G).getFieldUndefined());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected List<Statement> createStaticFieldInitializations(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        return this.classifierAssistant.createStaticFieldInitializations((N4ClassifierDeclaration)ifcDecl, ifcSTE, Collections.emptySet());
    }

    private N4MethodDeclaration createHasInstanceMethod(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        TObjectPrototype symbolObjectType = RuleEnvironmentExtensions.symbolObjectType((RuleEnvironment)this.getState().G);
        SymbolTableEntryOriginal symbolSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)symbolObjectType, true);
        SymbolTableEntryOriginal hasInstanceSTE = this.getSymbolTableEntryForMember((TClassifier)symbolObjectType, "hasInstance", false, true, true);
        ParameterizedPropertyAccessExpression_IM hasInstanceExpr = TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)symbolSTE, (SymbolTableEntry[])new SymbolTableEntry[]{hasInstanceSTE});
        LiteralOrComputedPropertyName declaredName = TranspilerBuilderBlocks._LiteralOrComputedPropertyName((Expression)hasInstanceExpr, (String)"#hasInstance");
        TInterface ifcType = this.getState().info.getOriginalDefinedType(ifcDecl);
        String fqn = this.resourceNameComputer.getFullyQualifiedTypeName((Type)ifcType);
        FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar((String)"instance");
        N4MethodDeclaration result = TranspilerBuilderBlocks._N4MethodDecl((boolean)true, (LiteralOrComputedPropertyName)declaredName, (FormalParameter[])new FormalParameter[]{__Fpar}, (Block)TranspilerBuilderBlocks._Block((Statement[])new Statement[]{TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._Snippet((String)("instance && instance.constructor && instance.constructor.n4type && instance.constructor.n4type.allImplementedInterfaces && instance.constructor.n4type.allImplementedInterfaces.indexOf('" + fqn + "') !== -1")))}));
        this.getState().info.markAsHiddenFromReflection((N4MemberDeclaration)result);
        return result;
    }
}

