/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.EffectType;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TAnnotationArgument;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;

public class TypeStatesAnalyser
extends DataFlowVisitor {
    static final String ANNOTATION_INSTATE = "InState";
    static final String ANNOTATION_PRESTATE = "PreState";
    static final String ANNOTATION_POSTSTATE = "PostState";
    final N4JSTypeSystem ts;

    public TypeStatesAnalyser(N4JSTypeSystem ts) {
        this.ts = ts;
    }

    public void visitEffect(EffectInfo effect, ControlFlowElement cfe) {
        Set<String> preStates;
        if (effect.type == EffectType.MethodCall && !(preStates = this.getDeclaredStates(cfe, ANNOTATION_PRESTATE)).isEmpty()) {
            IsInPrestate isInPreState = new IsInPrestate(cfe, effect.symbol, preStates);
            this.assume(isInPreState);
        }
    }

    public void visitGuard(Guard guard) {
        if (guard.asserts != GuardAssertion.MayHolds) {
            GuardType cfr_ignored_0 = guard.type;
        }
    }

    private Set<String> getDeclaredStates(ControlFlowElement container, String stateName) {
        HashSet<String> states = new HashSet<String>();
        if (container instanceof ParameterizedCallExpression) {
            ParameterizedCallExpression pce = (ParameterizedCallExpression)container;
            TFunction tFunc = (TFunction)this.ts.tau((TypableElement)pce);
            for (TAnnotation ann : tFunc.getAnnotations()) {
                if (!stateName.equals(ann.getName())) continue;
                for (TAnnotationArgument arg : ann.getArgs()) {
                    states.add(arg.getArgAsString());
                }
            }
        }
        return states;
    }

    class IsInPrestate
    extends Assumption {
        private final Set<String> preStates;

        IsInPrestate(ControlFlowElement cfe, Symbol symbol, Set<String> preStates) {
            super(cfe, symbol);
            this.preStates = preStates;
        }

        IsInPrestate(IsInPrestate copy) {
            super((Assumption)copy);
            this.preStates = copy.preStates;
        }

        public Assumption copy() {
            return new IsInPrestate(this);
        }

        public void mergeClientData(Assumption assumption) {
            IsInPrestate iip = (IsInPrestate)assumption;
            this.preStates.retainAll(iip.preStates);
        }

        public PartialResult holdsOnEffect(EffectInfo effect, ControlFlowElement container) {
            Set<String> postStates;
            if (effect.type == EffectType.MethodCall && !(postStates = TypeStatesAnalyser.this.getDeclaredStates(container, TypeStatesAnalyser.ANNOTATION_POSTSTATE)).isEmpty()) {
                postStates.removeAll(this.preStates);
                boolean allPostStatesAreValidPreStates = postStates.isEmpty();
                if (allPostStatesAreValidPreStates) {
                    return PartialResult.Passed;
                }
            }
            return PartialResult.Unclear;
        }

        public PartialResult holdsOnGuards(Multimap<GuardType, Guard> neverHolding, Multimap<GuardType, Guard> alwaysHolding) {
            alwaysHolding.containsKey((Object)GuardType.InState);
            return PartialResult.Unclear;
        }
    }

    class IsReasonableStateGuard
    extends Assumption {
        private final Set<String> inStates;
        private final Set<String> postStates;

        IsReasonableStateGuard(ControlFlowElement cfe, Symbol symbol, Set<String> inStates) {
            this(cfe, symbol, inStates, new HashSet<String>());
        }

        IsReasonableStateGuard(ControlFlowElement cfe, Symbol symbol, Set<String> inStates, Set<String> postStates) {
            super(cfe, symbol);
            this.inStates = inStates;
            this.postStates = postStates;
        }

        IsReasonableStateGuard(IsReasonableStateGuard copy) {
            super((Assumption)copy);
            this.inStates = copy.inStates;
            this.postStates = copy.postStates;
        }

        public Assumption copy() {
            return new IsReasonableStateGuard(this);
        }

        public void mergeClientData(Assumption assumption) {
            IsReasonableStateGuard irg = (IsReasonableStateGuard)assumption;
            this.postStates.addAll(irg.postStates);
        }

        public PartialResult holdsOnEffect(EffectInfo effect, ControlFlowElement container) {
            if (effect.type == EffectType.MethodCall) {
                Set<String> postStatesOfMethodCall = TypeStatesAnalyser.this.getDeclaredStates(container, TypeStatesAnalyser.ANNOTATION_POSTSTATE);
                if (!this.postStates.isEmpty()) {
                    this.postStates.addAll(postStatesOfMethodCall);
                    return PartialResult.Passed;
                }
            }
            return PartialResult.Unclear;
        }

        public PartialResult holdsOnGuards(Multimap<GuardType, Guard> neverHolding, Multimap<GuardType, Guard> alwaysHolding) {
            alwaysHolding.containsKey((Object)GuardType.InState);
            return PartialResult.Unclear;
        }
    }
}

