/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CompilerProcessor
extends AbstractFieldProcessor {
    public void doTransform(MutableFieldDeclaration annotatedField, @Extension TransformationContext context) {
        TypeReference _string;
        boolean _tripleEquals;
        TypeReference _type = annotatedField.getType();
        boolean bl = _tripleEquals = _type == (_string = context.getString());
        if (_tripleEquals) {
            context.addError((Element)annotatedField, "Annotated field must be of type String.");
        } else {
            String value = this.getInitializerAsString((FieldDeclaration)annotatedField, context);
            if (value != null) {
                Type resolvedType = context.findTypeGlobally(value);
                if (resolvedType == null) {
                    context.addError((Element)annotatedField.getInitializer(), String.valueOf(value) + " isn't on the classpath.");
                } else if (!(resolvedType instanceof ClassDeclaration)) {
                    context.addError((Element)annotatedField.getInitializer(), String.valueOf(value) + " have to resolve to a class on the classpath.");
                } else {
                    boolean _not;
                    ClassDeclaration clazz = (ClassDeclaration)resolvedType;
                    String subGeneratorInterface = "org.eclipse.n4js.generator.ISubGenerator";
                    boolean _implementsInterface = this.implementsInterface(clazz, "org.eclipse.n4js.generator.ISubGenerator");
                    boolean bl2 = _not = !_implementsInterface;
                    if (_not) {
                        Expression _initializer = annotatedField.getInitializer();
                        Functions.Function1 _function = it -> it.getName();
                        Iterable _map = IterableExtensions.map((Iterable)clazz.getImplementedInterfaces(), (Functions.Function1)_function);
                        String _plus = "The class " + value + " have to implement the interface " + "org.eclipse.n4js.generator.ISubGenerator" + ", but only implements " + _map;
                        context.addError((Element)_initializer, _plus);
                    }
                }
            }
        }
    }

    private boolean implementsInterface(ClassDeclaration clazz, String expectedInterface) {
        boolean _tripleNotEquals;
        Functions.Function1 _function = it -> it.getName().equals(expectedInterface);
        boolean _exists = IterableExtensions.exists((Iterable)clazz.getImplementedInterfaces(), (Functions.Function1)_function);
        if (_exists) {
            return true;
        }
        Functions.Function1 _function_1 = it -> {
            Type _type = it.getType();
            return this.extendsInterface((InterfaceDeclaration)_type, expectedInterface);
        };
        boolean _exists_1 = IterableExtensions.exists((Iterable)clazz.getImplementedInterfaces(), (Functions.Function1)_function_1);
        if (_exists_1) {
            return true;
        }
        TypeReference _extendedClass = clazz.getExtendedClass();
        boolean bl = _tripleNotEquals = _extendedClass != null;
        if (_tripleNotEquals) {
            Type _type = clazz.getExtendedClass().getType();
            return this.implementsInterface((ClassDeclaration)_type, expectedInterface);
        }
        return false;
    }

    private boolean extendsInterface(InterfaceDeclaration interf, String expectedInterface) {
        Functions.Function1 _function = it -> it.getName().equals(expectedInterface);
        boolean _exists = IterableExtensions.exists((Iterable)interf.getExtendedInterfaces(), (Functions.Function1)_function);
        return _exists;
    }

    public String getInitializerAsString(FieldDeclaration f, @Extension TransformationContext context) {
        String string;
        Expression _initializer = f.getInitializer();
        String _string = null;
        if (_initializer != null) {
            _string = _initializer.toString();
        }
        if ((string = _string) == null) {
            context.addError((Element)f, "A value have to be assigned to this annotated field.");
        } else {
            boolean _not;
            boolean bl = _not = !string.startsWith("\"") || !string.endsWith("\"");
            if (_not) {
                context.addError((Element)f, "A quoted string value have to be assigned to this annotated field.");
            } else {
                int _length = string.length();
                int _minus = _length - 1;
                return string.substring(1, _minus);
            }
        }
        return null;
    }
}

