/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandService;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.domain.ID;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestElement;
import org.eclipse.n4js.tester.domain.TestResult;
import org.eclipse.n4js.tester.domain.TestStatus;
import org.eclipse.n4js.tester.domain.TestSuite;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.events.SessionEndedEvent;
import org.eclipse.n4js.tester.events.SessionFailedEvent;
import org.eclipse.n4js.tester.events.SessionFinishedEvent;
import org.eclipse.n4js.tester.events.SessionStartedEvent;
import org.eclipse.n4js.tester.events.TestEndedEvent;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.events.TestStartedEvent;
import org.eclipse.n4js.tester.ui.TestConfigurationConverter;
import org.eclipse.n4js.tester.ui.TesterUiActivator;
import org.eclipse.n4js.tester.ui.resultsview.ResultNode;
import org.eclipse.n4js.tester.ui.resultsview.ShowHistoryAction;
import org.eclipse.n4js.tester.ui.resultsview.TestProgressBar;
import org.eclipse.n4js.tester.ui.resultsview.TestResultHyperlinkDetector;
import org.eclipse.n4js.tester.ui.resultsview.TestViewFilterHelper;
import org.eclipse.n4js.tester.ui.resultsview.TestViewLayoutHelper;
import org.eclipse.n4js.ui.editor.EditorContentExtractor;
import org.eclipse.n4js.ui.editor.StyledTextDescriptor;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.viewer.TreeViewerBuilder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public class TestResultsView
extends ViewPart {
    public static final String ID = "org.eclipse.n4js.tester.ui.TestResultsView";
    private static final String TESTSUITE_NAME_SEGMENT_SEP = "/\\ ,";
    private static final String TAG_TEST_HOVER = "showTestHover";
    private static final String TAG_SCROLL = "scrollLock";
    private static final String TAG_RATIO = "sashRatio";
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_OMIT_COMMON_PREFIX = "omitCommonPrefix";
    private static final String TAG_SHOW_FILTER = "showFilter";
    @Inject
    private TesterEventBus testerEventBus;
    @Inject
    private IURIEditorOpener uriOpener;
    @Inject
    private EditorContentExtractor editorContentExtractor;
    @Inject
    private IN4JSEclipseCore core;
    @Inject
    private TestResultHyperlinkDetector n4JSStackTraceHyperlinkDetector;
    @Inject
    private TestConfigurationConverter testConfigConverter;
    private final List<TestSession> registeredSessions = new ArrayList<TestSession>();
    private ResultNode currentRoot;
    private ResultNode focusNode;
    private ToolBar toolBar;
    private TestProgressBar progressBar;
    private TreeViewer testTreeViewer;
    private TextViewer stackTrace;
    private Action actionScrollLock;
    private Action actionRelaunch;
    private Action actionRelaunchFailed;
    private Action actionStop;
    private Action actionShowHistory;
    private Action actionClearTerminated;
    private Action doubleClickAction;
    private Action singleClickAction;
    private Action actionOpenLaunchConfig;
    private Action actionShowTestHover;
    private Action actionOmitCommonPrefix;
    private TestViewLayoutHelper viewLayoutHelper;
    private TestViewFilterHelper viewFilterHelper;
    private SashForm sashForm;
    private IMemento storedMemento;
    private String commonPrefix;
    private ResultNode lastStartedNode;

    public static TestResultsView getInstance(boolean activate) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TestResultsView view = (TestResultsView)page.showView(ID);
            if (activate) {
                page.activate((IWorkbenchPart)view);
            }
            return view;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateCommonPrefix() {
        this.commonPrefix = "";
        ResultNode[] resultNodeArray = this.currentRoot.getChildren();
        int n = resultNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                ResultNode node = resultNodeArray[n2];
                TestSuite suite = node.getTestSuite();
                if (suite != null) {
                    String name = suite.getName();
                    if (this.commonPrefix.length() == 0) {
                        int sep = TestResultsView.lastTestSuiteNameSegmentSep(name, -1);
                        if (sep > 0 && sep + 1 < name.length()) {
                            this.commonPrefix = name.substring(0, sep + 1);
                            break block9;
                        } else {
                            this.commonPrefix = "";
                            return;
                        }
                    }
                    int min = Math.min(this.commonPrefix.length(), name.length());
                    int i = 0;
                    while (i < min) {
                        if (name.charAt(i) != this.commonPrefix.charAt(i)) break;
                        ++i;
                    }
                    if (i == 0) {
                        this.commonPrefix = "";
                        return;
                    }
                    if (i < min) {
                        int sep = TestResultsView.lastTestSuiteNameSegmentSep(name, i);
                        if (sep <= 0) {
                            this.commonPrefix = "";
                            return;
                        }
                        this.commonPrefix = this.commonPrefix.substring(0, sep + 1);
                    }
                }
            }
            ++n2;
        }
    }

    private static int lastTestSuiteNameSegmentSep(String s, int startAt) {
        if (startAt < 0 || startAt >= s.length()) {
            startAt = s.length() - 1;
        }
        int i = startAt;
        while (i >= 0) {
            if (TESTSUITE_NAME_SEGMENT_SEP.indexOf(s.charAt(i)) >= 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private String trimCommonPrefix(String name) {
        if (this.commonPrefix == null || this.commonPrefix.length() == 0 || name.length() <= this.commonPrefix.length()) {
            return name;
        }
        return name.substring(this.commonPrefix.length(), name.length());
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.storedMemento = memento;
        this.testerEventBus.register((Object)this);
    }

    public void saveState(IMemento memento) {
        if (this.sashForm == null) {
            if (this.storedMemento != null) {
                this.storedMemento.putMemento(memento);
            }
            return;
        }
        memento.putBoolean(TAG_TEST_HOVER, this.actionShowTestHover.isChecked());
        memento.putBoolean(TAG_OMIT_COMMON_PREFIX, this.actionOmitCommonPrefix.isChecked());
        memento.putBoolean(TAG_SCROLL, this.actionScrollLock.isChecked());
        int[] weigths = this.sashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        memento.putInteger(TAG_ORIENTATION, this.viewLayoutHelper.getOrientation());
        memento.putInteger(TAG_SHOW_FILTER, this.viewFilterHelper.getFilter());
    }

    private void restoreLayoutState(IMemento memento) {
        Boolean omitCommonPrefix;
        Boolean testHover;
        Boolean scrollLock;
        Integer filter;
        Integer orientation;
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.sashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.viewLayoutHelper.setOrientation(orientation);
        }
        if ((filter = memento.getInteger(TAG_SHOW_FILTER)) != null) {
            this.viewFilterHelper.setFilter(filter);
        }
        if ((scrollLock = memento.getBoolean(TAG_SCROLL)) != null) {
            this.actionScrollLock.setChecked(scrollLock.booleanValue());
        }
        if ((testHover = memento.getBoolean(TAG_TEST_HOVER)) != null) {
            this.actionShowTestHover.setChecked(testHover.booleanValue());
        }
        if ((omitCommonPrefix = memento.getBoolean(TAG_OMIT_COMMON_PREFIX)) != null) {
            this.actionOmitCommonPrefix.setChecked(omitCommonPrefix.booleanValue());
        }
    }

    public void dispose() {
        this.testerEventBus.unregister((Object)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 4;
        parent.setLayout((Layout)gl);
        this.toolBar = new ToolBar(parent, 0x820000);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 0x1000000;
        this.toolBar.setLayoutData((Object)gd);
        this.progressBar = new TestProgressBar(parent, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.progressBar.setLayoutData(gd);
        this.sashForm = new SashForm(parent, 0);
        this.sashForm.setBackground(this.sashForm.getDisplay().getSystemColor(15));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.sashForm.setLayoutData((Object)gd);
        this.viewLayoutHelper = new TestViewLayoutHelper(this.sashForm);
        this.testTreeViewer = (TreeViewer)new TreeViewerBuilder((List)Lists.newArrayList((Object[])new String[]{"Test", "Status", "Duration"}), (IContentProvider)new TestTreeViewerContentProvider()).setUseHashlookup(true).setLinesVisible(false).setLabelProvider((IBaseLabelProvider)new TestTreeViewerLabelProvider()).setColumnWeights(Ints.asList((int[])new int[]{5, 2, 1})).build((Composite)this.sashForm);
        this.installToolTipSupport((Control)this.testTreeViewer.getTree());
        this.viewFilterHelper = new TestViewFilterHelper(this.testTreeViewer);
        this.testTreeViewer.setInput((Object)this.getViewSite());
        this.stackTrace = new TextViewer((Composite)this.sashForm, 778);
        this.stackTrace.setHyperlinkPresenter((IHyperlinkPresenter)new DefaultHyperlinkPresenter(new RGB(0, 0, 255)));
        this.stackTrace.setHyperlinkDetectors(new IHyperlinkDetector[]{this.n4JSStackTraceHyperlinkDetector}, 0);
        this.stackTrace.setDocument((IDocument)new Document());
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.stackTrace.getTextWidget().setFont(font);
        this.sashForm.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TestResultsView.this.viewLayoutHelper.updateSashLayout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.createActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookSingleClickAction();
        this.contributeToActionBars();
        if (this.storedMemento != null) {
            this.restoreLayoutState(this.storedMemento);
            this.storedMemento = null;
        }
        this.refreshActions();
    }

    private ToolTip installToolTipSupport(Control control) {
        return new CodeSnippetToolTip(control);
    }

    private void hookDoubleClickAction() {
        this.testTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TestResultsView.this.doubleClickAction.run();
            }
        });
    }

    private void hookSingleClickAction() {
        this.testTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestResultsView.this.singleClickAction.run();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestResultsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.testTreeViewer.getControl());
        this.testTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.testTreeViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        ToolBarManager m = new ToolBarManager(this.toolBar);
        this.fillCustomToolBar((IToolBarManager)m);
        m.update(true);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionOpenLaunchConfig);
        manager.add((IAction)this.actionRelaunch);
        manager.add((IAction)this.actionRelaunchFailed);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionOpenLaunchConfig);
        manager.add((IAction)this.actionRelaunch);
        manager.add((IAction)this.actionRelaunchFailed);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)this.viewLayoutHelper.orientationMenu);
        manager.add((IAction)this.actionShowTestHover);
        manager.add((IAction)this.actionOmitCommonPrefix);
        manager.add((IContributionItem)new Separator());
        manager.add(this.viewFilterHelper.getFailureAction());
        manager.add(this.viewFilterHelper.getSkippedAction());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowHistory);
        manager.add((IContributionItem)new Separator());
        manager.add(this.viewFilterHelper.getFailureAction());
        manager.add(this.viewFilterHelper.getSkippedAction());
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRelaunch);
        manager.add((IAction)this.actionRelaunchFailed);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionOpenLaunchConfig);
    }

    private void fillCustomToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowHistory);
    }

    protected void createActions() {
        this.actionScrollLock = this.createAction("Scroll Lock", 2, "Do not jump to test case when its status is updated.", TesterUiActivator.getImageDescriptor("lock.gif"), null);
        this.actionOpenLaunchConfig = this.createAction("Open Configuration", 1, "Open the launch configuration for this test.", TesterUiActivator.getImageDescriptor("launchconfig.gif"), this::performOpenLaunchConfig);
        this.actionRelaunch = this.createAction("Relaunch", 1, "Relaunch entire test session.", TesterUiActivator.getImageDescriptor("relaunch.gif"), this::performRelaunch);
        this.actionRelaunchFailed = this.createAction("Relaunch Failed", 1, "Relaunch failed tests from last test session.", TesterUiActivator.getImageDescriptor("relaunchf.gif"), this::performRelaunchFailed);
        this.actionStop = this.createAction("Stop", 1, "Stop currently running test session.", TesterUiActivator.getImageDescriptor("stop.gif"), this::performStop);
        this.actionStop.setEnabled(false);
        this.actionShowHistory = new ShowHistoryAction(this);
        this.actionClearTerminated = this.createAction("Clear Terminated", 1, "Clear terminated sessions from history.", null, this::performClearTerminated);
        this.doubleClickAction = this.createAction(null, 1, null, null, this::onDoubleClick);
        this.singleClickAction = this.createAction(null, 1, null, null, this::onSingleClick);
        this.actionShowTestHover = this.createAction("Show Test in Hover", 2, "Show the test in a hover when mouse is over the test method.", null, null);
        this.actionOmitCommonPrefix = this.createAction("Omit Common Prefix", 2, "Omit common prefix of names of test suites (typically path segments).", null, () -> {
            if (this.currentRoot != null && this.testTreeViewer != null) {
                Object element;
                ISelection sel = this.testTreeViewer.getSelection();
                this.testTreeViewer.refresh();
                if (sel instanceof TreeSelection && (element = ((TreeSelection)sel).getFirstElement()) instanceof ResultNode) {
                    this.showNode((ResultNode)element);
                }
            }
        });
    }

    protected Action createAction(String text, int style, String tooltip, ImageDescriptor imageDescriptor, final Runnable runnable) {
        Action a = new Action(text, style){

            public void run() {
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        a.setToolTipText(tooltip);
        a.setImageDescriptor(imageDescriptor);
        return a;
    }

    Action getActionClearTerminated() {
        return this.actionClearTerminated;
    }

    protected void refreshActions() {
        this.actionScrollLock.setEnabled(true);
        this.actionOpenLaunchConfig.setEnabled(this.currentRoot != null);
        boolean isRunningOrNoRoot = this.currentRoot == null || this.currentRoot.isRunning();
        this.actionRelaunch.setEnabled(!isRunningOrNoRoot);
        this.actionRelaunchFailed.setEnabled(!isRunningOrNoRoot);
        this.actionStop.setEnabled(isRunningOrNoRoot);
        this.actionShowHistory.setEnabled(true);
        this.actionClearTerminated.setEnabled(this.containsTerminated());
    }

    protected void performRelaunch() {
        TestSession session;
        if (this.currentRoot != null && (session = (TestSession)FluentIterable.from(this.registeredSessions).firstMatch(s -> s.root == this.currentRoot).orNull()) != null) {
            this.registeredSessions.remove(session);
            ILaunchConfiguration launchConfig = this.getLaunchConfigForSession(session, null);
            DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)"run", (boolean)true);
        }
    }

    protected void performRelaunchFailed() {
        TestSession session;
        if (this.currentRoot != null && (session = (TestSession)FluentIterable.from(this.registeredSessions).firstMatch(s -> s.root == this.currentRoot).orNull()) != null) {
            List<TestCase> failed = session.root.getFailed();
            if (failed.isEmpty()) {
                return;
            }
            this.registeredSessions.remove(session);
            ILaunchConfiguration launchConfig = this.getLaunchConfigForSession(session, failed);
            DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)"run", (boolean)true);
        }
    }

    private ILaunchConfiguration getLaunchConfigForSession(TestSession session, List<TestCase> failed) {
        TestConfiguration testConfig = session.configuration;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(testConfig.getLaunchConfigurationTypeIdentifier());
        ILaunchConfiguration launchConfig = this.testConfigConverter.toLaunchConfiguration(type, testConfig, failed);
        return launchConfig;
    }

    protected void performOpenLaunchConfig() {
        TestSession session;
        if (this.currentRoot != null && (session = (TestSession)FluentIterable.from(this.registeredSessions).firstMatch(s -> s.root == this.currentRoot).orNull()) != null) {
            HashSet<String> modes;
            TestConfiguration testConfig = session.configuration;
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(testConfig.getLaunchConfigurationTypeIdentifier());
            ILaunchConfiguration launchConfig = this.testConfigConverter.toLaunchConfiguration(type, testConfig, null);
            try {
                modes = launchConfig.getModes();
            }
            catch (CoreException e) {
                modes = new HashSet<String>();
            }
            if (modes.isEmpty()) {
                modes.add("run");
            }
            LaunchConfigurationManager configManager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
            ILaunchGroup group = configManager.getLaunchGroup(type, modes);
            DebugUITools.openLaunchConfigurationDialog((Shell)this.getViewSite().getShell(), (ILaunchConfiguration)launchConfig, (String)group.getIdentifier(), null);
        }
    }

    protected void performStop() {
        IProcess process = DebugUITools.getCurrentProcess();
        if (process == null) {
            return;
        }
        TestSession session = (TestSession)FluentIterable.from(this.registeredSessions).firstMatch(s -> s.root == this.currentRoot).orNull();
        if (session != null) {
            ILaunch launch = process.getLaunch();
            ILaunchConfiguration runningConfig = launch.getLaunchConfiguration();
            ILaunchConfiguration sessionConfig = this.getLaunchConfigForSession(session, null);
            if (runningConfig.getName() == sessionConfig.getName()) {
                List<ITerminate> targets = this.collectTargets(process);
                targets.add((ITerminate)process);
                DebugCommandService service = DebugCommandService.getService((IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                service.executeCommand(ITerminateHandler.class, targets.toArray(), null);
                session.root.stopRunning();
                this.refreshActions();
            }
        }
    }

    private List<ITerminate> collectTargets(IProcess process) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        ArrayList<ITerminate> targets = new ArrayList<ITerminate>();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IProcess[] processes = launch.getProcesses();
            int j = 0;
            while (j < processes.length) {
                IProcess process2 = processes[j];
                if (process2.equals(process)) {
                    IDebugTarget[] debugTargets = launch.getDebugTargets();
                    int k = 0;
                    while (k < debugTargets.length) {
                        targets.add((ITerminate)debugTargets[k]);
                        ++k;
                    }
                    return targets;
                }
                ++j;
            }
            ++i;
        }
        return targets;
    }

    protected void performClearTerminated() {
        this.clearTerminated();
    }

    protected void onDoubleClick() {
        ISelection selection = this.testTreeViewer.getSelection();
        ResultNode resultNode = (ResultNode)((IStructuredSelection)selection).getFirstElement();
        if (resultNode == null) {
            return;
        }
        TestElement testElement = resultNode.getElement();
        if (testElement instanceof TestCase) {
            this.openTestMethod((TestCase)testElement);
        } else if (testElement instanceof TestSuite) {
            this.openTestClass((TestSuite)testElement);
        }
    }

    private void openTestClass(TestSuite testSuite) {
        URI testCaseURI;
        URI moduleLocation;
        Optional foundTestCase = testSuite.getTestCases().stream().findFirst();
        if (foundTestCase.isPresent() && !this.openErrorIfProblem(moduleLocation = (testCaseURI = ((TestCase)foundTestCase.get()).getURI()).trimFragment())) {
            String caseFragment = testCaseURI.fragment();
            if (caseFragment != null) {
                int lastAt = caseFragment.lastIndexOf("/@");
                if (lastAt >= 0) {
                    String classFragment = caseFragment.substring(0, lastAt);
                    URI classLocation = moduleLocation.appendFragment(classFragment);
                    this.uriOpener.open(classLocation, true);
                }
            } else {
                this.uriOpener.open(moduleLocation, true);
            }
        }
    }

    private void openTestMethod(TestCase testCase) {
        URI testCaseURI = testCase.getURI();
        if (testCaseURI == null) {
            return;
        }
        URI moduleLocation = testCaseURI.trimFragment();
        if (!this.openErrorIfProblem(moduleLocation)) {
            this.uriOpener.open(testCaseURI, true);
        }
    }

    private boolean openErrorIfProblem(URI moduleLocationURI) {
        IN4JSEclipseProject project = (IN4JSEclipseProject)this.core.findProject(moduleLocationURI).orNull();
        if (project == null || !project.exists()) {
            MessageDialog.openError((Shell)UIUtils.getShell(), (String)"Cannot open editor", (String)"The container project not found in the workspace.");
            return true;
        }
        String[] projectRelativeSegments = moduleLocationURI.deresolve(project.getLocation().toURI()).segments();
        String path = Joiner.on((char)'/').join((Object[])Arrays.copyOfRange(projectRelativeSegments, 1, projectRelativeSegments.length));
        IFile module = project.getProject().getFile(path);
        if (module == null || !module.isAccessible()) {
            MessageDialog.openError((Shell)UIUtils.getShell(), (String)"Cannot open editor", (String)"Test class not found in selected project.");
            return true;
        }
        return false;
    }

    protected void onSingleClick() {
        TestCase testCase;
        TestResult result;
        ResultNode resultNode;
        TestElement testElement;
        Object element;
        this.stackTrace.getDocument().set("");
        ISelection selection = this.testTreeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ResultNode && (testElement = (resultNode = (ResultNode)element).getElement()) instanceof TestCase && (result = (testCase = (TestCase)testElement).getResult()) != null) {
            if (result.getTrace() != null && !result.getTrace().isEmpty()) {
                ArrayList trace = Lists.newArrayList((Iterable)result.getTrace());
                String firstLine = (String)trace.get(0);
                if ("Error".equals(firstLine) && !Strings.isNullOrEmpty((String)result.getMessage())) {
                    trace.set(0, result.getMessage());
                }
                StringBuilder sb = new StringBuilder();
                trace.forEach(line -> {
                    StringBuilder stringBuilder2 = sb.append((String)line).append(System.lineSeparator());
                });
                this.stackTrace.getDocument().set(sb.toString());
            } else if ((TestStatus.SKIPPED_IGNORE.equals((Object)result.getTestStatus()) || TestStatus.SKIPPED_FIXME.equals((Object)result.getTestStatus()) || TestStatus.ERROR.equals((Object)result.getTestStatus())) && !Strings.isNullOrEmpty((String)result.getMessage())) {
                this.stackTrace.getDocument().set(result.getMessage());
            }
        }
    }

    protected void onScrollLockToggled() {
        List runningNodes;
        if (this.actionScrollLock.isChecked()) {
            this.setFocusNode(null, false);
        } else if (this.currentRoot != null && !(runningNodes = this.currentRoot.stream().filter(node -> node.isRunning()).collect(Collectors.toList())).isEmpty()) {
            ResultNode lastRunningNode = (ResultNode)runningNodes.get(runningNodes.size() - 1);
            this.setFocusNode(lastRunningNode, true);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onTestEvent(TestEvent ev) {
        Display.getDefault().asyncExec(() -> this.notifyTestEvent(ev));
    }

    public void notifyTestEvent(TestEvent event) {
        TestSession session;
        if (event instanceof SessionStartedEvent) {
            if (this.testTreeViewer != null) {
                this.testTreeViewer.expandAll();
            }
        } else if (event instanceof TestStartedEvent) {
            this.notifyTestCaseStarted(new ID(((TestStartedEvent)event).getTestId()));
        } else if (event instanceof TestEndedEvent) {
            TestEndedEvent teev = (TestEndedEvent)event;
            this.notifyTestCaseEnded(new ID(teev.getTestId()), teev.getResult());
        } else if (event instanceof SessionEndedEvent) {
            this.notifySessionEnded(new ID(event.getSessionId()));
        } else if (!(event instanceof SessionFinishedEvent) && event instanceof SessionFailedEvent && (session = (TestSession)FluentIterable.from(this.registeredSessions).firstMatch(s -> s.root == this.currentRoot).orNull()) != null) {
            this.notifySessionFailed(session, (String)((SessionFailedEvent)event).getComment().or((Object)"Unknown cause."));
        }
    }

    protected void notifyTestTreeCreated(TestConfiguration configuration, TestTree testTree) {
        Display.getDefault().asyncExec(() -> {
            boolean alreadyAdded;
            boolean bl = alreadyAdded = this.findRootNode(testTree.getSessionId()) != null;
            if (alreadyAdded) {
                this.setShownTestTree(testTree.getSessionId());
            } else {
                this.addTestTree(configuration, testTree, true);
            }
        });
    }

    protected void notifyTestCaseStarted(ID testCaseId) {
        ResultNode node;
        this.lastStartedNode = node = this.findNode(testCaseId);
        if (node != null) {
            node.startRunning();
            this.showNode(node);
            this.refreshActions();
        }
    }

    void showNode(ResultNode node) {
        if (this.isShown(node)) {
            this.updateNode(node);
            this.setFocusNode(node, true);
        }
    }

    protected void notifyTestCaseEnded(ID testCaseId, TestResult testResult) {
        ResultNode node = this.findNode(testCaseId);
        if (node != null) {
            node.stopRunning();
            node.updateResult(testResult);
            if (this.isShown(node)) {
                this.updateNode(node);
                this.updateProgressBar();
                this.setFocusNode(node, true);
            }
            if (this.viewFilterHelper.getFilter() != 0) {
                this.testTreeViewer.refresh();
                this.showNode(this.lastStartedNode);
            }
            this.refreshActions();
        }
    }

    protected void notifySessionEnded(ID sessionId) {
        ResultNode rootNode = this.findNode(sessionId);
        if (rootNode != null) {
            rootNode.stopRunning();
            if (this.isShown(rootNode)) {
                this.setFocusNode(null, false);
            }
            this.refreshActions();
        }
    }

    public List<TestTree> getTestTrees() {
        return this.registeredSessions.stream().map(session -> session.root).map(currRoot -> currRoot.getTestTree()).collect(Collectors.toList());
    }

    public void addTestTree(TestConfiguration configuration, TestTree testTree, boolean show) {
        String sessionId;
        if (testTree == null) {
            throw new IllegalArgumentException("testTree may not be null");
        }
        String string = sessionId = testTree.getSessionId() != null ? testTree.getSessionId().getValue() : null;
        if (sessionId == null || sessionId.trim().length() == 0) {
            throw new IllegalArgumentException("testTree must have a non-null, non-empty sessionId");
        }
        if (this.findRootNode(testTree.getSessionId()) != null) {
            throw new IllegalArgumentException("view already contains a test tree with the same sessionId");
        }
        ResultNode newRoot = this.createNodes(testTree);
        newRoot.startRunning();
        this.registeredSessions.add(new TestSession(configuration, newRoot));
        this.refreshActions();
        if (show) {
            this.setShownTestTree(testTree.getSessionId());
        }
    }

    public void clear() {
        this.registeredSessions.clear();
        this.setShownTestTree(null);
    }

    public void clearTerminated() {
        Iterator i = FluentIterable.from(this.registeredSessions).transform(session -> session.root).iterator();
        while (i.hasNext()) {
            if (((ResultNode)i.next()).isRunning()) continue;
            i.remove();
        }
        if (this.currentRoot != null && !this.registeredSessions.stream().filter(session -> session.root == this.currentRoot).findFirst().isPresent()) {
            this.setShownTestTree(null);
        }
        if (this.currentRoot == null && !this.registeredSessions.isEmpty()) {
            this.setShownTestTree(this.registeredSessions.get((int)(this.registeredSessions.size() - 1)).root.getId());
        }
    }

    protected boolean containsTerminated() {
        return this.registeredSessions.stream().anyMatch(currSession -> !currSession.root.isRunning());
    }

    public TestTree getShownTestTree() {
        return this.currentRoot != null ? this.currentRoot.getTestTree() : null;
    }

    public void setShownTestTree(ID sessionId) {
        ResultNode rootToShow = sessionId != null ? this.findRootNode(sessionId) : null;
        this.setRoot(rootToShow);
    }

    protected boolean isShown(ResultNode node) {
        return node != null && this.currentRoot != null && this.currentRoot == node.getRoot();
    }

    protected void setRoot(ResultNode root) {
        if (root != null && !FluentIterable.from(this.registeredSessions).firstMatch(s -> s.root == root).isPresent()) {
            throw new IllegalArgumentException("root is not registered in resultRegistry");
        }
        this.setFocusNode(null, false);
        this.currentRoot = root;
        this.updateCommonPrefix();
        this.progressBar.setExpectedTotal(root != null ? root.countTestCases() : 0);
        this.progressBar.setCounter(root != null ? root.getChildrenStatus() : null);
        this.testTreeViewer.setInput((Object)root);
        this.refreshActions();
    }

    protected ResultNode findRootNode(ID id) {
        for (ResultNode currRoot : FluentIterable.from(this.registeredSessions).transform(session -> session.root)) {
            if (!id.equals((Object)currRoot.getId())) continue;
            return currRoot;
        }
        return null;
    }

    protected ResultNode findNode(ID id) {
        int idx = this.registeredSessions.size() - 1;
        while (idx >= 0) {
            ResultNode currRoot = this.registeredSessions.get((int)idx).root;
            ResultNode matchingNode = currRoot.findById(id);
            if (matchingNode != null) {
                return matchingNode;
            }
            --idx;
        }
        return null;
    }

    protected void expand(ResultNode node) {
        this.testTreeViewer.expandToLevel((Object)node, 0);
    }

    protected void collapse(ResultNode node) {
        this.testTreeViewer.collapseToLevel((Object)node, 1);
    }

    protected void updateProgressBar() {
        this.progressBar.redraw();
    }

    protected void updateNode(ResultNode node) {
        while (node != null) {
            this.testTreeViewer.update((Object)node, null);
            node = node.getParent();
        }
    }

    public void setFocus() {
        this.testTreeViewer.getControl().setFocus();
    }

    protected void setFocusNode(ResultNode newNode, boolean reveal) {
        if (this.focusNode == newNode || this.actionScrollLock.isChecked()) {
            return;
        }
        if (this.focusNode != null) {
            ResultNode n = this.focusNode;
            while (n != null) {
                if (!(!n.isContainer() || newNode != null && n.isAncestorOf(newNode) || this.constainsTestCasesWithoutResult(n))) {
                    this.collapse(n);
                }
                n = n.getParent();
            }
        }
        this.focusNode = newNode;
        if (this.focusNode != null) {
            this.expand(this.focusNode);
            if (reveal && !this.actionScrollLock.isChecked()) {
                this.testTreeViewer.reveal((Object)this.focusNode);
            }
        }
    }

    private boolean constainsTestCasesWithoutResult(ResultNode node) {
        return node.stream().anyMatch(currNode -> {
            TestCase _case = currNode.getTestCase();
            return _case != null && _case.getResult() == null;
        });
    }

    protected ResultNode createNodes(TestTree testTree) {
        ResultNode newRoot = new ResultNode(null, (TestElement)testTree);
        for (TestSuite suite : testTree.getSuites()) {
            ResultNode suiteNode = new ResultNode(newRoot, (TestElement)suite);
            for (TestCase _case : suite.getTestCases()) {
                ResultNode resultNode = new ResultNode(suiteNode, (TestElement)_case);
            }
        }
        return newRoot;
    }

    private void notifySessionFailed(TestSession session, String comment) {
        TestResult earlyTerminationResult = new TestResult(TestStatus.ERROR);
        earlyTerminationResult.setMessage("Error: " + comment);
        HashSet<ResultNode> allNodes = new HashSet<ResultNode>();
        this.collectAllNodes(session.root, allNodes);
        for (ResultNode node : allNodes) {
            if (!node.isLeaf()) continue;
            if (node.isRunning()) {
                node.stopRunning();
                node.updateResult(earlyTerminationResult);
                this.updateNode(node);
                continue;
            }
            if (node.getStatus() != null) continue;
            node.updateResult(new TestResult(TestStatus.SKIPPED));
            this.updateNode(node);
        }
        this.updateProgressBar();
    }

    private void collectAllNodes(ResultNode root, Set<ResultNode> nodes) {
        if (nodes.contains(root)) {
            return;
        }
        nodes.add(root);
        ResultNode[] resultNodeArray = root.getChildren();
        int n = resultNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResultNode child = resultNodeArray[n2];
            this.collectAllNodes(child, nodes);
            ++n2;
        }
    }

    private class CodeSnippetToolTip
    extends ToolTip {
        private StyledTextDescriptor lastDescriptor;

        private CodeSnippetToolTip(Control control) {
            super(control);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Object layoutData = parent.getLayoutData();
            StyledText text = this.lastDescriptor.toStyledText(parent, 0);
            if (layoutData instanceof GridData) {
                ((GridData)layoutData).heightHint = text.getBounds().height;
                ((GridData)layoutData).widthHint = text.getBounds().width;
            }
            return parent;
        }

        protected boolean shouldCreateToolTip(Event e) {
            StyledTextDescriptor descriptor;
            URI uri;
            ResultNode node;
            Tree tree;
            TreeItem item;
            this.lastDescriptor = null;
            if (e.widget instanceof Tree && TestResultsView.this.actionShowTestHover != null && TestResultsView.this.actionShowTestHover.isChecked() && (item = (tree = (Tree)e.widget).getItem(new Point(e.x, e.y))) != null && item.getData() instanceof ResultNode && (node = (ResultNode)item.getData()).getElement() instanceof TestCase && (uri = ((TestCase)node.getElement()).getURI()) != null && (descriptor = this.getDescriptor(uri)) != null) {
                this.lastDescriptor = descriptor;
            }
            return this.lastDescriptor != null;
        }

        private StyledTextDescriptor getDescriptor(URI uri) {
            return (StyledTextDescriptor)TestResultsView.this.editorContentExtractor.getDescriptorForSemanticElement(uri).orNull();
        }
    }

    private static final class TestSession {
        final TestConfiguration configuration;
        final ResultNode root;

        private TestSession(TestConfiguration configuration, ResultNode resultNode) {
            this.configuration = configuration;
            this.root = resultNode;
        }
    }

    private class TestTreeViewerContentProvider
    implements ITreeContentProvider {
        private TestTreeViewerContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof ResultNode) {
                return this.getChildren(input);
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return ((ResultNode)parent).hasChildren();
        }

        public Object[] getChildren(Object parent) {
            Object[] children = ((ResultNode)parent).getChildren();
            if (TestResultsView.this.viewFilterHelper.getFilter() != 0) {
                ArrayList<Object> filteredChildren = new ArrayList<Object>(children.length);
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object node = objectArray[n2];
                    TestStatus result = ((ResultNode)node).getStatus();
                    if (result == null && ((ResultNode)node).getTestSuite() != null) {
                        result = ((ResultNode)node).getChildrenStatus().getAggregatedStatus();
                    }
                    if (TestResultsView.this.viewFilterHelper.match(result)) {
                        filteredChildren.add(node);
                    } else if (TestResultsView.this.viewFilterHelper.getFilter() == 2 && ((ResultNode)node).getTestSuite() != null && TestResultsView.this.viewFilterHelper.match(result = ((ResultNode)node).getChildrenStatus().containsSkipped())) {
                        filteredChildren.add(node);
                    }
                    ++n2;
                }
                return filteredChildren.toArray();
            }
            return children;
        }

        public Object getParent(Object child) {
            return ((ResultNode)child).getParent();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class TestTreeViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private TestTreeViewerLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ResultNode node = (ResultNode)element;
            switch (columnIndex) {
                case 0: {
                    TestElement tmElement = node.getElement();
                    if (tmElement instanceof TestSuite) {
                        String name = ((TestSuite)tmElement).getName();
                        if (TestResultsView.this.actionOmitCommonPrefix.isChecked()) {
                            name = TestResultsView.this.trimCommonPrefix(name);
                        }
                        return name;
                    }
                    if (tmElement instanceof TestCase) {
                        return ((TestCase)tmElement).getName();
                    }
                    return null;
                }
                case 1: {
                    if (node.isLeaf()) {
                        TestStatus stat = ((ResultNode)element).getStatus();
                        if (stat != null) {
                            return stat.toString();
                        }
                        if (node.isRunning()) {
                            return "running ...";
                        }
                        return null;
                    }
                    return node.getChildrenStatus().toString(true, 0, 16384);
                }
                case 2: {
                    TestCase testCase;
                    long runtime = node.getElapsedTime();
                    if (runtime > 0L) {
                        return "   " + String.format("%.3f", Float.valueOf((float)runtime / 1000.0f)) + " s";
                    }
                    if (node.getElement() instanceof TestCase && (testCase = (TestCase)node.getElement()).getResult() != null) {
                        return "< 0.001 s";
                    }
                    return null;
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ResultNode node = (ResultNode)element;
                    if (node.isLeaf()) {
                        if (node.isRunning()) {
                            return TesterUiActivator.getImage("testrunning.gif");
                        }
                        TestStatus status = node.getStatus();
                        if (status == TestStatus.SKIPPED) {
                            return TesterUiActivator.getImage("testignored.gif");
                        }
                        if (status == TestStatus.PASSED) {
                            return TesterUiActivator.getImage("testok.gif");
                        }
                        if (status == TestStatus.FAILED) {
                            return TesterUiActivator.getImage("testfail.gif");
                        }
                        if (status == TestStatus.ERROR) {
                            return TesterUiActivator.getImage("testerr.gif");
                        }
                        if (status == TestStatus.SKIPPED_NOT_IMPLEMENTED || status == TestStatus.SKIPPED_PRECONDITION) {
                            return TesterUiActivator.getImage("testassumptionfailed.gif");
                        }
                        return TesterUiActivator.getImage("test.gif");
                    }
                    if (node.isRunning()) {
                        return TesterUiActivator.getImage("tsuiterunning.gif");
                    }
                    TestStatus status = node.getChildrenStatus().getAggregatedStatus();
                    if (status == TestStatus.SKIPPED || status == TestStatus.SKIPPED_NOT_IMPLEMENTED || status == TestStatus.SKIPPED_PRECONDITION) {
                        return TesterUiActivator.getImage("tsuiteignored.gif");
                    }
                    if (status == TestStatus.PASSED) {
                        return TesterUiActivator.getImage("tsuiteok.gif");
                    }
                    if (status == TestStatus.FAILED) {
                        return TesterUiActivator.getImage("tsuitefail.gif");
                    }
                    if (status == TestStatus.ERROR) {
                        return TesterUiActivator.getImage("tsuiteerr.gif");
                    }
                    return TesterUiActivator.getImage("tsuite.gif");
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (columnIndex == 1) {
                ResultNode node = (ResultNode)element;
                if (node.isLeaf()) {
                    return TestResultsView.this.progressBar.getColorForStatus(node.getStatus());
                }
                return TestResultsView.this.progressBar.getColorForStatus(node.getChildrenStatus().getAggregatedStatus());
            }
            return null;
        }
    }
}

