/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Singleton;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

@Singleton
public class LspLogger {
    private LanguageClient languageClient;

    public void connect(LanguageClient client) {
        this.languageClient = client;
    }

    public void disconnect() {
        this.languageClient = null;
    }

    public void log(String messageString) {
        this.log(messageString, MessageType.Log);
    }

    public void info(String messageString) {
        this.log(messageString, MessageType.Info);
    }

    public void warning(String messageString) {
        this.log(messageString, MessageType.Warning);
    }

    public void error(String messageString) {
        this.log(messageString, MessageType.Error);
    }

    public void log(String messageString, MessageType type) {
        LanguageClient lc = this.languageClient;
        if (lc == null) {
            return;
        }
        MessageParams message = new MessageParams();
        message.setMessage(messageString);
        message.setType(type);
        lc.logMessage(message);
    }
}

