/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.common.types.xtext.ui.JdtHyperlink;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;

public class JdtHyperlinkFactory {
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private Provider<JdtHyperlink> jdtHyperlinkProvider;

    public boolean canHandle(EObject to) {
        return to instanceof JvmIdentifiableElement && to.eResource() instanceof TypeResource;
    }

    public void createHyperlink(Region region, EObject to, IHyperlinkAcceptor acceptor) {
        JvmIdentifiableElement element = (JvmIdentifiableElement)to;
        IJavaElement javaElement = this.javaElementFinder.findElementFor(element);
        if (javaElement == null) {
            return;
        }
        String label = JavaElementLabels.getElementLabel((IJavaElement)javaElement, (long)JavaElementLabels.ALL_DEFAULT);
        JdtHyperlink result = (JdtHyperlink)((Object)this.jdtHyperlinkProvider.get());
        result.setHyperlinkRegion(region);
        result.setHyperlinkText(label);
        result.setJavaElement(javaElement);
        acceptor.accept((IHyperlink)result);
    }

    public void setJavaElementFinder(IJavaElementFinder javaElementFinder) {
        this.javaElementFinder = javaElementFinder;
    }

    public IJavaElementFinder getJavaElementFinder() {
        return this.javaElementFinder;
    }

    public void setJdtHyperlinkProvider(Provider<JdtHyperlink> jdtHyperlinkProvider) {
        this.jdtHyperlinkProvider = jdtHyperlinkProvider;
    }

    public Provider<JdtHyperlink> getJdtHyperlinkProvider() {
        return this.jdtHyperlinkProvider;
    }
}

