/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.n4js.cli.compiler.N4jscLanguageClient;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.utils.URIUtils;

@Singleton
public class N4jscTestLanguageClient
extends N4jscLanguageClient {
    @Inject
    XWorkspaceManager workspaceManager;
    Multimap<String, Diagnostic> issues = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    Multimap<String, String> errors = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    Multimap<String, String> warnings = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    NavigableMap<Path, Set<File>> transpiledFiles = Collections.synchronizedNavigableMap(new TreeMap());
    Set<URI> deletedFiles = Collections.synchronizedSet(new HashSet());

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        super.publishDiagnostics(diagnostics);
        String uriString = this.issueSerializer.uri(diagnostics.getUri());
        this.issues.removeAll((Object)uriString);
        this.errors.removeAll((Object)uriString);
        this.warnings.removeAll((Object)uriString);
        List issueList = diagnostics.getDiagnostics();
        if (issueList.isEmpty()) {
            return;
        }
        for (Diagnostic diag : issueList) {
            String issueString = this.issueSerializer.diagnostics(diag);
            this.issues.put((Object)uriString, (Object)diag);
            switch (diag.getSeverity()) {
                case Error: {
                    this.errors.put((Object)uriString, (Object)issueString);
                    break;
                }
                case Warning: {
                    this.warnings.put((Object)uriString, (Object)issueString);
                    break;
                }
            }
        }
    }

    public void afterDelete(URI file) {
        this.deletedFiles.add(file);
    }

    public void afterGenerate(URI source, URI generated) {
        String fileName;
        super.afterGenerate(source, generated);
        if (generated.lastSegment().isBlank()) {
            generated = generated.trimSegments(1);
        }
        if (!(fileName = generated.lastSegment()).endsWith("js") && !fileName.endsWith("jsx")) {
            return;
        }
        Path folder = URIUtils.toPath((URI)generated.trimSegments(1));
        URI relGenerated = this.workspaceManager.makeWorkspaceRelative(generated);
        File relFile = URIUtils.toFile((URI)relGenerated);
        this.transpiledFiles.computeIfAbsent(folder, f -> Collections.synchronizedSet(new HashSet())).add(relFile);
        if (!this.transpiledFiles.containsKey(folder)) {
            this.transpiledFiles.put(folder, new HashSet());
        }
        ((Set)this.transpiledFiles.get(folder)).add(relFile);
    }

    public long getDeletionsCount() {
        return this.deletedFiles.size();
    }
}

