/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.n4js.smith.ui.editoroverlay.EditorOverlay;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.Graph;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.n4js.smith.ui.graph.Point;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GraphCanvas
extends Canvas {
    protected final EditorOverlay editorOverlay;
    protected Graph<?> graph = null;
    protected boolean graphNeedsLayout = true;
    protected boolean showAllCrossLinks = false;
    protected final Set<Node> selectedNodes = new HashSet<Node>();
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected float scale = 1.0f;
    protected boolean hawkEye_active = false;
    protected Point hawkEye_target = null;
    protected int hawkEye_oldOffsetX = 0;
    protected int hawkEye_oldOffsetY = 0;
    protected float hawkEye_oldScale = 1.0f;
    protected boolean mousePressed = false;
    protected boolean mouseDragged = false;
    protected int mouseDragStartX;
    protected int mouseDragStartY;
    protected int mouseDragBaseX;
    protected int mouseDragBaseY;
    protected Node hoveredNode = null;
    protected DefaultToolTip toolTip;

    public GraphCanvas(Composite parent, int style, EditorOverlay editorOverlay) {
        super(parent, style);
        this.editorOverlay = editorOverlay;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GraphCanvas.this.doPaint(event.gc, event);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                GraphCanvas.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                GraphCanvas.this.onMouseUp(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                GraphCanvas.this.onMouseWheel(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                GraphCanvas.this.onMouseMove(e);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                GraphCanvas.this.onMouseEnter(e);
            }

            public void mouseExit(MouseEvent e) {
                GraphCanvas.this.onMouseExit(e);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isCtrlAlt(e)) {
                    GraphCanvas.this.setHawkEyeMode(true);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (this.isCtrlAlt(e)) {
                    GraphCanvas.this.setHawkEyeMode(false);
                }
            }

            private final boolean isCtrlAlt(KeyEvent e) {
                return e.keyCode == 262144 && (e.stateMask & 0x10000) != 0 || e.keyCode == 65536 && (e.stateMask & 0x40000) != 0;
            }
        });
        this.toolTip = new DefaultToolTip((Control)this, 0, true);
        this.toolTip.setText("Hello tool tip!");
    }

    public Graph<?> getGraph() {
        return this.graph;
    }

    public void clear() {
        this.setGraph(null);
    }

    public void setGraph(Graph<?> graph) {
        if (graph != this.graph) {
            this.clearSelection();
            if (this.graph == null || graph == null) {
                this.offsetX = 0;
                this.offsetY = 0;
            }
            this.graph = graph;
            this.graphNeedsLayout = true;
            this.redraw();
        }
    }

    public Point screenToGraph(int screenX, int screenY) {
        return new Point((float)(this.offsetX + screenX) / this.scale, (float)(this.offsetY + screenY) / this.scale);
    }

    public void setScrollOffset(int offsetX, int offsetY) {
        if (offsetX != this.offsetX || offsetY != this.offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.redraw();
        }
    }

    public void setScrollOffset(float graphX, float graphY, int screenX, int screenY) {
        int offsX = Math.round(graphX * this.scale - (float)screenX);
        int offsY = Math.round(graphY * this.scale - (float)screenY);
        this.setScrollOffset(offsX, offsY);
    }

    public void zoom(int screenX, int screenY, float deltaScale) {
        if (deltaScale != 0.0f) {
            Point pFix = this.screenToGraph(screenX, screenY);
            this.scale += deltaScale;
            this.setScrollOffset(pFix.x, pFix.y, screenX, screenY);
            this.redraw();
        }
    }

    public void setHawkEyeMode(boolean active) {
        if (active && !this.hawkEye_active && this.graph != null) {
            this.turnOnHawkeyeMode();
        } else if (!active && this.hawkEye_active) {
            this.turnOffHawkeyeMode();
        }
    }

    private void turnOnHawkeyeMode() {
        int border = 5;
        float w = this.getSize().x;
        float h = this.getSize().y;
        Rectangle b = this.graph.getBounds();
        int newOffsetX = 5;
        int newOffsetY = 5;
        float scaleA = (w - 10.0f) / b.width;
        float scaleB = (h - 10.0f) / b.height;
        float newScale = Math.min(scaleA, scaleB);
        if (newScale < 1.0f) {
            this.hawkEye_oldOffsetX = this.offsetX;
            this.hawkEye_oldOffsetY = this.offsetY;
            this.hawkEye_oldScale = this.scale;
            this.offsetX = 5;
            this.offsetY = 5;
            this.scale = newScale;
            this.hawkEye_target = null;
            this.hawkEye_active = true;
            this.redraw();
        }
    }

    private void turnOffHawkeyeMode() {
        if (this.hawkEye_target != null) {
            Point pCenter = this.screenToGraph(Math.round(this.hawkEye_target.x), Math.round(this.hawkEye_target.y));
            this.scale = this.hawkEye_oldScale;
            this.setScrollOffset(pCenter.x, pCenter.y, this.getSize().x / 2, this.getSize().y / 2);
            this.hawkEye_target = null;
        } else {
            this.offsetX = this.hawkEye_oldOffsetX;
            this.offsetY = this.hawkEye_oldOffsetY;
            this.scale = this.hawkEye_oldScale;
        }
        this.hawkEye_active = false;
        this.redraw();
    }

    protected void setHawkEyeTarget(Point screenPos) {
        if (this.hawkEye_active) {
            if (screenPos != null) {
                if (this.hawkEye_target == null || this.hawkEye_target.x != screenPos.x || this.hawkEye_target.y != screenPos.y) {
                    this.hawkEye_target = screenPos;
                    this.redraw();
                }
            } else if (this.hawkEye_target != null) {
                this.hawkEye_target = null;
                this.redraw();
            }
        } else {
            this.hawkEye_target = null;
        }
    }

    public void setShowAllCrossLinks(boolean value) {
        if (value != this.showAllCrossLinks) {
            this.showAllCrossLinks = value;
            this.redraw();
        }
    }

    public Set<Node> getSelectedNodes() {
        return Collections.unmodifiableSet(this.selectedNodes);
    }

    public void setSelectedNodes(Node ... nodes) {
        HashSet<Node> newNodes = new HashSet<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            if (n3 != null) {
                newNodes.add(n3);
            }
            ++n2;
        }
        if (!this.selectedNodes.equals(newNodes)) {
            this.selectedNodes.clear();
            this.selectedNodes.addAll(newNodes);
            this.setSelectedInEditorOverlay(this.selectedNodes);
            this.redraw();
        }
    }

    public void toggleSelection(Node node) {
        if (this.selectedNodes.contains(node)) {
            this.selectedNodes.remove(node);
        } else {
            this.selectedNodes.add(node);
        }
        this.setSelectedInEditorOverlay(this.selectedNodes);
        this.redraw();
    }

    public void clearSelection() {
        if (!this.selectedNodes.isEmpty()) {
            this.selectedNodes.clear();
            this.setSelectedInEditorOverlay(this.selectedNodes);
            this.redraw();
        }
    }

    public Node getNodeAt(int screenX, int screenY) {
        Point p = this.screenToGraph(screenX, screenY);
        Node result = this.graph == null ? null : this.graph.getNodeAt(p.x, p.y);
        return result;
    }

    protected void onMouseEnter(MouseEvent event) {
        if (this.hawkEye_active) {
            this.setHawkEyeTarget(new Point(event.x, event.y));
        }
    }

    protected void onMouseExit(MouseEvent event) {
        this.setHoveredNode(null);
        if (this.hawkEye_active) {
            this.setHawkEyeTarget(null);
        }
    }

    protected void onMouseDown(MouseEvent event) {
        this.mousePressed = true;
        this.mouseDragged = false;
        this.mouseDragStartX = event.x;
        this.mouseDragStartY = event.y;
        this.mouseDragBaseX = this.offsetX;
        this.mouseDragBaseY = this.offsetY;
    }

    protected void onMouseMove(MouseEvent event) {
        if (this.hawkEye_active) {
            this.setHawkEyeTarget(new Point(event.x, event.y));
        }
        Node mNode = this.getNodeAt(event.x, event.y);
        if (!this.mousePressed) {
            this.setHoveredNode(mNode);
        }
        if (this.mousePressed) {
            this.mouseDragged |= Math.abs(event.x - this.mouseDragStartX) > 3;
            this.mouseDragged |= Math.abs(event.y - this.mouseDragStartY) > 3;
            if (this.mouseDragged) {
                this.onMouseDrag(event);
            }
        }
    }

    protected void onMouseDrag(MouseEvent event) {
        int scrollOffsetX = this.mouseDragBaseX - event.x + this.mouseDragStartX;
        int scrollOffsetY = this.mouseDragBaseY - event.y + this.mouseDragStartY;
        this.setScrollOffset(scrollOffsetX, scrollOffsetY);
        this.redraw();
    }

    protected void onMouseUp(MouseEvent event) {
        if (!this.mouseDragged) {
            this.onClick(event);
        }
        this.mousePressed = false;
        this.mouseDragged = false;
        this.mouseDragStartX = 0;
        this.mouseDragStartY = 0;
    }

    protected void onClick(MouseEvent event) {
        boolean shiftPressed;
        Node mNode = this.getNodeAt(event.x, event.y);
        boolean bl = shiftPressed = (event.stateMask & 0x20000) != 0;
        if (!shiftPressed) {
            if (mNode == null) {
                this.clearSelection();
            } else {
                this.setSelectedNodes(mNode);
            }
        } else if (mNode != null) {
            this.toggleSelection(mNode);
        }
    }

    protected void onMouseWheel(MouseEvent event) {
        this.zoom(event.x, event.y, 0.01f * (float)event.count);
    }

    protected void setHoveredNode(Node node) {
        if (node != this.hoveredNode) {
            this.hoveredNode = node;
            if (this.hoveredNode != null && this.hoveredNode.getDescription() != null) {
                this.toolTip.setText(this.hoveredNode.getDescription());
                org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(4, 4);
                this.toolTip.show(point);
            } else {
                this.toolTip.hide();
            }
            this.setHoverInEditorOverlay(this.hoveredNode);
        }
    }

    protected void setHoverInEditorOverlay(Node node) {
        EObject selection = null;
        if (node != null && node.getElement() instanceof EObject) {
            selection = (EObject)node.getElement();
        }
        this.editorOverlay.setHoveredElement(selection);
    }

    protected void setSelectedInEditorOverlay(Set<Node> selectedNodes) {
        LinkedList<EObject> selectedEO = new LinkedList<EObject>();
        for (Node node : selectedNodes) {
            if (node == null || !(node.getElement() instanceof EObject)) continue;
            selectedEO.add((EObject)node.getElement());
        }
        this.editorOverlay.setSelectedElement(selectedEO);
    }

    protected void doPaint(GC gc, PaintEvent event) {
        gc.setBackground(Display.getDefault().getSystemColor(1));
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        if (this.graph == null) {
            return;
        }
        Transform tf = new Transform(gc.getDevice());
        tf.translate((float)(-this.offsetX), (float)(-this.offsetY));
        tf.scale(this.scale, this.scale);
        gc.setTransform(tf);
        if (this.graphNeedsLayout) {
            this.graph.layout(gc);
            this.graphNeedsLayout = false;
        }
        for (Edge e : this.graph.getEdges()) {
            Stream eNodes = e.getNodes().stream();
            boolean paintIt = false;
            paintIt |= !e.isCrossLink();
            if (!(paintIt |= e.isCrossLink() && (this.showAllCrossLinks || eNodes.anyMatch(n -> n == this.hoveredNode || this.selectedNodes.contains(n))))) continue;
            e.paint(gc);
        }
        for (Node n2 : this.graph.getNodes()) {
            n2.paint(gc);
        }
        gc.setForeground(Display.getDefault().getSystemColor(9));
        for (Node sn : this.selectedNodes) {
            float x = sn.getX() - 2.0f;
            float y = sn.getY() - 2.0f;
            float width = sn.getWidth() + 4.0f;
            float height = sn.getHeight() + 4.0f;
            GraphUtils.drawRectangle(gc, x, y, width, height);
        }
        gc.setTransform(null);
        tf.dispose();
        if (this.hawkEye_active && this.hawkEye_target != null) {
            int w = Math.round((float)this.getSize().x / this.hawkEye_oldScale * this.scale);
            int h = Math.round((float)this.getSize().y / this.hawkEye_oldScale * this.scale);
            int x = (int)this.hawkEye_target.x - w / 2;
            int y = (int)this.hawkEye_target.y - h / 2;
            gc.setBackground(Display.getDefault().getSystemColor(9));
            gc.setAlpha(64);
            gc.fillRectangle(x, y, w, h);
            gc.setAlpha(255);
        }
    }
}

