/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

public class CharSequences {
    private static final String DOTS = "...";

    public static <T extends CharSequence> T getMostSimilarCandiate(Iterable<? extends T> candiates, T defautValue, CharSequence similarTo) {
        if (similarTo == null || similarTo.length() == 0) {
            return defautValue;
        }
        Object result = defautValue;
        int rating = 0;
        for (CharSequence candiate : candiates) {
            int r = CharSequences.getSimilarity(candiate, similarTo);
            if (r <= rating) continue;
            rating = r;
            result = candiate;
        }
        return result;
    }

    public static String getPostfix(CharSequence document, int offset, int maxLenght) {
        if (offset + maxLenght > document.length()) {
            return document.subSequence(offset, document.length()).toString();
        }
        return document.subSequence(offset, offset + (maxLenght - DOTS.length())) + DOTS;
    }

    public static String getPrefix(CharSequence document, int offset, int maxLenght) {
        if (offset < maxLenght) {
            return document.subSequence(0, offset).toString();
        }
        return DOTS + document.subSequence(offset - (maxLenght - DOTS.length()), offset);
    }

    public static int getSimilarity(CharSequence s1, CharSequence s2) {
        int result = 0;
        int length = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < length) {
            if (s1.charAt(i) != s2.charAt(i)) break;
            ++result;
            ++i;
        }
        i = 1;
        while (i <= length) {
            if (s1.charAt(s1.length() - i) != s2.charAt(s2.length() - i)) break;
            ++result;
            ++i;
        }
        return result;
    }

    public static boolean isWhitespace(CharSequence seq) {
        int i = 0;
        while (i < seq.length()) {
            if (!Character.isWhitespace(seq.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toSingleLineString(Object seq, int maxLenght) {
        if (seq == null) {
            return null;
        }
        String result = seq.toString().replace("\n", "\\n");
        if (result.length() <= maxLenght) {
            return result;
        }
        return String.valueOf(result.substring(0, maxLenght - DOTS.length())) + DOTS;
    }
}

