/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TypeAccessModifier implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    PRIVATE(1, "private", "private"),
    PROJECT(2, "project", "project"),
    PUBLIC_INTERNAL(3, "publicInternal", "publicInternal"),
    PUBLIC(4, "public", "public");

    public static final int UNDEFINED_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    public static final int PROJECT_VALUE = 2;
    public static final int PUBLIC_INTERNAL_VALUE = 3;
    public static final int PUBLIC_VALUE = 4;
    private static final TypeAccessModifier[] VALUES_ARRAY;
    public static final List<TypeAccessModifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TypeAccessModifier[]{UNDEFINED, PRIVATE, PROJECT, PUBLIC_INTERNAL, PUBLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TypeAccessModifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeAccessModifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeAccessModifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeAccessModifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeAccessModifier get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROJECT;
            }
            case 3: {
                return PUBLIC_INTERNAL;
            }
            case 4: {
                return PUBLIC;
            }
        }
        return null;
    }

    private TypeAccessModifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

