/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;

public class N4JSExternalReferenceChecker {
    private final Logger LOG = Logger.getLogger(N4JSExternalReferenceChecker.class);
    @Inject
    private LazyURIEncoder uriEncoder;

    public boolean isResolvedAndExternal(EObject from, EObject to) {
        if (to == null) {
            return false;
        }
        if (!to.eIsProxy()) {
            if (to.eResource() == null) {
                this.LOG.error((Object)("Reference from " + EcoreUtil.getURI((EObject)from) + " to " + to + " cannot be exported as the target is not contained in a resource."));
                return false;
            }
            return from.eResource() != to.eResource();
        }
        return !this.uriEncoder.isCrossLinkFragment(from.eResource(), ((InternalEObject)to).eProxyURI().fragment());
    }

    public boolean isResolvedAndExternal(Resource resource, EObject to) {
        if (to == null) {
            return false;
        }
        if (!to.eIsProxy()) {
            if (to.eResource() == null) {
                this.LOG.error((Object)"The target is not contained in a resource.");
                return false;
            }
            return resource != to.eResource();
        }
        return !this.uriEncoder.isCrossLinkFragment(resource, ((InternalEObject)to).eProxyURI().fragment());
    }
}

