/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.utils;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.util.ExtendedClassesIterable;
import org.eclipse.n4js.utils.N4JSLanguageUtils;

public class MemberRedefinitionUtils {
    public static Iterable<TMember> getMetatypeCompatibleOverriddenMembers(TMember overridingMember, Iterable<TMember> overriddenMembers) {
        return Iterables.filter(overriddenMembers, member -> MemberRedefinitionUtils.isMetaTypeCompatible(overridingMember, member));
    }

    public static boolean isMetaTypeCompatible(TMember m1, TMember m2) {
        boolean result;
        boolean bl = result = m1.getMemberType() == m2.getMemberType();
        if (!result) {
            switch (m1.getMemberType()) {
                case METHOD: {
                    break;
                }
                case FIELD: {
                    result = m2.getMemberType() == MemberType.GETTER || m2.getMemberType() == MemberType.SETTER;
                    break;
                }
                case GETTER: 
                case SETTER: {
                    result = m2.getMemberType() == MemberType.FIELD;
                }
            }
        }
        return result;
    }

    public static String getRedefinitionVerb(Iterable<TMember> redefinedMembers, TClassifier redefiningClassifier) {
        Set overriddenClassifierTypes = StreamSupport.stream(redefinedMembers.spliterator(), false).map(member -> member.getContainingType().eClass()).collect(Collectors.toSet());
        boolean isOverridingSuperclassMember = overriddenClassifierTypes.contains(TypesPackage.eINSTANCE.getTClass());
        boolean isOverridingObjectPrototypeMembers = overriddenClassifierTypes.contains(TypesPackage.eINSTANCE.getTObjectPrototype());
        boolean isImplementing = overriddenClassifierTypes.contains(TypesPackage.eINSTANCE.getTInterface());
        boolean isOverriding = isOverridingSuperclassMember || isOverridingObjectPrototypeMembers;
        boolean isInterfaceExtendingInterface = redefiningClassifier instanceof TInterface;
        if (isOverriding && isImplementing) {
            return "overriding/implementing";
        }
        if (isOverriding || isInterfaceExtendingInterface) {
            return "overriding";
        }
        if (isImplementing) {
            return "implementing";
        }
        return "redefining";
    }

    public static TClass getFilledClass(N4ClassDefinition staticPolyfillDefinition) {
        if (!(staticPolyfillDefinition.getDefinedType() instanceof TClassifier)) {
            return null;
        }
        TClassifier classifier = (TClassifier)staticPolyfillDefinition.getDefinedType();
        if (!classifier.isStaticPolyfill()) {
            return null;
        }
        ParameterizedTypeRef superClassTypeRef = (ParameterizedTypeRef)Iterables.getFirst((Iterable)classifier.getSuperClassifierRefs(), null);
        if (superClassTypeRef == null) {
            return null;
        }
        Type superClassType = superClassTypeRef.getDeclaredType();
        if (superClassType instanceof TClass && ((TClass)superClassType).getContainingModule().isStaticPolyfillAware()) {
            return (TClass)superClassType;
        }
        return null;
    }

    public static final Type findThisContextForConstructor(Type baseContext, TMethod ctor) {
        ContainerType ctorContainer = ctor.getContainingType();
        if (!(baseContext instanceof TClass) || !(ctorContainer instanceof TClass)) {
            return ctorContainer;
        }
        TClass ctorContainerCasted = (TClass)ctorContainer;
        TClass baseContextCasted = (TClass)baseContext;
        if (N4JSLanguageUtils.hasCovariantConstructor((TClassifier)ctorContainerCasted)) {
            return ctorContainerCasted;
        }
        ArrayList<TClass> superClassesUpToCtorContainer = new ArrayList<TClass>();
        for (TClass superClass : new ExtendedClassesIterable(baseContextCasted)) {
            if (superClass == ctorContainerCasted) break;
            superClassesUpToCtorContainer.add(superClass);
        }
        int i = superClassesUpToCtorContainer.size() - 1;
        while (i >= 0) {
            TClass superClass = (TClass)superClassesUpToCtorContainer.get(i);
            if (N4JSLanguageUtils.hasCovariantConstructor((TClassifier)superClass)) {
                return superClass;
            }
            --i;
        }
        return baseContext;
    }

    private MemberRedefinitionUtils() {
    }
}

