/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc.tags;

import org.eclipse.n4js.jsdoc.DescriptionParser;
import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocCompletionHint;
import org.eclipse.n4js.jsdoc.dom.DomFactory;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc.dom.Tag;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.tags.AbstractLineTagDefinition;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TMember;

public abstract class LineTagWithFullElementReference
extends AbstractLineTagDefinition {
    public static final String REF = "REF";

    public LineTagWithFullElementReference(String title) {
        this.setTitles(title);
    }

    @Override
    public Tag parse(TagTitle title, JSDocCharScanner scanner, DescriptionParser descriptionParser) {
        FullMemberReference ref = this.parseReference(scanner, scanner.length());
        LineTag tag = this.createLineTag(title);
        this.addValue((Tag)tag, REF, ref);
        return tag;
    }

    @Override
    public JSDocCompletionHint completionHint(JSDocCharScanner scanner) {
        int start = scanner.offset();
        scanner.rewindToWS();
        scanner.next();
        FullMemberReference ref = this.parseReference(scanner, start);
        String prefix = ref.toString();
        char lastChar = scanner.charAt(start);
        if (!Character.isWhitespace(lastChar) && !prefix.endsWith(Character.toString(lastChar))) {
            prefix = String.valueOf(prefix) + lastChar;
        }
        return new JSDocCompletionHint(JSDocCompletionHint.CompletionKind.FQMEMBER, prefix, ref);
    }

    private FullMemberReference parseReference(JSDocCharScanner scanner, int maxOffset) {
        scanner.skipWS();
        int start = scanner.offset();
        StringBuilder[] segments = new StringBuilder[3];
        int i = 0;
        while (i < segments.length) {
            segments[i] = new StringBuilder();
            ++i;
        }
        int segment = 0;
        boolean foundStatic = false;
        int prev = 0;
        while (scanner.offset() <= maxOffset && scanner.hasNext() && !Character.isWhitespace(scanner.peek())) {
            char c = scanner.next();
            if ((c == '.' || c == '#') && (segment != 2 || prev != 46 && prev != 35)) {
                if (++segment > 2) break;
                if (c == '#') {
                    if (segment != 2) break;
                    foundStatic = true;
                }
            } else {
                segments[segment].append(c);
            }
            prev = c;
        }
        FullMemberReference ref = DomFactory.eINSTANCE.createFullMemberReference();
        ref.setRange(start, scanner.offset());
        ref.setModuleName(segments[0].toString());
        ref.setTypeName(segments[1].toString());
        ref.setMemberName(segments[2].toString());
        ref.setStaticMember(foundStatic);
        return ref;
    }

    public static FullMemberReference createReferenceFromType(TMember member) {
        FullMemberReference ref = DomFactory.eINSTANCE.createFullMemberReference();
        ContainerType type = member.getContainingType();
        ref.setRange(-1, -1);
        ref.setModuleName(type.getContainingModule().getModuleSpecifier());
        ref.setTypeName(type.getName());
        ref.setStaticMember(member.isStatic());
        ref.setMemberName(member.getName());
        return ref;
    }
}

