/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.n4js.cli.N4JSCmdLineParser;
import org.eclipse.n4js.cli.N4jscException;
import org.eclipse.n4js.cli.N4jscExitCode;
import org.eclipse.n4js.cli.N4jscGoal;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;

public class N4jscOptions {
    public static final String N4JSC_PERFORMANCE_REPORT_ENV = "N4JSC_PERFORMANCE_REPORT";
    public static final String MARKER_RUNNER_OUPTUT = "======= =======";
    public static final String USAGE = "Usage: n4jsc [GOAL] DIR [OPTION(s)]";
    protected final Options options = new Options();
    protected final N4JSCmdLineParser parser = new N4JSCmdLineParser(this.options);

    public N4jscOptions() {
        this.parser.getProperties().withUsageWidth(130);
    }

    public void read(String ... args) throws N4jscException {
        try {
            this.parser.definedOptions.clear();
            this.parser.parseArgument(args);
            this.integrateEnvironment();
            this.interpretAndAdjust();
        }
        catch (CmdLineException e) {
            throw new N4jscException(N4jscExitCode.CMD_LINE_PARSE_INVALID, (Throwable)e);
        }
    }

    private void integrateEnvironment() {
        Map<String, N4JSCmdLineParser.ParsedOption> opts = this.getDefinedOptions();
        if (!opts.containsKey("--performanceReport") && System.getenv(N4JSC_PERFORMANCE_REPORT_ENV) != null) {
            File performanceReportFile;
            String rawPath = System.getenv(N4JSC_PERFORMANCE_REPORT_ENV);
            this.options.performanceReport = performanceReportFile = new File(rawPath);
        }
    }

    private void interpretAndAdjust() {
        if (this.options.help) {
            this.options.goal = N4jscGoal.help;
            this.options.help = false;
        }
        if (this.options.version) {
            this.options.goal = N4jscGoal.version;
            this.options.version = false;
        }
        this.options.dirs = this.options.dirs.stream().map(f -> {
            try {
                File canonicalFile = f.getCanonicalFile();
                if ("package.json".equals(canonicalFile.getName())) {
                    return canonicalFile.getParentFile();
                }
                return canonicalFile;
            }
            catch (IOException e) {
                return null;
            }
        }).filter(f -> f != null).collect(Collectors.toList());
    }

    public Map<String, N4JSCmdLineParser.ParsedOption> getDefinedOptions() {
        return this.parser.definedOptions;
    }

    public N4jscGoal getGoal() {
        return this.options.goal;
    }

    public List<File> getDirs() {
        return this.options.dirs;
    }

    public File getDir() {
        List<File> dirs = this.getDirs();
        if (dirs == null || dirs.isEmpty()) {
            return null;
        }
        return dirs.get(0);
    }

    public boolean isShowSetup() {
        return this.options.showSetup;
    }

    public boolean isVerbose() {
        return this.options.verbose;
    }

    public boolean isLog() {
        return this.options.log;
    }

    public boolean isNoTests() {
        return this.options.noTests;
    }

    public boolean isTestOnly() {
        return this.options.testOnly;
    }

    public boolean isClean() {
        return this.options.clean;
    }

    public boolean isNoPersist() {
        return this.options.noPersist;
    }

    public String getLogFile() {
        return this.options.logFile;
    }

    public File getTestCatalog() {
        return this.options.testCatalog;
    }

    public int getMaxErrs() {
        return this.options.maxErrs;
    }

    public int getMaxWarns() {
        return this.options.maxWarns;
    }

    public File getPerformanceReport() {
        return this.options.performanceReport;
    }

    public String getPerformanceKey() {
        return this.options.performanceKey;
    }

    public int getPort() {
        return this.options.port;
    }

    public boolean isStdio() {
        return this.options.stdio;
    }

    public boolean isDefinedPerformanceOption() {
        Map<String, N4JSCmdLineParser.ParsedOption> opts = this.getDefinedOptions();
        return opts.containsKey("--performanceKey") || opts.containsKey("--performanceReport");
    }

    public void printUsage(PrintStream out) {
        out.println(USAGE);
        N4JSCmdLineParser parserWithDefault = new N4JSCmdLineParser(new Options());
        Locale curLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en"));
        parserWithDefault.printUsage(out);
        Locale.setDefault(curLocale);
    }

    public String toSettingsString() {
        String s = "N4jsc.options=";
        s = String.valueOf(s) + "\n  goal=" + (Object)((Object)this.getGoal());
        s = String.valueOf(s) + "\n  showSetup=" + this.options.showSetup;
        s = String.valueOf(s) + "\n  verbose=" + this.options.verbose;
        s = String.valueOf(s) + "\n  maxErrs=" + this.options.maxErrs;
        s = String.valueOf(s) + "\n  maxWarns=" + this.options.maxWarns;
        s = String.valueOf(s) + "\n  testCatalogFile=" + this.options.testCatalog;
        s = String.valueOf(s) + "\n  testOnly=" + this.options.testOnly;
        s = String.valueOf(s) + "\n  noTests=" + this.options.noTests;
        s = String.valueOf(s) + "\n  port=" + this.options.port;
        s = String.valueOf(s) + "\n  srcFiles=" + this.options.dirs.stream().map(f -> f.getAbsolutePath()).reduce((a, b) -> String.valueOf(a) + ", " + b);
        s = String.valueOf(s) + "\n  Current execution directory=" + new File(".").getAbsolutePath();
        return s;
    }

    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getGoal().name());
        for (N4JSCmdLineParser.ParsedOption po : this.getDefinedOptions().values()) {
            NamedOptionDef od = po.optionDef;
            String value = po.givenValue;
            args.add(od.name());
            if (value == null) continue;
            if (value.contains(" ")) {
                value = "\"" + value + "\"";
            }
            args.add(value);
        }
        args.addAll(this.getDirs().stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()));
        return args;
    }

    public String toCallString() {
        String s = "java -jar n4jsc.jar";
        s = String.valueOf(s) + " " + String.join((CharSequence)" ", this.toArgs());
        return s;
    }

    public Map<String, GoalRequirements> getOptionNameToGoalRequirementMap() {
        Field[] fields;
        HashMap<String, GoalRequirements> nameFieldMap = new HashMap<String, GoalRequirements>();
        Field[] fieldArray = fields = this.options.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Option option = field.getDeclaredAnnotation(Option.class);
            GoalRequirements goalRequirements = field.getDeclaredAnnotation(GoalRequirements.class);
            if (field.canAccess(this.options) && option != null && goalRequirements != null) {
                nameFieldMap.put(option.name(), goalRequirements);
            }
            ++n2;
        }
        return nameFieldMap;
    }

    public String toString() {
        return this.toCallString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface GoalRequirements {
        public N4jscGoal[] goals();
    }

    static class Options {
        @Option(name="--help", aliases={"-h"}, usage="prints help and exits", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        boolean help = false;
        @Option(name="--version", aliases={"-v"}, usage="prints version and exits", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        boolean version = false;
        @Option(name="--showSetup", usage="prints n4jsc setup", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        boolean showSetup = false;
        @Option(name="--verbose", usage="enables verbose output", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        boolean verbose = false;
        @Option(name="--log", hidden=true, usage="", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        boolean log = false;
        @Option(name="--logfile", hidden=true, usage="specifies the log file name", handler=N4JSCmdLineParser.N4JSStringOptionHandler.class)
        String logFile = "n4jsc.log";
        @Option(name="--testCatalog", aliases={"-tc"}, usage="[compile] generates a test catalog file to the given location. The test catalog lists all available tests among the compiled sources. Existing test catalog files will be replaced.", handler=N4JSCmdLineParser.N4JSFileOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        File testCatalog;
        @Option(name="--noTests", forbids={"--testOnly"}, usage="[compile] don't process test folders", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        boolean noTests = false;
        @Option(name="--testOnly", forbids={"--noTests"}, usage="[compile] only transpile contents of test folders", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        boolean testOnly = false;
        @Option(name="--maxErrs", usage="[compile] set the maximum number of errors to print", handler=N4JSCmdLineParser.N4JSIntOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        int maxErrs = 0;
        @Option(name="--maxWarns", usage="[compile] set the maximum number of warnings to print", handler=N4JSCmdLineParser.N4JSIntOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        int maxWarns = 0;
        @Option(name="--clean", aliases={"-c"}, usage="[compile|lsp] output folders are cleaned at start.", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile, N4jscGoal.lsp})
        boolean clean = false;
        @Option(name="--noPersist", aliases={"-np"}, usage="[compile|lsp] disable persisting of type index to disk.", handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile, N4jscGoal.lsp})
        boolean noPersist = false;
        @Option(name="--performanceReport", aliases={"-pr"}, hidden=true, usage="[compile] enables performance data collection and specifies the path and name of the performance report. A date/time stamp will appended to the file name. If the file name ends in \".csv\", CSV file format will be emitted; otherwise a human-readable format is used.", handler=N4JSCmdLineParser.N4JSFileOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        File performanceReport = new File("performance-report.txt");
        @Option(name="--performanceKey", aliases={"-pk"}, hidden=true, usage="[compile] enables performance data collection and specifies the key of the data collector whose performance data will be saved in the performance report. An asterisk may be used to emit data of all root data collectors (not supported for CSV output).", handler=N4JSCmdLineParser.N4JSStringOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.compile})
        String performanceKey = N4JSDataCollectors.dcBuild.getId();
        @Option(name="--port", aliases={"-p"}, usage="[lsp] set the port of the lsp server", handler=N4JSCmdLineParser.N4JSIntOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.lsp})
        int port = 5007;
        @Option(name="--stdio", usage="[lsp] uses stdin/stdout for communication instead of sockets", forbids={"--port"}, handler=N4JSCmdLineParser.N4JSBooleanOptionHandler.class)
        @GoalRequirements(goals={N4jscGoal.lsp})
        boolean stdio = false;
        @Argument(metaVar="GOAL", multiValued=false, index=0, required=false, usage="Goals are:\n\t compile  Compiles src folders\n\t clean    Cleans output folders and type index\n\t lsp      Starts LSP server\n\t watch    Starts compiler daemon that watches the given directory\n\t api      Generates API documentation from n4js files\n\t", handler=N4jscGoal.N4jscGoalOptionHandler.class)
        N4jscGoal goal = N4jscGoal.compile;
        @Argument(metaVar="DIR", multiValued=true, index=1, required=false, usage="name of n4js project or workspace directory")
        List<File> dirs = new ArrayList<File>();

        Options() {
        }
    }
}

