/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.example;

import com.google.inject.Inject;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.ui.wizard.ExampleInstallerWizard;
import org.eclipse.n4js.ui.wizard.utils.WizardHelper;

public class N4JSTasksExampleWizard
extends ExampleInstallerWizard {
    public static final String ID = N4JSTasksExampleWizard.class.getName();
    @Inject
    private WizardHelper wizardHelper;

    public boolean performFinish() {
        if (super.performFinish()) {
            List<IProject> projects = this.getProjectDescriptors().stream().map(AbstractExampleInstallerWizard.ProjectDescriptor::getProject).collect(Collectors.toList());
            this.wizardHelper.runNpmInstallInWizard(this.getContainer(), projects);
            return true;
        }
        return false;
    }

    protected void installExample(IProgressMonitor progressMonitor) throws Exception {
        super.installExample(progressMonitor);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceFolder = workspace.getRoot().getLocation().toFile().getAbsoluteFile();
        for (AbstractExampleInstallerWizard.ProjectDescriptor pd : this.getProjectDescriptors()) {
            File projectFolder = new File(workspaceFolder, pd.getName());
            File packagesFolder = new File(projectFolder, "packages");
            File[] fileArray = packagesFolder.listFiles(File::isDirectory);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File memberProject = fileArray[n2];
                N4JSTasksExampleWizard.importProject(workspace, memberProject, progressMonitor);
                ++n2;
            }
        }
    }

    private static void importProject(IWorkspace workspace, File rootFolder, IProgressMonitor progressMonitor) throws CoreException {
        Path path = new Path(new File(rootFolder, ".project").getAbsolutePath());
        IProjectDescription desc = workspace.loadProjectDescription((IPath)path);
        IProject project = workspace.getRoot().getProject(desc.getName());
        project.create(desc, progressMonitor);
        project.open(progressMonitor);
    }
}

