/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.HlcExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.UriExtensions;

@ImplementedBy(value=HlcExternalLibraryWorkspace.class)
public abstract class ExternalLibraryWorkspace
extends InternalN4JSWorkspace<FileURI> {
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;
    @Inject
    private UriExtensions uriExtensions;

    @Override
    public FileURI fromURI(URI uri) {
        if (!uri.isFile() || uri.isRelative()) {
            return null;
        }
        return new FileURI(this.uriExtensions.withEmptyAuthority(uri));
    }

    public abstract RegisterResult registerProjects(IProgressMonitor var1, Set<FileURI> var2);

    public abstract RegisterResult deregisterProjects(IProgressMonitor var1, Set<FileURI> var2);

    public abstract RegisterResult deregisterAllProjects(IProgressMonitor var1);

    public abstract void scheduleWorkspaceProjects(IProgressMonitor var1, Set<SafeURI<?>> var2);

    public abstract Collection<N4JSExternalProject> getProjects();

    public abstract Map<N4JSProjectName, VersionNumber> getProjectNameVersionMap();

    public abstract List<Pair<FileURI, ProjectDescription>> getProjectsIncludingUnnecessary();

    public abstract List<Pair<FileURI, ProjectDescription>> computeProjectsIncludingUnnecessary();

    public abstract List<N4JSExternalProject> getProjectsForName(N4JSProjectName var1);

    public abstract Collection<N4JSExternalProject> getProjectsIn(FileURI var1);

    public abstract Collection<N4JSExternalProject> getProjectsIn(Collection<FileURI> var1);

    public abstract N4JSExternalProject getProject(N4JSProjectName var1);

    public abstract N4JSExternalProject getProject(FileURI var1);

    @Override
    public FileURI getProjectLocation(N4JSProjectName name) {
        return this.getProject(name).getSafeLocation();
    }

    public abstract void updateState();

    public FileURI getRootLocationForResourceOrInfer(FileURI nestedLocation) {
        LinkedHashSet<FileURI> allRootLocations = new LinkedHashSet<FileURI>();
        allRootLocations.addAll(this.externalLibraryPreferenceStore.getLocations());
        FileURI rootLocation = ExternalLibraryWorkspace.getRootLocationForResource(allRootLocations, nestedLocation);
        if (rootLocation == null) {
            do {
                String name;
                if (!"node_modules".equals(name = nestedLocation.getName())) continue;
                return nestedLocation;
            } while ((nestedLocation = (FileURI)nestedLocation.getParent()) != null);
            return null;
        }
        return rootLocation;
    }

    public FileURI getRootLocationForResource(FileURI nestedLocation) {
        return ExternalLibraryWorkspace.getRootLocationForResource(this.externalLibraryPreferenceStore.getLocations(), nestedLocation);
    }

    public static final FileURI getRootLocationForResource(Collection<FileURI> rootLocations, SafeURI<?> nestedLocation) {
        if (nestedLocation == null || nestedLocation.isEmpty() || !nestedLocation.exists()) {
            return null;
        }
        TreeMap<String, FileURI> rootLocationMap = new TreeMap<String, FileURI>();
        for (FileURI loc : rootLocations) {
            String locStr = loc.toString();
            rootLocationMap.put(locStr, loc);
        }
        String nestedLocStr = nestedLocation.toString();
        String rootLocStr = rootLocationMap.floorKey(nestedLocStr);
        if (rootLocStr != null && nestedLocStr.startsWith(rootLocStr)) {
            return (FileURI)rootLocationMap.get(rootLocStr);
        }
        return null;
    }

    public abstract boolean isNecessary(SafeURI<?> var1);

    public static class RegisterResult {
        public final Set<FileURI> externalProjectsDone;
        public final Set<SafeURI<?>> affectedWorkspaceProjects;
        public final Set<FileURI> wipedProjects;

        RegisterResult() {
            this.externalProjectsDone = RegisterResult.freeze(null);
            this.affectedWorkspaceProjects = RegisterResult.freeze(null);
            this.wipedProjects = RegisterResult.freeze(null);
        }

        public RegisterResult(Collection<FileURI> extPrjsDone, Collection<? extends SafeURI<?>> wsPrjsAffected) {
            this(extPrjsDone, wsPrjsAffected, null);
        }

        public RegisterResult(Collection<FileURI> extPrjsDone, Collection<? extends SafeURI<?>> wsPrjsAffected, Collection<FileURI> prjsWiped) {
            this.externalProjectsDone = RegisterResult.freeze(extPrjsDone);
            this.affectedWorkspaceProjects = RegisterResult.freeze(wsPrjsAffected);
            this.wipedProjects = RegisterResult.freeze(prjsWiped);
        }

        private static <E extends SafeURI<?>> Set<E> freeze(Collection<? extends E> prjs) {
            if (prjs == null) {
                return Collections.unmodifiableSet(Collections.emptySet());
            }
            return Collections.unmodifiableSet(new HashSet<E>(prjs));
        }
    }
}

