/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.typeRefs.util.TypeRefsSwitch;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

final class SubstTypeVariablesJudgment
extends AbstractJudgment {
    SubstTypeVariablesJudgment() {
    }

    public TypeArgument apply(RuleEnvironment G, TypeArgument typeArg, boolean captureContainedWildcards, boolean captureUponSubstitution) {
        if (typeArg == null) {
            return null;
        }
        SubstTypeVariablesSwitch theSwitch = new SubstTypeVariablesSwitch(G, captureContainedWildcards, captureUponSubstitution);
        TypeArgument result = (TypeArgument)theSwitch.doSwitch((EObject)typeArg);
        if (result == null) {
            String stringRep = typeArg.getTypeRefAsString();
            throw new IllegalArgumentException("null return value in substTypeVariables judgment for type argument: " + stringRep);
        }
        return result;
    }

    private final class SubstTypeVariablesSwitch
    extends TypeRefsSwitch<TypeArgument> {
        private final RuleEnvironment G;
        private final boolean captureContainedWildcards;
        private final boolean captureUponSubstitution;

        public SubstTypeVariablesSwitch(RuleEnvironment G, boolean captureContainedWildcards, boolean captureUponSubstitution) {
            this.G = G;
            this.captureContainedWildcards = captureContainedWildcards;
            this.captureUponSubstitution = captureUponSubstitution;
        }

        private Wildcard substTypeVariables(RuleEnvironment G2, Wildcard wildcard, boolean captureContainedWildcardsNEW) {
            return (Wildcard)this.substTypeVariables(G2, (TypeArgument)wildcard, captureContainedWildcardsNEW);
        }

        private TypeRef substTypeVariables(RuleEnvironment G2, TypeRef typeRef, boolean captureContainedWildcardsNEW) {
            return (TypeRef)this.substTypeVariables(G2, (TypeArgument)typeRef, captureContainedWildcardsNEW);
        }

        private TypeArgument substTypeVariables(RuleEnvironment G2, TypeArgument typeArg, boolean captureContainedWildcardsNEW) {
            if (G2 == this.G && captureContainedWildcardsNEW == this.captureContainedWildcards) {
                return (TypeArgument)this.doSwitch((EObject)typeArg);
            }
            return SubstTypeVariablesJudgment.this.apply(G2, typeArg, captureContainedWildcardsNEW, this.captureUponSubstitution);
        }

        public TypeArgument caseTypeArgument(TypeArgument typeArg) {
            return typeArg;
        }

        public TypeArgument caseWildcard(Wildcard wildcard) {
            wildcard = this.internalSubstTypeVariablesInWildcard(wildcard);
            if (this.captureContainedWildcards) {
                return TypeUtils.captureWildcard((Wildcard)wildcard);
            }
            return wildcard;
        }

        public TypeArgument caseExistentialTypeRef(ExistentialTypeRef existentialTypeRef) {
            Wildcard w = existentialTypeRef.getWildcard();
            Wildcard wSubst = this.internalSubstTypeVariablesInWildcard(w);
            if (wSubst != w) {
                ExistentialTypeRef etfCpy = (ExistentialTypeRef)TypeUtils.copy((EObject)existentialTypeRef);
                etfCpy.setWildcard((Wildcard)TypeUtils.copyIfContained((EObject)wSubst));
                existentialTypeRef = etfCpy;
            }
            if (this.captureContainedWildcards && existentialTypeRef.isReopened()) {
                existentialTypeRef = TypeUtils.captureWildcard((Wildcard)existentialTypeRef.getWildcard());
            }
            return existentialTypeRef;
        }

        private Wildcard internalSubstTypeVariablesInWildcard(Wildcard wildcard) {
            TypeRef lbSubst;
            RuleEnvironment G2;
            TypeRef ub;
            if (wildcard.isImplicitUpperBoundInEffect()) {
                boolean isGuarded;
                Pair guardKey = Pair.of((Object)"substTypeVars_implicitUpperBoundOfWildcard", (Object)wildcard);
                boolean bl = isGuarded = this.G.get(guardKey) != null;
                if (!isGuarded) {
                    ub = wildcard.getDeclaredOrImplicitUpperBound();
                    G2 = RuleEnvironmentExtensions.wrap(this.G);
                    G2.put(guardKey, Boolean.TRUE);
                } else {
                    ub = null;
                    G2 = this.G;
                }
            } else {
                ub = wildcard.getDeclaredOrImplicitUpperBound();
                G2 = this.G;
            }
            TypeRef lb = wildcard.getDeclaredLowerBound();
            TypeRef ubSubst = ub != null ? this.substTypeVariables(G2, ub, false) : null;
            TypeRef typeRef = lbSubst = lb != null ? this.substTypeVariables(G2, lb, false) : null;
            if (ubSubst != ub || lbSubst != lb) {
                Wildcard cpy = (Wildcard)TypeUtils.copy((EObject)wildcard);
                cpy.setDeclaredUpperBound((TypeRef)TypeUtils.copyIfContained((EObject)ubSubst));
                cpy.setDeclaredLowerBound((TypeRef)TypeUtils.copyIfContained((EObject)lbSubst));
                wildcard = cpy;
            }
            return wildcard;
        }

        public TypeArgument caseThisTypeRef(ThisTypeRef thisTypeRef) {
            TypeRef boundRefFromEnvUncasted = RuleEnvironmentExtensions.getThisType(this.G);
            if (boundRefFromEnvUncasted instanceof BoundThisTypeRef) {
                BoundThisTypeRef boundRefFromEnv = (BoundThisTypeRef)boundRefFromEnvUncasted;
                BoundThisTypeRef boundRef = TypeUtils.createBoundThisTypeRef((ParameterizedTypeRef)boundRefFromEnv.getActualThisTypeRef());
                boundRef.setTypingStrategy(thisTypeRef.getTypingStrategy());
                TypeUtils.copyTypeModifiers((TypeRef)boundRef, (TypeRef)thisTypeRef);
                return boundRef;
            }
            return thisTypeRef;
        }

        public TypeArgument caseThisTypeRefStructural(ThisTypeRefStructural thisTypeRef) {
            TypeRef boundRefFromEnvUncasted = RuleEnvironmentExtensions.getThisType(this.G);
            if (boundRefFromEnvUncasted instanceof BoundThisTypeRef) {
                BoundThisTypeRef boundRefFromEnv = (BoundThisTypeRef)boundRefFromEnvUncasted;
                BoundThisTypeRef boundRef = TypeUtils.createBoundThisTypeRefStructural((ParameterizedTypeRef)boundRefFromEnv.getActualThisTypeRef(), (ThisTypeRefStructural)thisTypeRef);
                TypeUtils.copyTypeModifiers((TypeRef)boundRef, (TypeRef)thisTypeRef);
                return boundRef;
            }
            return thisTypeRef;
        }

        public TypeArgument caseFunctionTypeRef(FunctionTypeRef typeRef) {
            return this.caseFunctionTypeExprOrRef((FunctionTypeExprOrRef)typeRef);
        }

        public TypeArgument caseFunctionTypeExprOrRef(FunctionTypeExprOrRef F) {
            boolean haveReplacement = false;
            ArrayList<TypeVariable> resultUnboundTypeVars = new ArrayList<TypeVariable>();
            ArrayList<TypeRef> resultUnboundTypeVarsUpperBounds = new ArrayList<TypeRef>();
            for (TypeVariable currTV : F.getTypeVars()) {
                if (this.G.get(currTV) != null) continue;
                int idxOfCurrTV = resultUnboundTypeVars.size();
                resultUnboundTypeVars.add(currTV);
                haveReplacement |= this.performSubstitutionOnUpperBounds(F, currTV, idxOfCurrTV, resultUnboundTypeVarsUpperBounds);
            }
            haveReplacement |= resultUnboundTypeVars.size() < F.getTypeVars().size();
            TypeRef declaredThisType = F.getDeclaredThisType();
            TypeRef resultDeclaredThisType = declaredThisType != null ? this.substTypeVariables(this.G, declaredThisType, false) : null;
            haveReplacement |= resultDeclaredThisType != declaredThisType;
            TypeRef returnTypeRef = F.getReturnTypeRef();
            TypeRef resultReturnTypeRef = returnTypeRef != null ? this.substTypeVariables(this.G, returnTypeRef, false) : null;
            haveReplacement |= resultReturnTypeRef != returnTypeRef;
            EList fpars = F.getFpars();
            ArrayList<TFormalParameter> resultFpars = new ArrayList<TFormalParameter>(fpars.size());
            for (TFormalParameter oldPar : fpars) {
                if (oldPar == null) {
                    resultFpars.add(null);
                    continue;
                }
                TFormalParameter newPar = TypesFactory.eINSTANCE.createTFormalParameter();
                newPar.setName(oldPar.getName());
                newPar.setVariadic(oldPar.isVariadic());
                newPar.setHasInitializerAssignment(oldPar.isHasInitializerAssignment());
                TypeRef oldParTypeRef = oldPar.getTypeRef();
                if (oldParTypeRef != null) {
                    TypeRef newParTypeRef = this.substTypeVariables(this.G, oldParTypeRef, false);
                    newPar.setTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)newParTypeRef));
                    haveReplacement |= newParTypeRef != oldParTypeRef;
                }
                resultFpars.add(newPar);
            }
            if (haveReplacement) {
                FunctionTypeExpression result = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
                result.setBinding(true);
                result.setDeclaredType(F.getFunctionType());
                result.getUnboundTypeVars().addAll(resultUnboundTypeVars);
                result.getUnboundTypeVarsUpperBounds().addAll(TypeUtils.copyAllIfContained(resultUnboundTypeVarsUpperBounds));
                result.setDeclaredThisType((TypeRef)TypeUtils.copyIfContained((EObject)resultDeclaredThisType));
                result.setReturnTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)resultReturnTypeRef));
                result.setReturnValueMarkedOptional(F.isReturnValueOptional());
                result.getFpars().addAll(resultFpars);
                TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)F);
                return result;
            }
            return F;
        }

        private boolean performSubstitutionOnUpperBounds(FunctionTypeExprOrRef F, TypeVariable currTV, int idxOfCurrTV, List<TypeRef> resultUnboundTypeVarsUpperBounds) {
            TypeRef oldUB;
            TypeRef newUB;
            TypeRef currTV_declUB = currTV.getDeclaredUpperBound();
            if (currTV_declUB != null && (newUB = this.substTypeVariables(this.G, oldUB = F.getTypeVarUpperBound(currTV), false)) != currTV_declUB) {
                while (resultUnboundTypeVarsUpperBounds.size() < idxOfCurrTV) {
                    resultUnboundTypeVarsUpperBounds.add((TypeRef)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
                }
                resultUnboundTypeVarsUpperBounds.add(newUB);
                return true;
            }
            return false;
        }

        public TypeArgument caseComposedTypeRef(ComposedTypeRef typeRef) {
            boolean haveReplacement = false;
            ArrayList substTypeRefs = CollectionLiterals.newArrayList();
            for (TypeRef currTypeRef : typeRef.getTypeRefs()) {
                TypeRef substTypeRef = this.substTypeVariables(this.G, currTypeRef, this.captureContainedWildcards);
                substTypeRefs.add(substTypeRef);
                haveReplacement |= substTypeRef != currTypeRef;
            }
            if (haveReplacement) {
                ComposedTypeRef result = (ComposedTypeRef)TypeUtils.copy((EObject)typeRef);
                result.getTypeRefs().clear();
                result.getTypeRefs().addAll(TypeUtils.copyAll((Collection)substTypeRefs));
                return result;
            }
            return typeRef;
        }

        public TypeArgument caseTypeTypeRef(TypeTypeRef typeRef) {
            TypeArgument tResult;
            TypeArgument typeArg = typeRef.getTypeArg();
            if (typeArg != null && (tResult = this.substTypeVariables(this.G, typeArg, this.captureContainedWildcards)) != typeArg) {
                TypeTypeRef result = (TypeTypeRef)TypeUtils.copy((EObject)typeRef);
                result.setTypeArg(tResult);
                return result;
            }
            return typeRef;
        }

        public TypeArgument caseParameterizedTypeRef(ParameterizedTypeRef typeRef) {
            ParameterizedTypeRef result = typeRef;
            Type typeRefDeclType = typeRef.getDeclaredType();
            if (typeRefDeclType instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)typeRefDeclType;
                Object replacementFromEnvUntyped = this.G.get(typeVar);
                if (replacementFromEnvUntyped instanceof TypeArgument) {
                    TypeArgument replacementFromEnv = (TypeArgument)replacementFromEnvUntyped;
                    TypeArgument replacement = TypeUtils.mergeTypeModifiers((TypeArgument)replacementFromEnv, (TypeRef)typeRef);
                    TypeRef replacementPrepared = this.prepareTypeVariableReplacement(typeVar, replacement);
                    result = replacementPrepared;
                } else if (replacementFromEnvUntyped instanceof List) {
                    List l_raw = (List)replacementFromEnvUntyped;
                    ArrayList l = CollectionLiterals.newArrayList();
                    int i = 0;
                    while (i < l_raw.size()) {
                        TypeArgument replacement = (TypeArgument)l_raw.get(i);
                        TypeRef replacementPrepared = this.prepareTypeVariableReplacement(typeVar, replacement);
                        l.add(replacementPrepared);
                        ++i;
                    }
                    if (typeVar.isDeclaredCovariant()) {
                        result = SubstTypeVariablesJudgment.this.typeSystemHelper.createIntersectionType(this.G, l.toArray(new TypeRef[l.size()]));
                    } else if (typeVar.isDeclaredContravariant()) {
                        result = SubstTypeVariablesJudgment.this.typeSystemHelper.createUnionType(this.G, l.toArray(new TypeRef[l.size()]));
                    } else {
                        RuleEnvironmentExtensions.addInconsistentSubstitutions(this.G, typeVar, l);
                        result = SubstTypeVariablesJudgment.unknown();
                    }
                    TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)typeRef);
                }
            }
            if (typeRefDeclType != null && typeRefDeclType.isGeneric()) {
                EList typeParams = typeRefDeclType.getTypeVars();
                EList typeArgs = typeRef.getTypeArgs();
                int lenParams = typeParams.size();
                int lenArgs = typeArgs.size();
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                TypeArgument[] argsChanged = new TypeArgument[lenArgs];
                boolean haveSubstitution = false;
                int i = 0;
                while (i < lenArgs) {
                    TypeArgument arg;
                    boolean captureContainedWildcardsNEW = (arg = (TypeArgument)typeArgs.get(i)) instanceof Wildcard ? this.captureContainedWildcards : false;
                    TypeArgument argSubst = this.substTypeVariables(G2, arg, captureContainedWildcardsNEW);
                    if (argSubst != arg) {
                        argsChanged[i] = argSubst;
                        haveSubstitution = true;
                    }
                    if (i < lenParams) {
                        TypeVariable param = (TypeVariable)typeParams.get(i);
                        RuleEnvironmentExtensions.addTypeMapping(G2, param, argSubst);
                    }
                    ++i;
                }
                if (haveSubstitution) {
                    if (result == typeRef) {
                        result = (TypeRef)TypeUtils.copy((EObject)typeRef);
                    }
                    i = 0;
                    while (i < lenArgs) {
                        TypeArgument argCh = argsChanged[i];
                        if (argCh != null) {
                            result.getTypeArgs().set(i, (Object)argCh);
                        }
                        ++i;
                    }
                }
            }
            if (result instanceof StructuralTypeRef) {
                result = SubstTypeVariablesJudgment.this.typeSystemHelper.substTypeVariablesInStructuralMembers(this.G, (StructuralTypeRef)result);
            }
            return result;
        }

        private TypeRef prepareTypeVariableReplacement(TypeVariable typeVar, TypeArgument replacementArg) {
            Pair guardKey;
            TypeRef replacement;
            if (replacementArg instanceof Wildcard) {
                if (this.captureUponSubstitution) {
                    replacement = TypeUtils.captureWildcard((Wildcard)((Wildcard)replacementArg));
                } else {
                    ExistentialTypeRef capture = TypeUtils.captureWildcard((Wildcard)((Wildcard)replacementArg));
                    capture.setReopened(true);
                    replacement = capture;
                }
            } else {
                replacement = (TypeRef)replacementArg;
            }
            Type replacementDeclType = replacement.getDeclaredType();
            if (typeVar != replacementDeclType && (TypeUtils.isOrContainsRefToTypeVar((EObject)replacement, (TypeVariable[])new TypeVariable[0]) || replacementDeclType != null && replacementDeclType.isGeneric()) && this.G.get(guardKey = Pair.of((Object)"substTypeVariablesInParameterizedTypeRef", (Object)replacement)) == null) {
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                G2.put(guardKey, Boolean.TRUE);
                replacement = this.substTypeVariables(G2, replacement, this.captureContainedWildcards);
            }
            replacement = (TypeRef)TypeUtils.copy((EObject)replacement);
            return replacement;
        }
    }
}

