/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

@Singleton
public class StatusHelper {
    private static final int NO_CODE = 0;

    public IStatus OK() {
        return Status.OK_STATUS;
    }

    public IStatus cancel() {
        return Status.CANCEL_STATUS;
    }

    public IStatus createCancel(String message) {
        return new Status(8, "org.eclipse.n4js", message);
    }

    public IStatus createInfo(String message) {
        return new Status(1, "org.eclipse.n4js", message);
    }

    public IStatus createError(String message) {
        return this.createError(message, 0);
    }

    public IStatus createError(String message, int code) {
        return this.createError(message, code, null);
    }

    public IStatus createError(Throwable t) {
        return this.createError(Strings.nullToEmpty((String)t.getMessage()), t);
    }

    public IStatus createError(String message, Throwable t) {
        return this.createError(message, 0, t);
    }

    public IStatus createError(String message, int code, Throwable t) {
        return new Status(4, "org.eclipse.n4js", code, message, t);
    }

    public MultiStatus createMultiError(String message) {
        return this.createMultiError(message, null);
    }

    public MultiStatus createMultiError(String message, Throwable cause) {
        return new MultiStatus("org.eclipse.n4js", 4, message, cause);
    }

    public MultiStatus createMultiStatus(String message) {
        return new MultiStatus("org.eclipse.n4js", 0, message, null);
    }
}

