/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.RuntimeEnvironmentsHelper;
import org.eclipse.n4js.runner.exceptions.DependencyCycleDetectedException;
import org.eclipse.n4js.runner.exceptions.InsolvableRuntimeEnvironmentException;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.n4js.ui.handler.GeneratedJsFileLocator;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.ui.IFileEditorInput;

public class SupportingRunnerPropertyTester
extends PropertyTester {
    private static final Logger LOGGER = Logger.getLogger(SupportingRunnerPropertyTester.class);
    public static final String PROPERTY_NAMESPACE = "org.eclipse.n4js.runner.ui";
    public static final String PROPERTY_IS_SUPPORTING_RUNNER = "isSupportingRunner";
    @Inject
    private RuntimeEnvironmentsHelper hRuntimeEnvironments;
    @Inject
    private IN4JSCore in4jsCore;
    @Inject
    private RunnerRegistry runnerRegistry;
    @Inject
    private GeneratedJsFileLocator generatedFileLocator;

    public SupportingRunnerPropertyTester() {
        N4JSActivator.getInstance().getInjector("org.eclipse.n4js.N4JS").injectMembers((Object)this);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean haveCustomNodeRuntimeEnvironment;
        IRunnerDescriptor runnerDesc;
        if (!PROPERTY_IS_SUPPORTING_RUNNER.equals(property)) {
            LOGGER.debug((Object)("invoked wrong property to test : " + property));
            return false;
        }
        Optional<IFile> file = this.getFileFromInput(receiver);
        if (!file.isPresent()) {
            return false;
        }
        if (!this.generatedFileLocator.tryGetGeneratedSourceForN4jsFile((IFile)file.get()).isPresent()) {
            return false;
        }
        Object arg0 = args[0];
        if (!(arg0 instanceof String)) {
            LOGGER.debug((Object)"invalid runner key value, should be String");
            return false;
        }
        String runnerId = arg0.toString();
        try {
            runnerDesc = this.runnerRegistry.getDescriptor(runnerId);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("invalid runner key value, no runner found for id: " + runnerId));
            return false;
        }
        ArrayList compatibleRuntimeEnvironmets = Lists.newArrayList();
        try {
            compatibleRuntimeEnvironmets.addAll(this.findCompatibleRuntimeEnvironments((IFile)file.get()));
        }
        catch (DependencyCycleDetectedException | InsolvableRuntimeEnvironmentException e) {
            LOGGER.info((Object)e.getMessage());
            return false;
        }
        if ("org.eclipse.n4js.runner.nodejs.NODEJS".equals(runnerDesc.getId()) && !(haveCustomNodeRuntimeEnvironment = this.hRuntimeEnvironments.findRuntimeEnvironmentProject(RuntimeEnvironment.NODEJS).isPresent())) {
            return true;
        }
        if (!compatibleRuntimeEnvironmets.isEmpty() && "RE_NodeJS_Mangelhaft".equals(((RuntimeEnvironment)compatibleRuntimeEnvironmets.get(0)).getProjectName().getRawName())) {
            return true;
        }
        boolean runnerToTestIsCompatible = compatibleRuntimeEnvironmets.contains(runnerDesc.getEnvironment());
        if (!runnerToTestIsCompatible) {
            LOGGER.debug((Object)("Runner with id '" + runnerId + "' does not support running selected file."));
            return false;
        }
        return true;
    }

    private Set<RuntimeEnvironment> findCompatibleRuntimeEnvironments(IFile file) {
        String pathName = file.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        return this.findCompatibleRuntimeEnvironments(uri);
    }

    private Optional<IFile> getFileFromInput(Object input) {
        if (input instanceof IFile) {
            return Optional.fromNullable((Object)((IFile)input));
        }
        if (input instanceof IFileEditorInput) {
            return Optional.fromNullable((Object)((IFileEditorInput)input).getFile());
        }
        LOGGER.debug((Object)("Unsupported input selection : " + input.getClass().getName()));
        return Optional.absent();
    }

    private Set<RuntimeEnvironment> findCompatibleRuntimeEnvironments(URI uri) {
        Optional project = this.in4jsCore.findProject(uri);
        if (!project.isPresent()) {
            LOGGER.debug((Object)("Cannot obtain " + IN4JSProject.class.getName() + " for " + uri.toFileString()));
            LOGGER.error((Object)"Cannot resolve runner as no project corresponding to the selection found.");
            return Collections.emptySet();
        }
        return this.hRuntimeEnvironments.findCompatibleRuntimeEnvironments((IN4JSProject)project.get());
    }
}

