/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.imports;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.n4js.formatting2.FormattingUserPreferenceHelper;
import org.eclipse.n4js.ide.imports.ImportDescriptor;
import org.eclipse.n4js.ide.imports.ImportHelper;
import org.eclipse.n4js.ide.imports.ImportRegionHelper;
import org.eclipse.n4js.ide.server.codeActions.util.ChangeProvider;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.organize.imports.ImportSpecifiersUtil;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.utils.nodemodel.NodeModelUtilsN4;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class ImportOrganizer {
    @Inject
    private ImportHelper importHelper;
    @Inject
    private ImportRegionHelper importRegionHelper;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private FormattingUserPreferenceHelper formattingUserPreferenceHelper;

    public List<TextEdit> organizeImports(Document document, Script script, Collection<ImportDescriptor> importsToBeAdded, CancelIndicator cancelIndicator) {
        N4JSResource resource = (N4JSResource)script.eResource();
        resource.performPostProcessing(cancelIndicator);
        List<ImportDeclaration> importDecls = script.getScriptElements().stream().filter(ImportDeclaration.class::isInstance).map(ImportDeclaration.class::cast).collect(Collectors.toList());
        SortedSet<ImportDescriptor> importDescs = this.createImportDescriptors(importDecls);
        importDescs.addAll(importsToBeAdded);
        List<Object> textEdits = new ArrayList();
        int offsetOfFirstImport = Integer.MAX_VALUE;
        for (ImportDeclaration importDecl : importDecls) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)importDecl);
            int offset = node.getOffset();
            int length = NodeModelUtilsN4.getNodeLengthWithASISupport((INode)node);
            TextEdit edit = ChangeProvider.removeText(document, offset, length, true);
            textEdits.add(edit);
            offsetOfFirstImport = Math.min(offsetOfFirstImport, node.getOffset());
        }
        textEdits = ChangeProvider.closeGapsIfEmpty(document, textEdits);
        if (offsetOfFirstImport == Integer.MAX_VALUE) {
            offsetOfFirstImport = this.importRegionHelper.findInsertionOffset(script);
        }
        String spacing = this.formattingUserPreferenceHelper.getSpacingPreference((Resource)resource);
        String[] importStrings = (String[])importDescs.stream().map(importDesc -> importDesc.toCode(spacing, this.valueConverterService, this.grammarAccess)).toArray(String[]::new);
        if (importStrings.length > 0) {
            TextEdit edit = ChangeProvider.insertLinesAbove(document, offsetOfFirstImport, false, importStrings);
            textEdits.add(edit);
        }
        return textEdits;
    }

    private SortedSet<ImportDescriptor> createImportDescriptors(List<ImportDeclaration> importDecls) {
        TreeSet<ImportDescriptor> result = new TreeSet<ImportDescriptor>();
        int idx = 0;
        for (ImportDeclaration importDecl : importDecls) {
            if (importDecl.isBare()) {
                if (ImportSpecifiersUtil.isBrokenImport((ImportDeclaration)importDecl)) continue;
                ImportDescriptor importDesc = this.importHelper.createImportDescriptorFromAST(importDecl, null, idx++);
                result.add(importDesc);
                continue;
            }
            for (ImportSpecifier importSpec : importDecl.getImportSpecifiers()) {
                if (!importSpec.isFlaggedUsedInCode() || ImportSpecifiersUtil.isBrokenImport((ImportSpecifier)importSpec)) continue;
                ImportDescriptor importDesc = this.importHelper.createImportDescriptorFromAST(importDecl, importSpec, idx++);
                result.add(importDesc);
            }
        }
        return result;
    }
}

