/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.n4js.internal.AbstractSourceContainer;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.OSInfo;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

public class N4JSProjectSourceContainer
extends AbstractSourceContainer
implements IN4JSSourceContainer {
    private final N4JSProject project;

    protected N4JSProjectSourceContainer(N4JSProject project, SourceContainerType type, String relativeLocation) {
        super(type, relativeLocation);
        this.project = project;
    }

    @Override
    public IN4JSProject getProject() {
        return this.project;
    }

    @Override
    public SafeURI<?> findArtifact(QualifiedName name, Optional<String> fileExtension) {
        return this.project.getModel().findArtifact(this, name, fileExtension);
    }

    @Override
    public SafeURI<?> getLocation() {
        String location = this.getRelativeLocation();
        if (!Strings.isEmpty((String)location)) {
            String linuxPath = OSInfo.isWindows() ? location.replace(File.separatorChar, '/') : location;
            return this.project.getLocation().appendPath(linuxPath);
        }
        return this.project.getLocation();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof N4JSProjectSourceContainer)) {
            return false;
        }
        N4JSProjectSourceContainer other = (N4JSProjectSourceContainer)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

