/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.SerializingDataCollector;
import org.eclipse.n4js.smith.TimedDataCollector;

public enum DataCollectors {
    INSTANCE;

    private final Map<String, DataCollector> collectors = new HashMap<String, DataCollector>();
    private final AtomicBoolean pauseAllCollectors = new AtomicBoolean(true);

    public DataCollector getOrCreateDataCollector(String key) {
        return this.getOrCreateDataCollector(key, null);
    }

    public DataCollector getOrCreateSerialDataCollector(String key) {
        return this.getOrCreateSerialDataCollector(key, null);
    }

    public DataCollector getOrCreateDataCollector(String key, DataCollector parent) {
        return this.get(key, parent, false);
    }

    public DataCollector getOrCreateSerialDataCollector(String key, DataCollector parent) {
        DataCollector result = this.get(key, parent, true);
        Preconditions.checkState((boolean)(result instanceof SerializingDataCollector));
        return result;
    }

    private synchronized DataCollector get(String key, DataCollector parent, boolean serial) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new IllegalArgumentException("DataCollector key cannot be null or empty");
        }
        DataCollector collector = null;
        if (parent == null) {
            collector = this.collectors.get(key);
            if (collector == null) {
                collector = this.createCollector(key, serial);
                this.collectors.put(key, collector);
            }
        } else {
            collector = parent.getChild(key);
            if (collector == null) {
                collector = this.createCollector(key, serial);
                parent.addChild(collector);
            }
        }
        return collector;
    }

    private DataCollector createCollector(String key, boolean serial) {
        DataCollector collector = new TimedDataCollector(key);
        if (serial) {
            collector = new SerializingDataCollector(collector);
        }
        ((DataCollector)collector).setPaused(this.pauseAllCollectors.get());
        return collector;
    }

    Map<String, DataCollector> getRootCollectors() {
        return Collections.unmodifiableMap(this.collectors);
    }

    synchronized void setPaused(boolean paused) {
        this.pauseAllCollectors.set(paused);
        this.collectors.values().forEach(collector -> collector.setPaused(paused));
    }

    public void warn(String msg) {
        if (!this.pauseAllCollectors.get()) {
            System.err.println("WARNING: " + msg);
        }
    }
}

