/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.conversion.ValueConverterUtils;
import org.eclipse.n4js.regex.regularExpression.CharacterClassEscapeSequence;
import org.eclipse.n4js.regex.regularExpression.CharacterClassRange;
import org.eclipse.n4js.regex.regularExpression.ControlLetterEscapeSequence;
import org.eclipse.n4js.regex.regularExpression.DecimalEscapeSequence;
import org.eclipse.n4js.regex.regularExpression.Group;
import org.eclipse.n4js.regex.regularExpression.RegularExpressionFlags;
import org.eclipse.n4js.regex.regularExpression.RegularExpressionLiteral;
import org.eclipse.n4js.regex.regularExpression.RegularExpressionPackage;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;

@Singleton
public class RegExLiteralConverter
extends AbstractValueConverter<String> {
    private static final String UNICODE_REGEX = "u";
    public static final String ISSUE_CODE = "RegExLiteralConverter.bogus.regex";
    private IParser regexParser;
    private final IResourceServiceProvider.Registry serviceProviders;

    @Inject
    public RegExLiteralConverter(IResourceServiceProvider.Registry serviceProviders) {
        this.serviceProviders = serviceProviders;
    }

    public String toString(String value) {
        return value;
    }

    private IParser getRegexParser() {
        if (this.regexParser == null) {
            IResourceServiceProvider serviceProvider = this.serviceProviders.getResourceServiceProvider(URI.createURI((String)"a.regex"));
            this.regexParser = (IParser)serviceProvider.get(IParser.class);
        }
        return this.regexParser;
    }

    public String toValue(String string, INode node) {
        ValueConverterUtils.StringConverterResult stringConverterResult = RegExLiteralConverter.convertFromJS(string, node);
        String escaped = stringConverterResult.getValue();
        IParseResult parseResult = this.getRegexParser().parse((Reader)new StringReader(escaped));
        Iterable syntaxErrors = parseResult.getSyntaxErrors();
        Iterator iterator = syntaxErrors.iterator();
        ArrayList<N4JSValueConverterWithValueException> errors = new ArrayList<N4JSValueConverterWithValueException>();
        int offsetFixup = -1;
        while (iterator.hasNext()) {
            INode syntaxError = (INode)iterator.next();
            String message = syntaxError.getSyntaxErrorMessage().getMessage();
            int localOffset = syntaxError.getOffset();
            if (message.contains("'<EOF>' expecting '/'")) {
                if (offsetFixup == -1) {
                    offsetFixup = node.getOffset() - node.getTotalOffset();
                }
                N4JSValueConverterWithValueException mainError = new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, stringConverterResult.getSourceOffset(localOffset) + offsetFixup, syntaxError.getLength(), string, null);
                errors.add(0, mainError);
                continue;
            }
            if (offsetFixup == -1) {
                offsetFixup = node.getOffset() - node.getTotalOffset();
            }
            errors.add(new BogusRegExLiteralException(message, node, string, stringConverterResult.getSourceOffset(localOffset) + offsetFixup, syntaxError.getLength()));
        }
        RegularExpressionLiteral literal = (RegularExpressionLiteral)parseResult.getRootASTElement();
        RegularExpressionFlags flags = literal.getFlags();
        boolean hasUnicodeFlag = flags != null && flags.getFlags().contains((Object)UNICODE_REGEX);
        TreeIterator regExIterator = literal.eAllContents();
        while (regExIterator.hasNext()) {
            Group group;
            EObject element = (EObject)regExIterator.next();
            if (hasUnicodeFlag) {
                if (element instanceof DecimalEscapeSequence) {
                    ICompositeNode nodeForElement = NodeModelUtils.findActualNodeFor((EObject)element);
                    if (offsetFixup == -1) {
                        offsetFixup = node.getOffset() - node.getTotalOffset();
                    }
                    errors.add(new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, stringConverterResult.getSourceOffset(nodeForElement.getOffset()) + offsetFixup, nodeForElement.getLength(), string, null));
                } else if (element instanceof ControlLetterEscapeSequence) {
                    List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)RegularExpressionPackage.Literals.CONTROL_LETTER_ESCAPE_SEQUENCE__SEQUENCE);
                    INode featureNode = (INode)nodesForFeature.get(0);
                    if (((ControlLetterEscapeSequence)element).getSequence().length() <= 2) {
                        if (offsetFixup == -1) {
                            offsetFixup = node.getOffset() - node.getTotalOffset();
                        }
                        errors.add(new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, stringConverterResult.getSourceOffset(featureNode.getOffset()) + offsetFixup, featureNode.getLength(), string, null));
                    }
                } else if (element instanceof CharacterClassRange) {
                    ICompositeNode nodeForElement;
                    CharacterClassRange casted = (CharacterClassRange)element;
                    if (casted.getLeft() instanceof CharacterClassEscapeSequence) {
                        nodeForElement = NodeModelUtils.findActualNodeFor((EObject)casted.getLeft());
                        if (offsetFixup == -1) {
                            offsetFixup = node.getOffset() - node.getTotalOffset();
                        }
                        errors.add(new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, stringConverterResult.getSourceOffset(nodeForElement.getOffset()) + offsetFixup, nodeForElement.getLength(), string, null));
                    }
                    if (casted.getRight() instanceof CharacterClassEscapeSequence) {
                        nodeForElement = NodeModelUtils.findActualNodeFor((EObject)casted.getRight());
                        if (offsetFixup == -1) {
                            offsetFixup = node.getOffset() - node.getTotalOffset();
                        }
                        errors.add(new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, stringConverterResult.getSourceOffset(nodeForElement.getOffset()) + offsetFixup, nodeForElement.getLength(), string, null));
                    }
                }
            }
            if (!(element instanceof Group) || (group = (Group)element).getName() == null) continue;
            List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)group, (EStructuralFeature)RegularExpressionPackage.Literals.GROUP__NAME);
            INode nameNode = (INode)nodesForFeature.get(0);
            if (offsetFixup == -1) {
                offsetFixup = node.getOffset() - node.getTotalOffset();
            }
            errors.add(new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_NAMED_GROUP(), "VCO_REGEX_NAMED_GROUP", node, stringConverterResult.getSourceOffset(nameNode.getOffset()) + offsetFixup, nameNode.getLength(), string, null));
        }
        if (!errors.isEmpty()) {
            N4JSValueConverterWithValueException mainError = (N4JSValueConverterWithValueException)((Object)errors.remove(0));
            for (N4JSValueConverterWithValueException other : errors) {
                mainError.addSuppressed((Throwable)((Object)other));
            }
            throw mainError;
        }
        return string;
    }

    private static ValueConverterUtils.StringConverterResult convertFromJS(String jsString, INode node) {
        ValueConverterUtils.StringConverterResult result = ValueConverterUtils.convertFromEscapedString(jsString, false, true, false, null);
        if (result.hasError()) {
            int offsetFixup = node.getOffset() - node.getTotalOffset();
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_ILLEGAL_ESCAPE(jsString), "VCO_REGEX_ILLEGAL_ESCAPE", node, result.getErrorOffset() + offsetFixup, 1, result.getValue(), null);
        }
        return result;
    }

    public static class BogusRegExLiteralException
    extends N4JSValueConverterWithValueException {
        private static final long serialVersionUID = 1L;

        public BogusRegExLiteralException(String message, INode node, String value, int offset, int length) {
            super(message, RegExLiteralConverter.ISSUE_CODE, node, offset, length, value, null);
        }
    }
}

