/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.N4JSLanguageConstants;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;

public final class N4JSLanguageHelper {
    public static boolean OPAQUE_JS_MODULES = true;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private IN4JSCore n4jsCore;
    private final Supplier<Collection<String>> reservedKeywordSupplier = Suppliers.memoize(() -> this.getKeywordAlternatives(this.grammarAccess.getReservedWordRule()));
    private final Supplier<Collection<String>> n4KeywordSupplier = Suppliers.memoize(() -> this.getKeywordAlternatives(this.grammarAccess.getN4KeywordRule()));

    public Collection<String> getECMAKeywords() {
        return (Collection)this.reservedKeywordSupplier.get();
    }

    public Collection<String> getN4Keywords() {
        return (Collection)this.n4KeywordSupplier.get();
    }

    public boolean isReservedIdentifier(String identifier) {
        return this.getECMAKeywords().contains(identifier) || N4JSLanguageConstants.ACCESS_MODIFIERS.contains(identifier) || N4JSLanguageConstants.GETTER_SETTER.contains(identifier) || N4JSLanguageConstants.BASE_TYPES.contains(identifier) || N4JSLanguageConstants.BOOLEAN_LITERALS.contains(identifier);
    }

    private Collection<String> getKeywordAlternatives(ParserRule rule) {
        EList ruleAlternatives = rule.getAlternatives().eContents();
        return ruleAlternatives.stream().filter(alternative -> alternative instanceof Keyword).map(keyword -> ((Keyword)keyword).getValue()).collect(Collectors.toList());
    }

    public boolean isOpaqueModule(URI resourceURI) {
        ResourceType resourceType = ResourceType.getResourceType(resourceURI);
        switch (resourceType) {
            case JS: 
            case JSX: {
                return OPAQUE_JS_MODULES;
            }
            case N4JS: 
            case N4JSX: 
            case N4IDL: {
                IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(resourceURI).orNull();
                if (project == null) {
                    return false;
                }
                ProjectType projectType = project.getProjectType();
                return projectType == ProjectType.DEFINITION;
            }
        }
        return false;
    }
}

