/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.JSXAbstractElement;
import org.eclipse.n4js.n4JS.JSXAttribute;
import org.eclipse.n4js.n4JS.JSXChild;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXExpression;
import org.eclipse.n4js.n4JS.JSXFragment;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.JSXSpreadAttribute;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4jsx.ReactHelper;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class JSXTransformation
extends Transformation {
    private SymbolTableEntryOriginal steForJsxBackendNamespace;
    private SymbolTableEntryOriginal steForJsxBackendElementFactoryFunction;
    private SymbolTableEntryOriginal steForJsxBackendFragmentComponent;
    @Inject
    private ReactHelper reactHelper;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        boolean inJSX;
        ResourceType resourceType = ResourceType.getResourceType((Resource)this.getState().resource);
        boolean bl = inJSX = resourceType == ResourceType.JSX || resourceType == ResourceType.N4JSX;
        if (!inJSX) {
            return;
        }
        List jsxAbstractElements = this.collectNodes((EObject)this.getState().im, JSXAbstractElement.class, true);
        boolean _isEmpty = jsxAbstractElements.isEmpty();
        if (_isEmpty) {
            return;
        }
        this.steForJsxBackendNamespace = this.prepareImportOfJsxBackend();
        this.steForJsxBackendElementFactoryFunction = this.prepareElementFactoryFunction();
        this.steForJsxBackendFragmentComponent = this.prepareFragmentComponent();
        Consumer<JSXAbstractElement> _function = it -> this.transformJSXAbstractElement((JSXAbstractElement)it);
        jsxAbstractElements.forEach(_function);
    }

    private SymbolTableEntryOriginal prepareImportOfJsxBackend() {
        TModule jsxBackendModule = this.reactHelper.getJsxBackendModule((Resource)this.getState().resource);
        if (jsxBackendModule == null) {
            URI _uRI = this.getState().resource.getURI();
            String _plus = "cannot locate JSX backend for N4JSX resource " + _uRI;
            throw new RuntimeException(_plus);
        }
        Functions.Function1 _function = impDeclIM -> {
            TModule _importedModule = this.getState().info.getImportedModule(impDeclIM);
            return _importedModule == jsxBackendModule;
        };
        Functions.Function1 _function_1 = it -> it.getImportSpecifiers();
        NamespaceImportSpecifier existingNamespaceImportOfReactIM = (NamespaceImportSpecifier)IterableExtensions.head((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this.getState().im.getScriptElements(), ImportDeclaration.class), (Functions.Function1)_function), (Functions.Function1)_function_1)), NamespaceImportSpecifier.class));
        if (existingNamespaceImportOfReactIM != null) {
            existingNamespaceImportOfReactIM.setFlaggedUsedInCode(true);
            return this.findSymbolTableEntryForNamespaceImport(existingNamespaceImportOfReactIM);
        }
        return this.addNamespaceImport(jsxBackendModule, this.reactHelper.getJsxBackendNamespaceName());
    }

    private SymbolTableEntryOriginal prepareElementFactoryFunction() {
        TFunction elementFactoryFunction = this.reactHelper.getJsxBackendElementFactoryFunction((Resource)this.getState().resource);
        if (elementFactoryFunction == null) {
            URI _uRI = this.getState().resource.getURI();
            String _plus = "cannot locate element factory function of JSX backend for N4JSX resource " + _uRI;
            throw new RuntimeException(_plus);
        }
        return this.getSymbolTableEntryOriginal((IdentifiableElement)elementFactoryFunction, true);
    }

    private SymbolTableEntryOriginal prepareFragmentComponent() {
        TClass fragmentComponent = this.reactHelper.getJsxBackendFragmentComponent((Resource)this.getState().resource);
        if (fragmentComponent == null) {
            URI _uRI = this.getState().resource.getURI();
            String _plus = "cannot locate fragment component of JSX backend for N4JSX resource " + _uRI;
            throw new RuntimeException(_plus);
        }
        return this.getSymbolTableEntryOriginal((IdentifiableElement)fragmentComponent, true);
    }

    private void transformJSXAbstractElement(JSXAbstractElement elem) {
        boolean _tripleEquals;
        Script_IM _containerOfType = (Script_IM)EcoreUtil2.getContainerOfType((EObject)elem, Script_IM.class);
        boolean bl = _tripleEquals = _containerOfType == null;
        if (_tripleEquals) {
            return;
        }
        this.replace((Expression)elem, (Expression)this.convertJSXAbstractElement(elem));
    }

    private ParameterizedCallExpression convertJSXAbstractElement(JSXAbstractElement elem) {
        List _xifexpression = null;
        if (elem instanceof JSXElement) {
            Expression _tagNameFromElement = this.getTagNameFromElement((JSXElement)elem);
            Expression _convertJSXAttributes = this.convertJSXAttributes((List<JSXAttribute>)((JSXElement)elem).getJsxAttributes());
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{_tagNameFromElement, _convertJSXAttributes}));
        } else {
            ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)this.steForJsxBackendNamespace, (SymbolTableEntry[])new SymbolTableEntry[]{this.steForJsxBackendFragmentComponent});
            NullLiteral __NULL = TranspilerBuilderBlocks._NULL();
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__PropertyAccessExpr, __NULL}));
        }
        List firstParams = _xifexpression;
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr_1 = TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)this.steForJsxBackendNamespace, (SymbolTableEntry[])new SymbolTableEntry[]{this.steForJsxBackendElementFactoryFunction});
        Functions.Function1 _function = it -> this.convertJSXChild((JSXChild)it);
        List _map = ListExtensions.map((List)elem.getJsxChildren(), (Functions.Function1)_function);
        Iterable _plus = Iterables.concat(firstParams, (Iterable)_map);
        return TranspilerBuilderBlocks._CallExpr((Expression)__PropertyAccessExpr_1, (Expression[])((Expression[])Conversions.unwrapArray((Object)_plus, Expression.class)));
    }

    private Expression convertJSXChild(JSXChild child) {
        ParameterizedCallExpression _switchResult = null;
        boolean _matched = false;
        if (child instanceof JSXElement) {
            _matched = true;
            _switchResult = this.convertJSXAbstractElement((JSXAbstractElement)child);
        }
        if (!_matched && child instanceof JSXFragment) {
            _matched = true;
            _switchResult = this.convertJSXAbstractElement((JSXAbstractElement)child);
        }
        if (!_matched && child instanceof JSXExpression) {
            _matched = true;
            _switchResult = ((JSXExpression)child).getExpression();
        }
        return _switchResult;
    }

    private Expression convertJSXAttributes(List<JSXAttribute> attrs) {
        boolean _isEmpty = attrs.isEmpty();
        if (_isEmpty) {
            return TranspilerBuilderBlocks._NULL();
        }
        if (attrs.size() == 1 && attrs.get(0) instanceof JSXSpreadAttribute) {
            JSXAttribute _get = attrs.get(0);
            return ((JSXSpreadAttribute)_get).getExpression();
        }
        IntPredicate _function = i -> {
            JSXAttribute _get_1 = (JSXAttribute)attrs.get(i);
            return _get_1 instanceof JSXSpreadAttribute;
        };
        int[] spreadIndices = IntStream.range(0, attrs.size()).filter(_function).toArray();
        ObjectLiteral _xifexpression = null;
        JSXAttribute _get_1 = attrs.get(0);
        if (_get_1 instanceof JSXSpreadAttribute) {
            _xifexpression = TranspilerBuilderBlocks._ObjLit();
        } else {
            ObjectLiteral _xblockexpression = null;
            int _xifexpression_1 = 0;
            boolean _isEmpty_1 = ((List)Conversions.doWrapArray((Object)spreadIndices)).isEmpty();
            boolean _not = !_isEmpty_1;
            _xifexpression_1 = _not ? spreadIndices[0] : attrs.size();
            int firstSpreadIndex = _xifexpression_1;
            Functions.Function1 _function_1 = it -> (JSXPropertyAttribute)it;
            List firstProps = ListExtensions.map(attrs.subList(0, firstSpreadIndex), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> this.convertJSXAttribute((JSXPropertyAttribute)it);
            _xifexpression = _xblockexpression = TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)ListExtensions.map((List)firstProps, (Functions.Function1)_function_2), PropertyAssignment.class)));
        }
        ObjectLiteral target = _xifexpression;
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(target);
        int i2 = 0;
        while (i2 < spreadIndices.length) {
            boolean _not;
            int curSpreadIdx = spreadIndices[i2];
            JSXAttribute _get_2 = attrs.get(curSpreadIdx);
            parameters.add(((JSXSpreadAttribute)_get_2).getExpression());
            int _xifexpression_1 = 0;
            int _length = spreadIndices.length;
            int _minus = _length - 1;
            boolean _lessThan = i2 < _minus;
            _xifexpression_1 = _lessThan ? spreadIndices[i2 + 1] : ((Object[])Conversions.unwrapArray(attrs, Object.class)).length;
            int nextSpreadIdx = _xifexpression_1;
            List<JSXAttribute> propsBetweenTwoSpreads = attrs.subList(curSpreadIdx + 1, nextSpreadIdx);
            boolean _isEmpty_1 = propsBetweenTwoSpreads.isEmpty();
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                Functions.Function1 _function_1 = it -> this.convertJSXAttribute((JSXPropertyAttribute)it);
                parameters.add(TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)ListExtensions.map(propsBetweenTwoSpreads, (Functions.Function1)_function_1), PropertyAssignment.class))));
            }
            ++i2;
        }
        ArrayList<Object> _converted_parameters = parameters;
        return TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)this.steFor_Object(), (SymbolTableEntry[])new SymbolTableEntry[]{this.steFor_Object_assign()}), (Expression[])((Expression[])Conversions.unwrapArray(_converted_parameters, Expression.class)));
    }

    private PropertyNameValuePair convertJSXAttribute(JSXPropertyAttribute attr) {
        return TranspilerBuilderBlocks._PropertyNameValuePair((String)this.getNameFromPropertyAttribute(attr), (Expression)this.getValueExpressionFromPropertyAttribute(attr));
    }

    private Expression getTagNameFromElement(JSXElement elem) {
        SymbolTableEntry id;
        Expression nameExpr = elem.getJsxElementName().getExpression();
        if (nameExpr instanceof IdentifierRef_IM && (id = ((IdentifierRef_IM)nameExpr).getId_IM()) == null) {
            return TranspilerBuilderBlocks._StringLiteral((String)((IdentifierRef_IM)nameExpr).getIdAsText());
        }
        return nameExpr;
    }

    private String getNameFromPropertyAttribute(JSXPropertyAttribute attr) {
        IdentifiableElement prop = attr.getProperty();
        if (prop != null && !prop.eIsProxy()) {
            return prop.getName();
        }
        return attr.getPropertyAsText();
    }

    private Expression getValueExpressionFromPropertyAttribute(JSXPropertyAttribute attr) {
        Expression _elvis = null;
        Expression _jsxAttributeValue = attr.getJsxAttributeValue();
        if (_jsxAttributeValue != null) {
            _elvis = _jsxAttributeValue;
        } else {
            BooleanLiteral __TRUE = TranspilerBuilderBlocks._TRUE();
            _elvis = __TRUE;
        }
        return _elvis;
    }
}

