/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.proposals.packagejson;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.ide.contentassist.CompletionUtils;
import org.eclipse.n4js.json.ui.contentassist.IJSONProposalProvider;
import org.eclipse.n4js.json.ui.contentassist.JSONProposalFactory;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class PackageJsonProposalProvider
implements IJSONProposalProvider {
    @Inject
    private XpectAwareFileExtensionCalculator fileExtensionCalculator;

    public boolean isResponsible(EObject eObject) {
        return this.fileExtensionCalculator.getFilenameWithoutXpectExtension(eObject.eResource().getURI()).equals("package.json");
    }

    public void complete_NameValuePair(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        JSONProposalFactory nvpFactory = (JSONProposalFactory)N4LanguageUtils.getServiceForContext((String)"json", JSONProposalFactory.class).get();
        List namePath = CompletionUtils.getJsonPathNames((EObject)model);
        Set alreadyUsedNames = CompletionUtils.getAlreadyUsedNames((EObject)model);
        List pathProps = PackageJsonProperties.valuesOfPath((List)namePath);
        for (PackageJsonProperties pathProp : pathProps) {
            String name = pathProp.name;
            if (alreadyUsedNames.contains(name) || !this.isMatchingPrefix(context, name)) continue;
            String value = "";
            String descr = pathProp.description;
            ICompletionProposal pairProposal = null;
            if (pathProp.valueType == JSONStringLiteral.class) {
                pairProposal = nvpFactory.createNameValueProposal(context, name, value, descr);
            }
            if (pathProp.valueType == JSONArray.class) {
                pairProposal = nvpFactory.createNameArrayProposal(context, name, value, descr);
            }
            if (pathProp.valueType == JSONObject.class) {
                pairProposal = nvpFactory.createNameObjectProposal(context, name, value, descr);
            }
            if (pairProposal == null) continue;
            acceptor.accept(pairProposal);
        }
    }

    private boolean isMatchingPrefix(ContentAssistContext context, String name) {
        return context.getMatcher().isCandidateMatchingPrefix(name, context.getPrefix());
    }

    public void complete_JSONArray(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_JSONObject(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }
}

