/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.outline;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.tests.outline.DisplaySafeSyncer;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineRefreshJob;

public class SyncableOutlinePage {
    private volatile DisplaySafeSyncer syncer = new DisplaySafeSyncer();
    private final OutlinePage page;

    SyncableOutlinePage(OutlinePage page) {
        this.page = page;
    }

    public void resetSyncer() throws InterruptedException {
        try {
            Method method = OutlinePage.class.getDeclaredMethod("getRefreshJob", new Class[0]);
            method.setAccessible(true);
            OutlineRefreshJob refreshPageJob = (OutlineRefreshJob)method.invoke((Object)this.page, new Object[0]);
            refreshPageJob.join();
            this.syncer.start();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void waitForUpdate(long timeout) throws TimeoutException, InterruptedException {
        this.syncer.awaitSignal(timeout);
    }

    protected void treeUpdated() {
        try {
            Method method = OutlinePage.class.getDeclaredMethod("treeUpdated", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.page, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.syncer.signal();
    }

    public TreeViewer getTreeViewer() {
        return this.page.getTreeViewer();
    }
}

