/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS.extensions;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableEnvironmentElement;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class SourceElementExtensions {
    @Inject
    @Extension
    private IResourceScopeCache cache;

    public List<IdentifiableElement> collectVisibleIdentifiableElements(VariableEnvironmentElement element) {
        Pair _mappedTo = Pair.of((Object)"collectVisibleIdentifiableElements", (Object)element);
        Provider _function = () -> {
            ArrayList _xblockexpression = null;
            ArrayList result = CollectionLiterals.newArrayList();
            boolean _matched = false;
            if (element instanceof IdentifiableElement) {
                _matched = true;
                result.add((IdentifiableElement)element);
            }
            if (!_matched && element instanceof FunctionExpression) {
                boolean _tripleNotEquals;
                String _name = ((FunctionExpression)element).getName();
                boolean bl = _tripleNotEquals = _name != null;
                if (_tripleNotEquals) {
                    _matched = true;
                    this.collectVisibleTypedElement((FunctionExpression)element, result);
                }
            }
            this.doCollectVisibleIdentifiableElements(element, (EObject)element, true, result);
            _xblockexpression = result;
            return _xblockexpression;
        };
        return (List)this.cache.get((Object)_mappedTo, element.eResource(), _function);
    }

    public List<IdentifiableElement> collectLocalArguments(VariableEnvironmentElement element) {
        Pair _mappedTo = Pair.of((Object)"collectLocalArguments", (Object)element);
        Provider _function = () -> {
            ArrayList _xblockexpression = null;
            ArrayList result = CollectionLiterals.newArrayList();
            if (element instanceof FunctionOrFieldAccessor && !(element instanceof ArrowFunction)) {
                result.add(((FunctionOrFieldAccessor)element).getLocalArgumentsVariable());
            }
            _xblockexpression = result;
            return _xblockexpression;
        };
        return (List)this.cache.get((Object)_mappedTo, element.eResource(), _function);
    }

    public Type getTypeOrPolyfilledType(TypeDefiningElement tde) {
        if (tde instanceof N4ClassDeclaration && (N4JSLanguageUtils.isPolyfill((AnnotableElement)tde) || N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)tde))) {
            TClass _definedTypeAsClass = ((N4ClassDeclaration)tde).getDefinedTypeAsClass();
            ParameterizedTypeRef _superClassRef = null;
            if (_definedTypeAsClass != null) {
                _superClassRef = _definedTypeAsClass.getSuperClassRef();
            }
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            Type filledType = _declaredType;
            return filledType;
        }
        return tde.getDefinedType();
    }

    private <T extends TypeDefiningElement> boolean collectVisibleTypedElement(T element, List<? super IdentifiableElement> addHere) {
        Functions.Function1 _function = e -> e.getDefinedType();
        return this.collectVisibleIdentifiableElement(element, addHere, (Functions.Function1<? super T, ? extends U>)_function);
    }

    private <T extends ExportedVariableDeclaration> boolean collectVisibleVariable(T element, List<? super IdentifiableElement> addHere) {
        Functions.Function1 _function = e -> e.getDefinedVariable();
        return this.collectVisibleIdentifiableElement(element, addHere, (Functions.Function1<? super T, ? extends U>)_function);
    }

    private <T extends TypableElement, U extends IdentifiableElement> boolean collectVisibleIdentifiableElement(T element, List<? super IdentifiableElement> addHere, Functions.Function1<? super T, ? extends U> calculateType) {
        boolean _xifexpression = false;
        if (calculateType != null) {
            boolean _xblockexpression = false;
            IdentifiableElement type = (IdentifiableElement)calculateType.apply(element);
            boolean _xifexpression_1 = false;
            if (type != null) {
                _xifexpression_1 = addHere.add((IdentifiableElement)type);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private void doCollectVisibleIdentifiableElements(VariableEnvironmentElement start, EObject element, boolean includeBlockScopedElements, List<? super IdentifiableElement> addHere) {
        TreeIterator allContents = element.eAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            boolean _matched = false;
            if (next instanceof N4ClassDeclaration) {
                _matched = true;
                Type polyfilledOrOriginalType = this.getTypeOrPolyfilledType((TypeDefiningElement)next);
                N4ClassDeclaration _xifexpression = null;
                if (polyfilledOrOriginalType instanceof TClass) {
                    N4ClassDeclaration _xblockexpression = null;
                    EObject _astElement = null;
                    if ((TClass)polyfilledOrOriginalType != null) {
                        _astElement = ((TClass)polyfilledOrOriginalType).getAstElement();
                    }
                    N4ClassDeclaration n4ClassDecl = (N4ClassDeclaration)_astElement;
                    N4ClassDeclaration _xifexpression_1 = null;
                    _xifexpression_1 = n4ClassDecl == null ? (N4ClassDeclaration)next : n4ClassDecl;
                    _xifexpression = _xblockexpression = _xifexpression_1;
                } else {
                    _xifexpression = (N4ClassDeclaration)next;
                }
                N4ClassDeclaration nonNullClassDecl = _xifexpression;
                this.collectVisibleTypedElement(nonNullClassDecl, addHere);
                allContents.prune();
            }
            if (!_matched && next instanceof N4InterfaceDeclaration) {
                _matched = true;
                this.collectVisibleTypedElement((N4InterfaceDeclaration)next, addHere);
                allContents.prune();
            }
            if (!_matched && next instanceof N4EnumDeclaration) {
                _matched = true;
                this.collectVisibleTypedElement((N4EnumDeclaration)next, addHere);
                allContents.prune();
            }
            if (!_matched && next instanceof FunctionDeclaration) {
                _matched = true;
                this.collectVisibleTypedElement((FunctionDeclaration)next, addHere);
                allContents.prune();
            }
            if (!_matched && next instanceof ExportedVariableDeclaration) {
                boolean _tripleNotEquals;
                String _name = ((ExportedVariableDeclaration)next).getName();
                boolean bl = _tripleNotEquals = _name != null;
                if (_tripleNotEquals) {
                    _matched = true;
                    this.collectVisibleVariable((ExportedVariableDeclaration)next, addHere);
                    allContents.prune();
                }
            }
            if (!_matched && next instanceof IdentifiableElement && !(next instanceof TypeVariable)) {
                _matched = true;
                boolean _isBlockScoped = N4JSASTUtils.isBlockScoped((IdentifiableElement)((IdentifiableElement)next));
                if (_isBlockScoped) {
                    if (includeBlockScopedElements) {
                        addHere.add((IdentifiableElement)((IdentifiableElement)next));
                    }
                } else {
                    boolean _belongsToScope = this.belongsToScope((IdentifiableElement)next, start);
                    if (_belongsToScope) {
                        addHere.add((IdentifiableElement)((IdentifiableElement)next));
                    }
                }
                allContents.prune();
            }
            if (!_matched && next instanceof Block) {
                _matched = true;
                this.doCollectVisibleIdentifiableElements(start, next, false, addHere);
                allContents.prune();
            }
            if (!_matched && next instanceof VariableEnvironmentElement) {
                _matched = true;
                this.doCollectVisibleIdentifiableElements(start, next, false, addHere);
                allContents.prune();
            }
            if (!_matched && next instanceof Expression) {
                _matched = true;
                allContents.prune();
            }
            if (_matched || !(next instanceof TypeRef)) continue;
            _matched = true;
            allContents.prune();
        }
    }

    private boolean belongsToScope(IdentifiableElement elem, VariableEnvironmentElement scope) {
        VariableEnvironmentElement _scope = N4JSASTUtils.getScope((IdentifiableElement)elem);
        return _scope == scope;
    }
}

