/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.n4js.ide.server.N4JSProtocolExtensions;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class N4JSLanguageServer
extends XLanguageServerImpl
implements N4JSProtocolExtensions {
    @Override
    protected Optional<List<String>> getSupportedCodeActionKinds() {
        return Optional.of((Object)Lists.newArrayList((Object[])new String[]{"quickfix", "source", "source.organizeImports"}));
    }

    @Override
    public CompletableFuture<String> documentContents(TextDocumentIdentifier param) {
        return this.getRequestManager().runRead("documentContents", cancelIndicator -> this.documentContents((CancelIndicator)cancelIndicator, param));
    }

    private String documentContents(CancelIndicator cancelIndicator, TextDocumentIdentifier param) {
        URI uri = this.getURI(param);
        XtextResource resource = this.getWorkspaceManager().getResource(uri);
        return this.getWorkspaceManager().getDocument(resource).getContents();
    }
}

