/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.common.collect.HashMultimap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.transpiler.utils.ConcreteMembersOrderedForTranspiler;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;

public class InformationRegistry {
    private final HashMultimap<Tag, EObject> hmTagged = HashMultimap.create();
    private final Map<ImportDeclaration, TModule> importedModules = new HashMap<ImportDeclaration, TModule>();
    private final Map<N4TypeDeclaration, Type> originalDefinedTypes = new HashMap<N4TypeDeclaration, Type>();
    private final Map<N4MemberDeclaration, TMember> originalDefinedMembers = new HashMap<N4MemberDeclaration, TMember>();
    private final Map<TClassifier, ConcreteMembersOrderedForTranspiler> cachedCMOFTs = new HashMap<TClassifier, ConcreteMembersOrderedForTranspiler>();

    public boolean isConsumedFromInterface(N4MemberDeclaration element) {
        return this.isTaggedAs(Tag.consumedFromInterface, (EObject)element);
    }

    public void markAsConsumedFromInterface(N4MemberDeclaration element) {
        this.tag(Tag.consumedFromInterface, (EObject)element);
    }

    public boolean isHiddenFromReflection(N4MemberDeclaration element) {
        return this.isTaggedAs(Tag.hiddenFromReflection, (EObject)element);
    }

    public void markAsHiddenFromReflection(N4MemberDeclaration element) {
        this.tag(Tag.hiddenFromReflection, (EObject)element);
    }

    private boolean isTaggedAs(Tag tag, EObject element) {
        return this.hmTagged.containsEntry((Object)tag, (Object)element);
    }

    private void tag(Tag tag, EObject element) {
        this.hmTagged.put((Object)tag, (Object)element);
    }

    public boolean isIntermediateModelElement(EObject eobj) {
        return TranspilerUtils.isIntermediateModelElement(eobj);
    }

    public TModule getImportedModule(ImportDeclaration importDeclInIM) {
        return this.getImportedModule(importDeclInIM, true);
    }

    public TModule getImportedModule(ImportDeclaration importDeclInIM, boolean assertIntermediateModel) {
        if (assertIntermediateModel) {
            TranspilerUtils.assertIntermediateModelElement((EObject)importDeclInIM);
        }
        return this.importedModules.get(importDeclInIM);
    }

    public void setImportedModule(ImportDeclaration importDeclInIM, TModule module) {
        TranspilerUtils.assertIntermediateModelElement((EObject)importDeclInIM);
        this.setImportedModule_internal(importDeclInIM, module);
    }

    public void setImportedModule_internal(ImportDeclaration importDeclInIM, TModule module) {
        this.importedModules.put(importDeclInIM, module);
    }

    public TEnum getOriginalDefinedType(N4EnumDeclaration elementInIM) {
        return (TEnum)this.getOriginalDefinedType((N4TypeDeclaration)elementInIM);
    }

    public TClassifier getOriginalDefinedType(N4ClassifierDeclaration elementInIM) {
        return (TClassifier)this.getOriginalDefinedType((N4TypeDeclaration)elementInIM);
    }

    public TClass getOriginalDefinedType(N4ClassDeclaration elementInIM) {
        return (TClass)this.getOriginalDefinedType((N4TypeDeclaration)elementInIM);
    }

    public TInterface getOriginalDefinedType(N4InterfaceDeclaration elementInIM) {
        return (TInterface)this.getOriginalDefinedType((N4TypeDeclaration)elementInIM);
    }

    public Type getOriginalDefinedType(N4TypeDeclaration elementInIM) {
        TranspilerUtils.assertIntermediateModelElement((EObject)elementInIM);
        return this.originalDefinedTypes.get(elementInIM);
    }

    public void setOriginalDefinedType(N4TypeDeclaration elementInIM, Type originalDefinedType) {
        TranspilerUtils.assertIntermediateModelElement((EObject)elementInIM);
        this.setOriginalDefinedType_internal(elementInIM, originalDefinedType);
    }

    public void setOriginalDefinedType_internal(N4TypeDeclaration elementInIM, Type originalDefinedType) {
        this.originalDefinedTypes.put(elementInIM, originalDefinedType);
    }

    public TMember getOriginalDefinedMember(N4MemberDeclaration elementInIM) {
        TranspilerUtils.assertIntermediateModelElement((EObject)elementInIM);
        return this.originalDefinedMembers.get(elementInIM);
    }

    public void setOriginalDefinedMember(N4MemberDeclaration elementInIM, TMember originalDefinedMember) {
        TranspilerUtils.assertIntermediateModelElement((EObject)elementInIM);
        this.setOriginalDefinedMember_internal(elementInIM, originalDefinedMember);
    }

    public void setOriginalDefinedMember_internal(N4MemberDeclaration elementInIM, TMember originalDefinedMember) {
        this.originalDefinedMembers.put(elementInIM, originalDefinedMember);
    }

    public ConcreteMembersOrderedForTranspiler getCachedCMOFT(TClassifier classifierDecl) {
        return this.cachedCMOFTs.get(classifierDecl);
    }

    public void cacheCMOFT(TClassifier classifierDecl, ConcreteMembersOrderedForTranspiler cmoft) {
        this.cachedCMOFTs.put(classifierDecl, cmoft);
    }

    private static enum Tag {
        consumedFromInterface,
        hiddenFromReflection;

    }
}

