/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataSeries;

public class DataCollectorCSVExporter {
    public static String toCSV(String key) {
        DataSeries dataSeries = CollectedDataAccess.getDataSeries(key);
        Set<DataSeries> allSeries = DataCollectorCSVExporter.collectAllSeries(dataSeries, new LinkedHashSet<DataSeries>());
        ArrayList<String> header = new ArrayList<String>();
        ArrayList<String> data = new ArrayList<String>();
        for (DataSeries s : allSeries) {
            header.add(s.name);
            data.add(Long.toString(s.sum));
        }
        String headerRow = header.stream().collect(Collectors.joining(";"));
        String dataRow = data.stream().collect(Collectors.joining(";"));
        return String.valueOf(headerRow) + "\n" + dataRow;
    }

    public static void toFile(File file, String key) throws IOException {
        File parentFolder = file.getParentFile();
        if (parentFolder != null) {
            if (parentFolder.exists() && !parentFolder.isDirectory()) {
                throw new IllegalStateException("Failed to store collected data to file " + file.getAbsolutePath() + ": Parent folder" + parentFolder.getAbsolutePath() + " is not a directory.");
            }
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter writer = new FileWriter(file);){
            writer.write(DataCollectorCSVExporter.toCSV(key));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Set<DataSeries> collectAllSeries(DataSeries series, Set<DataSeries> allSeries) {
        allSeries.add(series);
        series.getChildren().forEach(c -> DataCollectorCSVExporter.collectAllSeries(c, allSeries));
        return allSeries;
    }
}

