/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.lsp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class PatchedRemoteEndpoint
extends RemoteEndpoint {
    private static final Logger LOG = Logger.getLogger(RemoteEndpoint.class);
    private final Endpoint localEndpoint;
    private final Function<Throwable, ResponseError> exceptionHandler;
    private final MessageConsumer out;
    private final Map<String, CompletableFuture<?>> receivedRequestMap;

    public PatchedRemoteEndpoint(MessageConsumer out, Endpoint localEndpoint, Function<Throwable, ResponseError> exceptionHandler) {
        super(out, localEndpoint, exceptionHandler);
        this.localEndpoint = localEndpoint;
        this.exceptionHandler = exceptionHandler;
        this.out = out;
        try {
            Field field = RemoteEndpoint.class.getDeclaredField("receivedRequestMap");
            field.setAccessible(true);
            this.receivedRequestMap = (Map)field.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public PatchedRemoteEndpoint(MessageConsumer out, Endpoint localEndpoint) {
        this(out, localEndpoint, DEFAULT_EXCEPTION_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleCancellation(NotificationMessage notificationMessage) {
        if (MessageJsonHandler.CANCEL_METHOD.getMethodName().equals(notificationMessage.getMethod())) {
            Object cancelParams = notificationMessage.getParams();
            if (cancelParams != null) {
                if (cancelParams instanceof CancelParams) {
                    CompletableFuture<?> future;
                    String id = ((CancelParams)cancelParams).getId();
                    LOG.debug((Object)("Client cancels: " + id));
                    Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
                    synchronized (map) {
                        future = this.receivedRequestMap.remove(id);
                    }
                    if (future != null) {
                        future.cancel(true);
                    } else {
                        LOG.debug((Object)("Unmatched cancel notification for request id " + id));
                    }
                    return true;
                }
                LOG.warn((Object)("Cancellation support is disabled, since the '" + MessageJsonHandler.CANCEL_METHOD.getMethodName() + "' method has been registered explicitly."));
            } else {
                LOG.warn((Object)"Missing 'params' attribute of cancel notification.");
            }
        }
        return false;
    }

    protected void handleNotification(NotificationMessage notificationMessage) {
        if (!this.handleCancellation(notificationMessage)) {
            LOG.debug((Object)("Client notifies: " + notificationMessage.getMethod()));
            try {
                this.localEndpoint.notify(notificationMessage.getMethod(), notificationMessage.getParams());
            }
            catch (Exception exception) {
                LOG.debug((Object)("Notification threw an exception: " + notificationMessage), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(RequestMessage requestMessage) {
        CompletableFuture future;
        String messageId = requestMessage.getId();
        LOG.debug((Object)("Client requests: " + messageId + " / " + requestMessage.getMethod()));
        try {
            future = this.localEndpoint.request(requestMessage.getMethod(), requestMessage.getParams());
        }
        catch (Throwable throwable) {
            ResponseError errorObject = this.exceptionHandler.apply(throwable);
            if (errorObject == null) {
                errorObject = PatchedRemoteEndpoint.fallbackResponseError("Internal error. Exception handler provided no error object", throwable);
            }
            this.out.consume((Message)this.createErrorResponseMessage(requestMessage, errorObject));
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return;
        }
        Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
        synchronized (map) {
            this.receivedRequestMap.put(messageId, future);
        }
        ((CompletableFuture)((CompletableFuture)future.thenAccept(result -> {
            this.out.consume((Message)this.createResultResponseMessage(requestMessage, result));
            LOG.debug((Object)("Server response: " + messageId + " / " + requestMessage.getMethod()));
        })).exceptionally(t -> {
            ResponseMessage responseMessage;
            if (this.isCancellation((Throwable)t)) {
                String message = "The request (id: " + messageId + ", method: '" + requestMessage.getMethod() + "') has been cancelled";
                ResponseError errorObject = new ResponseError(ResponseErrorCode.RequestCancelled, message, null);
                responseMessage = this.createErrorResponseMessage(requestMessage, errorObject);
                LOG.debug((Object)("Server cancels: " + messageId + " / " + requestMessage.getMethod()));
            } else {
                ResponseError errorObject = this.exceptionHandler.apply((Throwable)t);
                if (errorObject == null) {
                    errorObject = PatchedRemoteEndpoint.fallbackResponseError("Internal error. Exception handler provided no error object", t);
                }
                responseMessage = this.createErrorResponseMessage(requestMessage, errorObject);
                LOG.debug((Object)("Server errors: " + messageId + " / " + requestMessage.getMethod()));
            }
            this.out.consume((Message)responseMessage);
            return null;
        })).thenApply(obj -> {
            Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
            synchronized (map) {
                this.receivedRequestMap.remove(messageId);
            }
            return null;
        });
    }

    private static ResponseError fallbackResponseError(String header, Throwable throwable) {
        LOG.error((Object)(String.valueOf(header) + ": " + throwable.getMessage()), throwable);
        ResponseError error = new ResponseError();
        error.setMessage(String.valueOf(header) + ".");
        error.setCode(ResponseErrorCode.InternalError);
        ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
        PrintWriter stackTraceWriter = new PrintWriter(stackTrace);
        throwable.printStackTrace(stackTraceWriter);
        stackTraceWriter.flush();
        error.setData((Object)stackTrace.toString());
        return error;
    }
}

