/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.n4js.ide.imports.ImportDescriptor;
import org.eclipse.n4js.ide.imports.ImportHelper;
import org.eclipse.n4js.ide.imports.ReferenceResolution;
import org.eclipse.n4js.ide.server.codeActions.Fix;
import org.eclipse.n4js.ide.server.codeActions.ICodeActionAcceptor;
import org.eclipse.n4js.ide.server.codeActions.QuickfixContext;
import org.eclipse.n4js.ide.server.codeActions.util.ChangeProvider;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.nodemodel.NodeModelUtilsN4;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;

@Singleton
public class N4JSQuickfixProvider {
    @Inject
    private ImportHelper importHelper;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking", multiFix=false)
    public void addImportForUnresolvedReference(QuickfixContext context, ICodeActionAcceptor acceptor) {
        Script script = context.resource.getScriptResolved();
        Document doc = context.options.getDocument();
        Diagnostic diagnostic = context.getDiagnostic();
        if (script == null || doc == null || diagnostic == null) {
            return;
        }
        EObject model = this.getEObject(context);
        List<ReferenceResolution> resolutions = this.importHelper.findResolutionsForUnresolvedReference(model, context.options.getCancelIndicator());
        for (ReferenceResolution resolution : resolutions) {
            ReplaceRegion replacement;
            ImportDescriptor importToBeAdded = resolution.importToBeAdded;
            if (importToBeAdded == null || (replacement = this.importHelper.getReplacementForImport(script, importToBeAdded)) == null) continue;
            String description = resolution.description;
            TextEdit textEdit = ChangeProvider.replace(doc, replacement);
            acceptor.acceptQuickfixCodeAction(context, "Add import from module " + description, Collections.singletonList(textEdit));
        }
    }

    @Fix(value="TYS_INVALID_TYPE_SYNTAX")
    public void transformJavaTypeAnnotationToColonStyle(QuickfixContext context, ICodeActionAcceptor acceptor) {
        EObject element = this.getEObject(context);
        if (!(element instanceof ParameterizedTypeRef)) {
            return;
        }
        ParameterizedTypeRef typeRef = (ParameterizedTypeRef)element;
        if (!(typeRef.eContainer() instanceof N4MethodDeclaration)) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)element);
        ICompositeNode parentNode = this.findParentNodeWithSemanticElementOfType(node, N4MethodDeclaration.class);
        INode roundBracketNode = NodeModelUtilsN4.findKeywordNode((ICompositeNode)parentNode, (String)")");
        List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)parentNode.getSemanticElement(), (EStructuralFeature)N4JSPackage.Literals.TYPED_ELEMENT__BOGUS_TYPE_REF);
        if (nodesForFeature.isEmpty()) {
            return;
        }
        INode bogusNode = (INode)nodesForFeature.get(0);
        Document doc = context.options.getDocument();
        String stringOfBogusType = NodeModelUtilsN4.getTokenTextWithHiddenTokens((INode)bogusNode);
        ILeafNode nodeAfterBogus = NodeModelUtils.findLeafNodeAtOffset((INode)parentNode, (int)bogusNode.getEndOffset());
        int spaceAfterBogusLength = nodeAfterBogus != null && nodeAfterBogus.getText().startsWith(" ") ? 1 : 0;
        int offsetBogusType = bogusNode.getOffset();
        int bogusTypeLength = stringOfBogusType.length();
        int offsetRoundBracket = roundBracketNode.getTotalOffset();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(ChangeProvider.replace(doc, offsetRoundBracket + 1, 0, ": " + stringOfBogusType));
        textEdits.add(ChangeProvider.replace(doc, offsetBogusType, bogusTypeLength + spaceAfterBogusLength, ""));
        acceptor.acceptQuickfixCodeAction(context, "Convert to colon style", textEdits);
    }

    @Fix(value="CLF_FIELD_OPTIONAL_OLD_SYNTAX")
    public void fixOldSyntaxForOptionalFields(QuickfixContext context, ICodeActionAcceptor acceptor) {
        Document doc = context.options.getDocument();
        int offsetNameEnd = this.getOffsetOfNameEnd(this.getEObject(context).eContainer());
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        int endOffset = doc.getOffSet(context.getDiagnostic().getRange().getEnd());
        textEdits.add(ChangeProvider.replace(doc, endOffset - 1, 1, ""));
        if (offsetNameEnd != -1) {
            textEdits.add(ChangeProvider.replace(doc, offsetNameEnd, 0, "?"));
        }
        acceptor.acceptQuickfixCodeAction(context, "Change to new syntax", textEdits);
    }

    @Fix(value="FUN_PARAM_OPTIONAL_WRONG_SYNTAX")
    public void fixOldSyntaxForOptionalFpars(QuickfixContext context, ICodeActionAcceptor acceptor) {
        Document doc = context.options.getDocument();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        int endOffset = doc.getOffSet(context.getDiagnostic().getRange().getEnd());
        textEdits.add(ChangeProvider.replace(doc, endOffset - 1, 1, " = undefined"));
        acceptor.acceptQuickfixCodeAction(context, "Change to Default Parameter", textEdits);
    }

    private int getOffsetOfNameEnd(EObject object) {
        ICompositeNode node;
        if (object instanceof N4FieldDeclaration) {
            N4FieldDeclaration fieldDecl = (N4FieldDeclaration)object;
            if (fieldDecl.isDeclaredOptional()) {
                return -1;
            }
            node = NodeModelUtils.findActualNodeFor((EObject)((PropertyNameOwner)object).getDeclaredName());
        } else if (object instanceof TField) {
            TField field = (TField)object;
            if (field.isOptional()) {
                return -1;
            }
            node = (INode)NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME).get(0);
        } else {
            return -1;
        }
        return node.getEndOffset();
    }

    private EObject getEObject(QuickfixContext context) {
        Document doc = context.options.getDocument();
        XtextResource resource = context.options.getResource();
        return this.getEObject(doc, resource, context.getDiagnostic().getRange());
    }

    private EObject getEObject(Document doc, XtextResource resource, Range range) {
        Position start = range.getStart();
        int startOffset = doc.getOffSet(start);
        return this.eObjectAtOffsetHelper.resolveContainedElementAt(resource, startOffset);
    }

    private ICompositeNode findParentNodeWithSemanticElementOfType(ICompositeNode node, Class<?> semanticElementType) {
        ICompositeNode parentNode = node.getParent();
        while (!parentNode.hasDirectSemanticElement() || !semanticElementType.isInstance(parentNode.getSemanticElement())) {
            parentNode = parentNode.getParent();
        }
        return parentNode;
    }
}

