/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;

public class N4JSExternalProject
extends ExternalProject {
    public static final String NATURE_ID = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    private final IN4JSProject externalPackage;
    private final Collection<IBuildConfiguration> referencedBuildConfigs;

    public N4JSExternalProject(File file, IN4JSProject externalPackage) {
        super(file, NATURE_ID, BUILDER_ID);
        Preconditions.checkArgument((boolean)(externalPackage.getLocation() instanceof FileURI));
        Preconditions.checkArgument((boolean)externalPackage.isExternal());
        this.externalPackage = externalPackage;
        this.referencedBuildConfigs = Sets.newHashSet();
    }

    public IBuildConfiguration[] internalGetReferencedBuildConfigs(String configName, boolean includeMissing) {
        IBuildConfiguration[] filteredConfigs = (IBuildConfiguration[])FluentIterable.from(this.referencedBuildConfigs).filter(config -> includeMissing ? true : config.getProject().exists()).toArray(IBuildConfiguration.class);
        return filteredConfigs;
    }

    boolean add(IBuildConfiguration config) {
        return this.referencedBuildConfigs.add(config);
    }

    public IN4JSProject getIProject() {
        return this.externalPackage;
    }

    public FileURI getSafeLocation() {
        return (FileURI)this.externalPackage.getLocation();
    }

    public FileURI getProjectDescriptionLocation() {
        return (FileURI)this.externalPackage.getProjectDescriptionLocation();
    }

    public ImmutableList<? extends IN4JSProject> getAllDirectDependencies() {
        return this.getIProject().getAllDirectDependencies();
    }

    public Iterable<N4JSProjectName> getAllDirectDependencyIds() {
        return FluentIterable.from(this.getAllDirectDependencies()).transform(p -> p.getProjectName()).toSet();
    }
}

