/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarManager
extends ContributionManager
implements IToolBarManager {
    private int itemStyle = 0;
    private ToolBar toolBar;
    private MenuManager contextMenuManager;

    public ToolBarManager() {
    }

    public ToolBarManager(int style) {
        this.itemStyle = style;
    }

    public ToolBarManager(ToolBar toolbar) {
        this();
        this.toolBar = toolbar;
        if (this.toolBarExist()) {
            this.itemStyle = this.toolBar.getStyle();
        }
    }

    public void setStyle(int style) {
        this.itemStyle = style;
    }

    public ToolBar createControl(Composite parent) {
        if (!this.toolBarExist() && parent != null) {
            this.toolBar = new ToolBar(parent, this.itemStyle);
            this.toolBar.setMenu(this.getContextMenuControl());
            this.update(true);
            this.toolBar.getAccessible().addAccessibleListener(this.getAccessibleListener());
        }
        return this.toolBar;
    }

    private AccessibleListener getAccessibleListener() {
        return new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String toolTip;
                ToolItem item;
                if (e.childID != -1 && (item = ToolBarManager.this.toolBar.getItem(e.childID)) != null && (toolTip = item.getToolTipText()) != null) {
                    e.result = toolTip;
                }
            }
        };
    }

    public void dispose() {
        IContributionItem[] items;
        if (this.toolBarExist()) {
            this.toolBar.dispose();
        }
        this.toolBar = null;
        IContributionItem[] iContributionItemArray = items = this.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.dispose();
            ++n2;
        }
        if (this.getContextMenuManager() != null) {
            this.getContextMenuManager().dispose();
            this.setContextMenuManager(null);
        }
        super.setOverrides(null);
    }

    public ToolBar getControl() {
        return this.toolBar;
    }

    protected void relayout(ToolBar layoutBar, int oldCount, int newCount) {
        if (oldCount != newCount && newCount != 0) {
            Point beforePack = layoutBar.getSize();
            layoutBar.pack(true);
            Point afterPack = layoutBar.getSize();
            if (beforePack.equals((Object)afterPack)) {
                return;
            }
            layoutBar.getParent().pack();
            layoutBar.getParent().requestLayout();
            if (layoutBar.getParent() instanceof CoolBar) {
                CoolItem[] items;
                CoolBar cb = (CoolBar)layoutBar.getParent();
                CoolItem[] coolItemArray = items = cb.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    CoolItem item = coolItemArray[n2];
                    if (item.getControl() == layoutBar) {
                        Point curSize = item.getSize();
                        item.setSize(curSize.x + (afterPack.x - beforePack.x), curSize.y + (afterPack.y - beforePack.y));
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean toolBarExist() {
        return this.toolBar != null && !this.toolBar.isDisposed();
    }

    @Override
    public void update(boolean force) {
        if (!this.isDirty() && !force) {
            return;
        }
        if (!this.toolBarExist()) {
            return;
        }
        int oldCount = this.toolBar.getItemCount();
        IContributionItem[] items = this.getItems();
        ArrayList<IContributionItem> clean = new ArrayList<IContributionItem>(items.length);
        IContributionItem separator = null;
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem ci = iContributionItemArray[n2];
            if (this.isChildVisible(ci)) {
                if (ci.isSeparator()) {
                    separator = ci;
                } else {
                    if (separator != null) {
                        if (clean.size() > 0) {
                            clean.add(separator);
                        }
                        separator = null;
                    }
                    clean.add(ci);
                }
            }
            ++n2;
        }
        ToolItem[] mi = this.toolBar.getItems();
        ArrayList<ToolItem> toRemove = new ArrayList<ToolItem>(mi.length);
        ToolItem[] toolItemArray = mi;
        int n3 = mi.length;
        int n4 = 0;
        while (n4 < n3) {
            Iterator data;
            ToolItem item = toolItemArray[n4];
            if (item != null && ((data = item.getData()) == null || !clean.contains(data) || data instanceof IContributionItem && ((IContributionItem)((Object)data)).isDynamic())) {
                toRemove.add(item);
            }
            ++n4;
        }
        try {
            this.toolBar.setRedraw(false);
            int i = toRemove.size();
            while (--i >= 0) {
                ToolItem item = (ToolItem)toRemove.get(i);
                if (item.isDisposed()) continue;
                Control ctrl = item.getControl();
                if (ctrl != null) {
                    item.setControl(null);
                    ctrl.dispose();
                }
                item.dispose();
            }
            mi = this.toolBar.getItems();
            int srcIx = 0;
            int destIx = 0;
            for (IContributionItem src : clean) {
                IContributionItem dest = srcIx < mi.length ? (IContributionItem)mi[srcIx].getData() : null;
                if (dest != null && src.equals(dest)) {
                    ++srcIx;
                    ++destIx;
                    continue;
                }
                if (dest != null && dest.isSeparator() && src.isSeparator()) {
                    mi[srcIx].setData((Object)src);
                    ++srcIx;
                    ++destIx;
                    continue;
                }
                int start = this.toolBar.getItemCount();
                src.fill(this.toolBar, destIx);
                int newItems = this.toolBar.getItemCount() - start;
                int i2 = 0;
                while (i2 < newItems) {
                    ToolItem item = this.toolBar.getItem(destIx++);
                    item.setData((Object)src);
                    ++i2;
                }
            }
            int i3 = mi.length;
            while (--i3 >= srcIx) {
                ToolItem item = mi[i3];
                if (item.isDisposed()) continue;
                Control ctrl = item.getControl();
                if (ctrl != null) {
                    item.setControl(null);
                    ctrl.dispose();
                }
                item.dispose();
            }
            this.setDirty(false);
        }
        finally {
            this.toolBar.setRedraw(true);
        }
        int newCount = this.toolBar.getItemCount();
        if (force) {
            oldCount = newCount + 1;
        }
        this.relayout(this.toolBar, oldCount, newCount);
    }

    private Menu getContextMenuControl() {
        if (this.contextMenuManager != null && this.toolBar != null) {
            Menu menuWidget = this.contextMenuManager.getMenu();
            if (menuWidget == null || menuWidget.isDisposed()) {
                menuWidget = this.contextMenuManager.createContextMenu((Control)this.toolBar);
            }
            return menuWidget;
        }
        return null;
    }

    public MenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public void setContextMenuManager(MenuManager contextMenuManager) {
        this.contextMenuManager = contextMenuManager;
        if (this.toolBar != null) {
            this.toolBar.setMenu(this.getContextMenuControl());
        }
    }

    private boolean isChildVisible(IContributionItem item) {
        IContributionManagerOverrides overrides = this.getOverrides();
        if (overrides == null) {
            return item.isVisible();
        }
        Boolean v = overrides.getVisible(item);
        return v != null ? v.booleanValue() : item.isVisible();
    }
}

